(define_code_iterator any_or[ior xor])
(define_code_iterator absneg[abs neg])
(define_expand "cmp<mode>_1"
  [(set (reg:CC FLAGS_REG)
	(compare:CC (match_operand:SWI48 0 "nonimmediate_operand" "")
		    (match_operand:SWI48 1 "<general_operand>" "")))])

(define_insn "*cmp<mode>_ccno_1"
  [(set (reg FLAGS_REG)
	(compare (match_operand:SWI 0 "nonimmediate_operand" "<r>,?m<r>")
		 (match_operand:SWI 1 "const0_operand" "")))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "@
   test{<imodesuffix>}\t%0, %0
   cmp{<imodesuffix>}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test,icmp")
   (set_attr "length_immediate" "0,1")
   (set_attr "mode" "<MODE>")])

(define_insn "*cmp<mode>_1"
  [(set (reg FLAGS_REG)
	(compare (match_operand:SWI 0 "nonimmediate_operand" "<r>m,<r>")
		 (match_operand:SWI 1 "<general_operand>" "<r><i>,<r>m")))]
  "ix86_match_ccmode (insn, CCmode)"
  "cmp{<imodesuffix>}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "<MODE>")])

(define_insn "*cmp<mode>_minus_1"
  [(set (reg FLAGS_REG)
	(compare
	  (minus:SWI (match_operand:SWI 0 "nonimmediate_operand" "<r>m,<r>")
		     (match_operand:SWI 1 "<general_operand>" "<r><i>,<r>m"))
	  (const_int 0)))]
  "ix86_match_ccmode (insn, CCGOCmode)"
  "cmp{<imodesuffix>}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "<MODE>")])

(define_insn "*cmpqi_ext_1"
  [(set (reg FLAGS_REG)
	(compare
	  (match_operand:QI 0 "general_operand" "Qm")
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%h1, %0|%0, %h1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_1_rex64"
  [(set (reg FLAGS_REG)
	(compare
	  (match_operand:QI 0 "register_operand" "Q")
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%h1, %0|%0, %h1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_2"
  [(set (reg FLAGS_REG)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "const0_operand" "")))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t%h0, %h0"
  [(set_attr "type" "test")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_expand "cmpqi_ext_3"
  [(set (reg:CC FLAGS_REG)
	(compare:CC
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "immediate_operand" "")))])

(define_insn "*cmpqi_ext_3_insn"
  [(set (reg FLAGS_REG)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "general_operand" "Qmn")))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "modrm" "1")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_3_insn_rex64"
  [(set (reg FLAGS_REG)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "nonmemory_operand" "Qn")))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "modrm" "1")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_4"
  [(set (reg FLAGS_REG)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)))]
  "ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%h1, %h0|%h0, %h1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])


(define_insn "*cmpfp_0"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP
	     (match_operand 1 "register_operand" "f")
	     (match_operand 2 "const0_operand" ""))]
	UNSPEC_FNSTSW))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])"
  "* return output_fp_compare (insn, operands, 0, 0);"
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))])


(define_insn_and_split "*cmpfp_0_cc"
  [(set (reg:CCFP FLAGS_REG)
	(compare:CCFP
	  (match_operand 1 "register_operand" "f")
	  (match_operand 2 "const0_operand" "")))
   (clobber (match_operand:HI 0 "register_operand" "=a"))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_SAHF && !TARGET_CMOVE
   && GET_MODE (operands[1]) == GET_MODE (operands[2])"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(unspec:HI
	  [(compare:CCFP (match_dup 1)(match_dup 2))]
	UNSPEC_FNSTSW))
   (set (reg:CC FLAGS_REG)
	(unspec:CC [(match_dup 0)] UNSPEC_SAHF))]
  ""
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))])

(define_insn "*cmpfp_xf"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP
	     (match_operand:XF 1 "register_operand" "f")
	     (match_operand:XF 2 "register_operand" "f"))]
	  UNSPEC_FNSTSW))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 0, 0);"
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set_attr "mode" "XF")])

(define_insn_and_split "*cmpfp_xf_cc"
  [(set (reg:CCFP FLAGS_REG)
	(compare:CCFP
	  (match_operand:XF 1 "register_operand" "f")
	  (match_operand:XF 2 "register_operand" "f")))
   (clobber (match_operand:HI 0 "register_operand" "=a"))]
  "TARGET_80387
   && TARGET_SAHF && !TARGET_CMOVE"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(unspec:HI
	  [(compare:CCFP (match_dup 1)(match_dup 2))]
	UNSPEC_FNSTSW))
   (set (reg:CC FLAGS_REG)
	(unspec:CC [(match_dup 0)] UNSPEC_SAHF))]
  ""
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set_attr "mode" "XF")])

(define_insn "*cmpfp_<mode>"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP
	     (match_operand:MODEF 1 "register_operand" "f")
	     (match_operand:MODEF 2 "nonimmediate_operand" "fm"))]
	  UNSPEC_FNSTSW))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 0, 0);"
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set_attr "mode" "<MODE>")])

(define_insn_and_split "*cmpfp_<mode>_cc"
  [(set (reg:CCFP FLAGS_REG)
	(compare:CCFP
	  (match_operand:MODEF 1 "register_operand" "f")
	  (match_operand:MODEF 2 "nonimmediate_operand" "fm")))
   (clobber (match_operand:HI 0 "register_operand" "=a"))]
  "TARGET_80387
   && TARGET_SAHF && !TARGET_CMOVE"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(unspec:HI
	  [(compare:CCFP (match_dup 1)(match_dup 2))]
	UNSPEC_FNSTSW))
   (set (reg:CC FLAGS_REG)
	(unspec:CC [(match_dup 0)] UNSPEC_SAHF))]
  ""
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set_attr "mode" "<MODE>")])

(define_insn "*cmpfp_u"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFPU
	     (match_operand 1 "register_operand" "f")
	     (match_operand 2 "register_operand" "f"))]
	  UNSPEC_FNSTSW))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])"
  "* return output_fp_compare (insn, operands, 0, 1);"
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))])

(define_insn_and_split "*cmpfp_u_cc"
  [(set (reg:CCFPU FLAGS_REG)
	(compare:CCFPU
	  (match_operand 1 "register_operand" "f")
	  (match_operand 2 "register_operand" "f")))
   (clobber (match_operand:HI 0 "register_operand" "=a"))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_SAHF && !TARGET_CMOVE
   && GET_MODE (operands[1]) == GET_MODE (operands[2])"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(unspec:HI
	  [(compare:CCFPU (match_dup 1)(match_dup 2))]
	UNSPEC_FNSTSW))
   (set (reg:CC FLAGS_REG)
	(unspec:CC [(match_dup 0)] UNSPEC_SAHF))]
  ""
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))])

(define_insn "*cmpfp_<mode>"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP
	     (match_operand 1 "register_operand" "f")
	     (match_operator 3 "float_operator"
	       [(match_operand:X87MODEI12 2 "memory_operand" "m")]))]
	  UNSPEC_FNSTSW))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && (TARGET_USE_<MODE>MODE_FIOP || optimize_function_for_size_p (cfun))
   && (GET_MODE (operands [3]) == GET_MODE (operands[1]))"
  "* return output_fp_compare (insn, operands, 0, 0);"
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set_attr "fp_int_src" "true")
   (set_attr "mode" "<MODE>")])

(define_insn_and_split "*cmpfp_<mode>_cc"
  [(set (reg:CCFP FLAGS_REG)
	(compare:CCFP
	  (match_operand 1 "register_operand" "f")
	  (match_operator 3 "float_operator"
	    [(match_operand:X87MODEI12 2 "memory_operand" "m")])))
   (clobber (match_operand:HI 0 "register_operand" "=a"))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_SAHF && !TARGET_CMOVE
   && (TARGET_USE_<MODE>MODE_FIOP || optimize_function_for_size_p (cfun))
   && (GET_MODE (operands [3]) == GET_MODE (operands[1]))"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(unspec:HI
	  [(compare:CCFP
	     (match_dup 1)
	     (match_op_dup 3 [(match_dup 2)]))]
	UNSPEC_FNSTSW))
   (set (reg:CC FLAGS_REG)
	(unspec:CC [(match_dup 0)] UNSPEC_SAHF))]
  ""
  [(set_attr "type" "multi")
   (set_attr "unit" "i387")
   (set_attr "fp_int_src" "true")
   (set_attr "mode" "<MODE>")])


(define_insn "x86_fnstsw_1"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI [(reg:CCFP FPSR_REG)] UNSPEC_FNSTSW))]
  "TARGET_80387"
  "fnstsw\t%0"
  [(set (attr "length") (symbol_ref "ix86_attr_length_address_default (insn) + 2"))
   (set_attr "mode" "SI")
   (set_attr "unit" "i387")])


(define_insn "x86_sahf_1"
  [(set (reg:CC FLAGS_REG)
	(unspec:CC [(match_operand:HI 0 "register_operand" "a")]
		   UNSPEC_SAHF))]
  "TARGET_SAHF"
{
#ifndef HAVE_AS_IX86_SAHF
  if (TARGET_64BIT)
    return ASM_BYTE "0x9e";
  else
#endif
  return "sahf";
}
  [(set_attr "length" "1")
   (set_attr "athlon_decode" "vector")
   (set_attr "amdfam10_decode" "direct")
   (set_attr "bdver1_decode" "direct")
   (set_attr "mode" "SI")])


(define_insn "*cmpfp_i_mixed"
  [(set (reg:CCFP FLAGS_REG)
	(compare:CCFP (match_operand 0 "register_operand" "f,x")
		      (match_operand 1 "nonimmediate_operand" "f,xm")))]
  "TARGET_MIX_SSE_I387
   && SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 0);"
  [(set_attr "type" "fcmp,ssecomi")
   (set_attr "prefix" "orig,maybe_vex")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set (attr "prefix_rep")
	(if_then_else (eq_attr "type" "ssecomi")
		      (const_string "0")
		      (const_string "*")))
   (set (attr "prefix_data16")
	(cond [(eq_attr "type" "fcmp")
		 (const_string "*")
	       (eq_attr "mode" "DF")
		 (const_string "1")
	      ]
	      (const_string "0")))
   (set_attr "athlon_decode" "vector")
   (set_attr "amdfam10_decode" "direct")
   (set_attr "bdver1_decode" "double")])

(define_insn "*cmpfp_i_sse"
  [(set (reg:CCFP FLAGS_REG)
	(compare:CCFP (match_operand 0 "register_operand" "x")
		      (match_operand 1 "nonimmediate_operand" "xm")))]
  "TARGET_SSE_MATH
   && SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 0);"
  [(set_attr "type" "ssecomi")
   (set_attr "prefix" "maybe_vex")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set_attr "prefix_rep" "0")
   (set (attr "prefix_data16")
	(if_then_else (eq_attr "mode" "DF")
		      (const_string "1")
		      (const_string "0")))
   (set_attr "athlon_decode" "vector")
   (set_attr "amdfam10_decode" "direct")
   (set_attr "bdver1_decode" "double")])

(define_insn "*cmpfp_i_i387"
  [(set (reg:CCFP FLAGS_REG)
	(compare:CCFP (match_operand 0 "register_operand" "f")
		      (match_operand 1 "register_operand" "f")))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[0]))
   && TARGET_CMOVE
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[0])) && TARGET_SSE_MATH)
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 0);"
  [(set_attr "type" "fcmp")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))
   (set_attr "athlon_decode" "vector")
   (set_attr "amdfam10_decode" "direct")
   (set_attr "bdver1_decode" "double")])

(define_insn "*cmpfp_iu_mixed"
  [(set (reg:CCFPU FLAGS_REG)
	(compare:CCFPU (match_operand 0 "register_operand" "f,x")
		       (match_operand 1 "nonimmediate_operand" "f,xm")))]
  "TARGET_MIX_SSE_I387
   && SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 1);"
  [(set_attr "type" "fcmp,ssecomi")
   (set_attr "prefix" "orig,maybe_vex")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set (attr "prefix_rep")
	(if_then_else (eq_attr "type" "ssecomi")
		      (const_string "0")
		      (const_string "*")))
   (set (attr "prefix_data16")
	(cond [(eq_attr "type" "fcmp")
		 (const_string "*")
	       (eq_attr "mode" "DF")
		 (const_string "1")
	      ]
	      (const_string "0")))
   (set_attr "athlon_decode" "vector")
   (set_attr "amdfam10_decode" "direct")
   (set_attr "bdver1_decode" "double")])

(define_insn "*cmpfp_iu_sse"
  [(set (reg:CCFPU FLAGS_REG)
	(compare:CCFPU (match_operand 0 "register_operand" "x")
		       (match_operand 1 "nonimmediate_operand" "xm")))]
  "TARGET_SSE_MATH
   && SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 1);"
  [(set_attr "type" "ssecomi")
   (set_attr "prefix" "maybe_vex")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set_attr "prefix_rep" "0")
   (set (attr "prefix_data16")
	(if_then_else (eq_attr "mode" "DF")
		      (const_string "1")
		      (const_string "0")))
   (set_attr "athlon_decode" "vector")
   (set_attr "amdfam10_decode" "direct")
   (set_attr "bdver1_decode" "double")])

(define_insn "*cmpfp_iu_387"
  [(set (reg:CCFPU FLAGS_REG)
	(compare:CCFPU (match_operand 0 "register_operand" "f")
		       (match_operand 1 "register_operand" "f")))]
  "X87_FLOAT_MODE_P (GET_MODE (operands[0]))
   && TARGET_CMOVE
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[0])) && TARGET_SSE_MATH)
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 1);"
  [(set_attr "type" "fcmp")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))
   (set_attr "athlon_decode" "vector")
   (set_attr "amdfam10_decode" "direct")
   (set_attr "bdver1_decode" "direct")])



(define_expand "testsi_ccno_1"
  [(set (reg:CCNO FLAGS_REG)
	(compare:CCNO
	  (and:SI (match_operand:SI 0 "nonimmediate_operand" "")
		  (match_operand:SI 1 "nonmemory_operand" ""))
	  (const_int 0)))])

(define_expand "testqi_ccz_1"
  [(set (reg:CCZ FLAGS_REG)
        (compare:CCZ (and:QI (match_operand:QI 0 "nonimmediate_operand" "")
			     (match_operand:QI 1 "nonmemory_operand" ""))
		 (const_int 0)))])

(define_expand "testdi_ccno_1"
  [(set (reg:CCNO FLAGS_REG)
	(compare:CCNO
	  (and:DI (match_operand:DI 0 "nonimmediate_operand" "")
		  (match_operand:DI 1 "x86_64_szext_general_operand" ""))
	  (const_int 0)))]
  "TARGET_64BIT && !(MEM_P (operands[0]) && MEM_P (operands[1]))")

(define_insn "*testdi_1"
  [(set (reg FLAGS_REG)
	(compare
	 (and:DI
	  (match_operand:DI 0 "nonimmediate_operand" "%!*a,r,!*a,r,rm")
	  (match_operand:DI 1 "x86_64_szext_general_operand" "Z,Z,e,e,re"))
	 (const_int 0)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))"
  "@
   test{l}\t{%k1, %k0|%k0, %k1}
   test{l}\t{%k1, %k0|%k0, %k1}
   test{q}\t{%1, %0|%0, %1}
   test{q}\t{%1, %0|%0, %1}
   test{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test")
   (set_attr "modrm" "0,1,0,1,1")
   (set_attr "mode" "SI,SI,DI,DI,DI")])

(define_insn "*testqi_1_maybe_si"
  [(set (reg FLAGS_REG)
        (compare
	  (and:QI
	    (match_operand:QI 0 "nonimmediate_operand" "%!*a,q,qm,r")
	    (match_operand:QI 1 "general_operand" "n,n,qn,n"))
	  (const_int 0)))]
   "!(MEM_P (operands[0]) && MEM_P (operands[1]))
    && ix86_match_ccmode (insn,
 			 CONST_INT_P (operands[1])
 			 && INTVAL (operands[1]) >= 0 ? CCNOmode : CCZmode)"
{
  if (which_alternative == 3)
    {
      if (CONST_INT_P (operands[1]) && INTVAL (operands[1]) < 0)
	operands[1] = GEN_INT (INTVAL (operands[1]) & 0xff);
      return "test{l}\t{%1, %k0|%k0, %1}";
    }
  return "test{b}\t{%1, %0|%0, %1}";
}
  [(set_attr "type" "test")
   (set_attr "modrm" "0,1,1,1")
   (set_attr "mode" "QI,QI,QI,SI")
   (set_attr "pent_pair" "uv,np,uv,np")])

(define_insn "*test<mode>_1"
  [(set (reg FLAGS_REG)
	(compare
	 (and:SWI124
	  (match_operand:SWI124 0 "nonimmediate_operand" "%!*a,<r>,<r>m")
	  (match_operand:SWI124 1 "general_operand" "<i>,<i>,<r><i>"))
	 (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))"
  "test{<imodesuffix>}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test")
   (set_attr "modrm" "0,1,1")
   (set_attr "mode" "<MODE>")
   (set_attr "pent_pair" "uv,np,uv")])

(define_expand "testqi_ext_ccno_0"
  [(set (reg:CCNO FLAGS_REG)
	(compare:CCNO
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "")
	      (const_int 8)
	      (const_int 8))
	    (match_operand 1 "const_int_operand" ""))
	  (const_int 0)))])

(define_insn "*testqi_ext_0"
  [(set (reg FLAGS_REG)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (match_operand 1 "const_int_operand" "n"))
	  (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")
   (set_attr "length_immediate" "1")
   (set_attr "modrm" "1")
   (set_attr "pent_pair" "np")])

(define_insn "*testqi_ext_1_rex64"
  [(set (reg FLAGS_REG)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (zero_extend:SI
	      (match_operand:QI 1 "register_operand" "Q")))
	  (const_int 0)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")])

(define_insn "*testqi_ext_1"
  [(set (reg FLAGS_REG)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (zero_extend:SI
	      (match_operand:QI 1 "general_operand" "Qm")))
	  (const_int 0)))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")])

(define_insn "*testqi_ext_2"
  [(set (reg FLAGS_REG)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)))
	  (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t{%h1, %h0|%h0, %h1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")])

(define_insn "*testqi_ext_3_rex64"
  [(set (reg FLAGS_REG)
        (compare (zero_extract:DI
		   (match_operand 0 "nonimmediate_operand" "rm")
		   (match_operand:DI 1 "const_int_operand" "")
		   (match_operand:DI 2 "const_int_operand" ""))
		 (const_int 0)))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCNOmode)
   && INTVAL (operands[1]) > 0
   && INTVAL (operands[2]) >= 0
   /* Ensure that resulting mask is zero or sign extended operand.  */
   && (INTVAL (operands[1]) + INTVAL (operands[2]) <= 32
       || (INTVAL (operands[1]) + INTVAL (operands[2]) == 64
	   && INTVAL (operands[1]) > 32))
   && (GET_MODE (operands[0]) == SImode
       || GET_MODE (operands[0]) == DImode
       || GET_MODE (operands[0]) == HImode
       || GET_MODE (operands[0]) == QImode)"
  "#")


(define_insn "*testqi_ext_3"
  [(set (reg FLAGS_REG)
        (compare (zero_extract:SI
		   (match_operand 0 "nonimmediate_operand" "rm")
		   (match_operand:SI 1 "const_int_operand" "")
		   (match_operand:SI 2 "const_int_operand" ""))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && INTVAL (operands[1]) > 0
   && INTVAL (operands[2]) >= 0
   && INTVAL (operands[1]) + INTVAL (operands[2]) <= 32
   && (GET_MODE (operands[0]) == SImode
       || (TARGET_64BIT && GET_MODE (operands[0]) == DImode)
       || GET_MODE (operands[0]) == HImode
       || GET_MODE (operands[0]) == QImode)"
  "#")

(define_split
  [(set (match_operand 0 "flags_reg_operand" "")
        (match_operator 1 "compare_operator"
	  [(zero_extract
	     (match_operand 2 "nonimmediate_operand" "")
	     (match_operand 3 "const_int_operand" "")
	     (match_operand 4 "const_int_operand" ""))
	   (const_int 0)]))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(set (match_dup 0) (match_op_dup 1 [(match_dup 2) (const_int 0)]))]
{
  rtx val = operands[2];
  HOST_WIDE_INT len = INTVAL (operands[3]);
  HOST_WIDE_INT pos = INTVAL (operands[4]);
  HOST_WIDE_INT mask;
  enum machine_mode mode, submode;

  mode = GET_MODE (val);
  if (MEM_P (val))
    {
      /* ??? Combine likes to put non-volatile mem extractions in QImode
	 no matter the size of the test.  So find a mode that works.  */
      if (! MEM_VOLATILE_P (val))
	{
	  mode = smallest_mode_for_size (pos + len, MODE_INT);
	  val = adjust_address (val, mode, 0);
	}
    }
  else if (GET_CODE (val) == SUBREG
	   && (submode = GET_MODE (SUBREG_REG (val)),
	       GET_MODE_BITSIZE (mode) > GET_MODE_BITSIZE (submode))
	   && pos + len <= GET_MODE_BITSIZE (submode)
	   && GET_MODE_CLASS (submode) == MODE_INT)
    {
      /* Narrow a paradoxical subreg to prevent partial register stalls.  */
      mode = submode;
      val = SUBREG_REG (val);
    }
  else if (mode == HImode && pos + len <= 8)
    {
      /* Small HImode tests can be converted to QImode.  */
      mode = QImode;
      val = gen_lowpart (QImode, val);
    }

  if (len == HOST_BITS_PER_WIDE_INT)
    mask = -1;
  else
    mask = ((HOST_WIDE_INT)1 << len) - 1;
  mask <<= pos;

  operands[2] = gen_rtx_AND (mode, val, gen_int_mode (mask, mode));
})



(define_split
  [(set (match_operand 0 "flags_reg_operand" "")
	(match_operator 1 "compare_operator"
	  [(and (match_operand 2 "register_operand" "")
	        (match_operand 3 "const_int_operand" ""))
	   (const_int 0)]))]
   "reload_completed
    && QI_REG_P (operands[2])
    && GET_MODE (operands[2]) != QImode
    && ((ix86_match_ccmode (insn, CCZmode)
    	 && !(INTVAL (operands[3]) & ~(255 << 8)))
	|| (ix86_match_ccmode (insn, CCNOmode)
	    && !(INTVAL (operands[3]) & ~(127 << 8))))"
  [(set (match_dup 0)
	(match_op_dup 1
	  [(and:SI (zero_extract:SI (match_dup 2) (const_int 8) (const_int 8))
		   (match_dup 3))
	   (const_int 0)]))]
  "operands[2] = gen_lowpart (SImode, operands[2]);
   operands[3] = gen_int_mode (INTVAL (operands[3]) >> 8, SImode);")

(define_split
  [(set (match_operand 0 "flags_reg_operand" "")
	(match_operator 1 "compare_operator"
	  [(and (match_operand 2 "nonimmediate_operand" "")
	        (match_operand 3 "const_int_operand" ""))
	   (const_int 0)]))]
   "reload_completed
    && GET_MODE (operands[2]) != QImode
    && (!REG_P (operands[2]) || ANY_QI_REG_P (operands[2]))
    && ((ix86_match_ccmode (insn, CCZmode)
	 && !(INTVAL (operands[3]) & ~255))
	|| (ix86_match_ccmode (insn, CCNOmode)
	    && !(INTVAL (operands[3]) & ~127)))"
  [(set (match_dup 0)
	(match_op_dup 1 [(and:QI (match_dup 2) (match_dup 3))
			 (const_int 0)]))]
  "operands[2] = gen_lowpart (QImode, operands[2]);
   operands[3] = gen_lowpart (QImode, operands[3]);")

(define_expand "and<mode>3"
  [(set (match_operand:SWIM 0 "nonimmediate_operand" "")
	(and:SWIM (match_operand:SWIM 1 "nonimmediate_operand" "")
		  (match_operand:SWIM 2 "<general_szext_operand>" "")))]
  ""
  "ix86_expand_binary_operator (AND, <MODE>mode, operands); DONE;")

(define_insn "*anddi_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,rm,r,r")
	(and:DI
	 (match_operand:DI 1 "nonimmediate_operand" "%0,0,0,qm")
	 (match_operand:DI 2 "x86_64_szext_general_operand" "Z,re,rm,L")))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_64BIT && ix86_binary_operator_ok (AND, DImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      {
	enum machine_mode mode;

	gcc_assert (CONST_INT_P (operands[2]));
        if (INTVAL (operands[2]) == 0xff)
	  mode = QImode;
	else
	  {
	    gcc_assert (INTVAL (operands[2]) == 0xffff);
	    mode = HImode;
	  }

	operands[1] = gen_lowpart (mode, operands[1]);
	if (mode == QImode)
	  return "movz{bl|x}\t{%1, %k0|%k0, %1}";
	else
	  return "movz{wl|x}\t{%1, %k0|%k0, %1}";
      }

    default:
      gcc_assert (rtx_equal_p (operands[0], operands[1]));
      if (get_attr_mode (insn) == MODE_SI)
	return "and{l}\t{%k2, %k0|%k0, %k2}";
      else
	return "and{q}\t{%2, %0|%0, %2}";
    }
}
  [(set_attr "type" "alu,alu,alu,imovx")
   (set_attr "length_immediate" "*,*,*,0")
   (set (attr "prefix_rex")
     (if_then_else
       (and (eq_attr "type" "imovx")
	    (and (ne (symbol_ref "INTVAL (operands[2]) == 0xff") (const_int 0))
		 (match_operand 1 "ext_QIreg_nomode_operand" "")))
       (const_string "1")
       (const_string "*")))
   (set_attr "mode" "SI,DI,DI,SI")])

(define_insn "*andsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r,r")
	(and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,qm")
		(match_operand:SI 2 "general_operand" "ri,rm,L")))
   (clobber (reg:CC FLAGS_REG))]
  "ix86_binary_operator_ok (AND, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      {
	enum machine_mode mode;

	gcc_assert (CONST_INT_P (operands[2]));
        if (INTVAL (operands[2]) == 0xff)
	  mode = QImode;
	else
	  {
	    gcc_assert (INTVAL (operands[2]) == 0xffff);
	    mode = HImode;
	  }

	operands[1] = gen_lowpart (mode, operands[1]);
	if (mode == QImode)
	  return "movz{bl|x}\t{%1, %0|%0, %1}";
	else
	  return "movz{wl|x}\t{%1, %0|%0, %1}";
      }

    default:
      gcc_assert (rtx_equal_p (operands[0], operands[1]));
      return "and{l}\t{%2, %0|%0, %2}";
    }
}
  [(set_attr "type" "alu,alu,imovx")
   (set (attr "prefix_rex")
     (if_then_else
       (and (eq_attr "type" "imovx")
	    (and (ne (symbol_ref "INTVAL (operands[2]) == 0xff") (const_int 0))
		 (match_operand 1 "ext_QIreg_nomode_operand" "")))
       (const_string "1")
       (const_string "*")))
   (set_attr "length_immediate" "*,*,0")
   (set_attr "mode" "SI")])

(define_insn "*andsi_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
		  (match_operand:SI 2 "general_operand" "g"))))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_64BIT && ix86_binary_operator_ok (AND, SImode, operands)"
  "and{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*andhi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r,r")
	(and:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,qm")
		(match_operand:HI 2 "general_operand" "rn,rm,L")))
   (clobber (reg:CC FLAGS_REG))]
  "ix86_binary_operator_ok (AND, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      gcc_assert (CONST_INT_P (operands[2]));
      gcc_assert (INTVAL (operands[2]) == 0xff);
      return "movz{bl|x}\t{%b1, %k0|%k0, %b1}";

    default:
      gcc_assert (rtx_equal_p (operands[0], operands[1]));

      return "and{w}\t{%2, %0|%0, %2}";
    }
}
  [(set_attr "type" "alu,alu,imovx")
   (set_attr "length_immediate" "*,*,0")
   (set (attr "prefix_rex")
     (if_then_else
       (and (eq_attr "type" "imovx")
	    (match_operand 1 "ext_QIreg_nomode_operand" ""))
       (const_string "1")
       (const_string "*")))
   (set_attr "mode" "HI,HI,SI")])


(define_insn "*andqi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,q,r")
	(and:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		(match_operand:QI 2 "general_operand" "qn,qmn,rn")))
   (clobber (reg:CC FLAGS_REG))]
  "ix86_binary_operator_ok (AND, QImode, operands)"
  "@
   and{b}\t{%2, %0|%0, %2}
   and{b}\t{%2, %0|%0, %2}
   and{l}\t{%k2, %k0|%k0, %k2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI,QI,SI")])

(define_insn "*andqi_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,q"))
	(and:QI (match_dup 0)
		(match_operand:QI 1 "general_operand" "qn,qmn")))
   (clobber (reg:CC FLAGS_REG))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))"
  "and{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_split
  [(set (match_operand 0 "register_operand" "")
	(and (match_dup 0)
	     (const_int -65536)))
   (clobber (reg:CC FLAGS_REG))]
  "(TARGET_FAST_PREFIX && !TARGET_PARTIAL_REG_STALL)
    || optimize_function_for_size_p (cfun)"
  [(set (strict_low_part (match_dup 1)) (const_int 0))]
  "operands[1] = gen_lowpart (HImode, operands[0]);")

(define_split
  [(set (match_operand 0 "ext_register_operand" "")
	(and (match_dup 0)
	     (const_int -256)))
   (clobber (reg:CC FLAGS_REG))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed"
  [(set (strict_low_part (match_dup 1)) (const_int 0))]
  "operands[1] = gen_lowpart (QImode, operands[0]);")

(define_split
  [(set (match_operand 0 "ext_register_operand" "")
	(and (match_dup 0)
	     (const_int -65281)))
   (clobber (reg:CC FLAGS_REG))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed"
  [(parallel [(set (zero_extract:SI (match_dup 0)
				    (const_int 8)
				    (const_int 8))
		   (xor:SI
		     (zero_extract:SI (match_dup 0)
				      (const_int 8)
				      (const_int 8))
		     (zero_extract:SI (match_dup 0)
				      (const_int 8)
				      (const_int 8))))
	      (clobber (reg:CC FLAGS_REG))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);")

(define_insn "*anddi_2"
  [(set (reg FLAGS_REG)
	(compare
	 (and:DI
	  (match_operand:DI 1 "nonimmediate_operand" "%0,0,0")
	  (match_operand:DI 2 "x86_64_szext_general_operand" "Z,rem,re"))
	 (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=r,r,rm")
	(and:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, DImode, operands)"
  "@
   and{l}\t{%k2, %k0|%k0, %k2}
   and{q}\t{%2, %0|%0, %2}
   and{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI,DI,DI")])

(define_insn "*andqi_2_maybe_si"
  [(set (reg FLAGS_REG)
	(compare (and:QI
		  (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		  (match_operand:QI 2 "general_operand" "qmn,qn,n"))
		 (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=q,qm,*r")
	(and:QI (match_dup 1) (match_dup 2)))]
  "ix86_binary_operator_ok (AND, QImode, operands)
   && ix86_match_ccmode (insn,
			 CONST_INT_P (operands[2])
			 && INTVAL (operands[2]) >= 0 ? CCNOmode : CCZmode)"
{
  if (which_alternative == 2)
    {
      if (CONST_INT_P (operands[2]) && INTVAL (operands[2]) < 0)
        operands[2] = GEN_INT (INTVAL (operands[2]) & 0xff);
      return "and{l}\t{%2, %k0|%k0, %2}";
    }
  return "and{b}\t{%2, %0|%0, %2}";
}
  [(set_attr "type" "alu")
   (set_attr "mode" "QI,QI,SI")])

(define_insn "*and<mode>_2"
  [(set (reg FLAGS_REG)
	(compare (and:SWI124
		  (match_operand:SWI124 1 "nonimmediate_operand" "%0,0")
		  (match_operand:SWI124 2 "general_operand" "<g>,<r><i>"))
		 (const_int 0)))
   (set (match_operand:SWI124 0 "nonimmediate_operand" "=<r>,<r>m")
	(and:SWI124 (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, <MODE>mode, operands)"
  "and{<imodesuffix>}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "<MODE>")])


(define_insn "*andsi_2_zext"
  [(set (reg FLAGS_REG)
	(compare (and:SI
		  (match_operand:SI 1 "nonimmediate_operand" "%0")
		  (match_operand:SI 2 "general_operand" "g"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (and:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, SImode, operands)"
  "and{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*andqi_2_slp"
  [(set (reg FLAGS_REG)
	(compare (and:QI
		   (match_operand:QI 0 "nonimmediate_operand" "+q,qm")
		   (match_operand:QI 1 "nonimmediate_operand" "qmn,qn"))
		 (const_int 0)))
   (set (strict_low_part (match_dup 0))
	(and:QI (match_dup 0) (match_dup 1)))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && ix86_match_ccmode (insn, CCNOmode)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))"
  "and{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])


(define_insn "andqi_ext_0"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (match_operand 2 "const_int_operand" "n")))
   (clobber (reg:CC FLAGS_REG))]
  ""
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "1")
   (set_attr "modrm" "1")
   (set_attr "mode" "QI")])

(define_insn "*andqi_ext_0_cc"
  [(set (reg FLAGS_REG)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "0")
	      (const_int 8)
	      (const_int 8))
	    (match_operand 2 "const_int_operand" "n"))
	  (const_int 0)))
   (set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI
	  (zero_extract:SI
	    (match_dup 1)
	    (const_int 8)
	    (const_int 8))
	  (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "1")
   (set_attr "modrm" "1")
   (set_attr "mode" "QI")])

(define_insn "*andqi_ext_1_rex64"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand 2 "ext_register_operand" "Q"))))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_64BIT"
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*andqi_ext_1"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand:QI 2 "general_operand" "Qm"))))
   (clobber (reg:CC FLAGS_REG))]
  "!TARGET_64BIT"
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*andqi_ext_2"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "%0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extract:SI
	    (match_operand 2 "ext_register_operand" "Q")
	    (const_int 8)
	    (const_int 8))))
   (clobber (reg:CC FLAGS_REG))]
  ""
  "and{b}\t{%h2, %h0|%h0, %h2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])


(define_split
  [(set (match_operand 0 "register_operand" "")
	(and (match_operand 1 "register_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC FLAGS_REG))]
   "reload_completed
    && QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(~INTVAL (operands[2]) & ~(255 << 8))
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (zero_extract:SI (match_dup 0) (const_int 8) (const_int 8))
		   (and:SI (zero_extract:SI (match_dup 1)
					    (const_int 8) (const_int 8))
			   (match_dup 2)))
	      (clobber (reg:CC FLAGS_REG))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);
   operands[2] = gen_int_mode ((INTVAL (operands[2]) >> 8) & 0xff, SImode);")

(define_split
  [(set (match_operand 0 "register_operand" "")
	(and (match_operand 1 "general_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC FLAGS_REG))]
   "reload_completed
    && ANY_QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(~INTVAL (operands[2]) & ~255)
    && !(INTVAL (operands[2]) & 128)
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (strict_low_part (match_dup 0))
		   (and:QI (match_dup 1)
			   (match_dup 2)))
	      (clobber (reg:CC FLAGS_REG))])]
  "operands[0] = gen_lowpart (QImode, operands[0]);
   operands[1] = gen_lowpart (QImode, operands[1]);
   operands[2] = gen_lowpart (QImode, operands[2]);")


(define_expand "<code><mode>3"
  [(set (match_operand:SWIM 0 "nonimmediate_operand" "")
	(any_or:SWIM (match_operand:SWIM 1 "nonimmediate_operand" "")
		     (match_operand:SWIM 2 "<general_operand>" "")))]
  ""
  "ix86_expand_binary_operator (<CODE>, <MODE>mode, operands); DONE;")

(define_insn "*<code><mode>_1"
  [(set (match_operand:SWI248 0 "nonimmediate_operand" "=r,rm")
	(any_or:SWI248
	 (match_operand:SWI248 1 "nonimmediate_operand" "%0,0")
	 (match_operand:SWI248 2 "<general_operand>" "<g>,r<i>")))
   (clobber (reg:CC FLAGS_REG))]
  "ix86_binary_operator_ok (<CODE>, <MODE>mode, operands)"
  "<logic>{<imodesuffix>}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "<MODE>")])


(define_insn "*<code>qi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=q,m,r")
	(any_or:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		   (match_operand:QI 2 "general_operand" "qmn,qn,rn")))
   (clobber (reg:CC FLAGS_REG))]
  "ix86_binary_operator_ok (<CODE>, QImode, operands)"
  "@
   <logic>{b}\t{%2, %0|%0, %2}
   <logic>{b}\t{%2, %0|%0, %2}
   <logic>{l}\t{%k2, %k0|%k0, %k2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI,QI,SI")])


(define_insn "*<code>si_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	 (any_or:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
		    (match_operand:SI 2 "general_operand" "g"))))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_64BIT && ix86_binary_operator_ok (<CODE>, SImode, operands)"
  "<logic>{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*<code>si_1_zext_imm"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(any_or:DI
	 (zero_extend:DI (match_operand:SI 1 "register_operand" "%0"))
	 (match_operand:DI 2 "x86_64_zext_immediate_operand" "Z")))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_64BIT && ix86_binary_operator_ok (<CODE>, SImode, operands)"
  "<logic>{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*<code>qi_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+q,m"))
	(any_or:QI (match_dup 0)
		   (match_operand:QI 1 "general_operand" "qmn,qn")))
   (clobber (reg:CC FLAGS_REG))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))"
  "<logic>{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "*<code><mode>_2"
  [(set (reg FLAGS_REG)
	(compare (any_or:SWI
		  (match_operand:SWI 1 "nonimmediate_operand" "%0,0")
		  (match_operand:SWI 2 "<general_operand>" "<g>,<r><i>"))
		 (const_int 0)))
   (set (match_operand:SWI 0 "nonimmediate_operand" "=<r>,<r>m")
	(any_or:SWI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (<CODE>, <MODE>mode, operands)"
  "<logic>{<imodesuffix>}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "<MODE>")])


(define_insn "*<code>si_2_zext"
  [(set (reg FLAGS_REG)
	(compare (any_or:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			    (match_operand:SI 2 "general_operand" "g"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (any_or:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (<CODE>, SImode, operands)"
  "<logic>{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*<code>si_2_zext_imm"
  [(set (reg FLAGS_REG)
	(compare (any_or:SI
		  (match_operand:SI 1 "nonimmediate_operand" "%0")
		  (match_operand:SI 2 "x86_64_zext_immediate_operand" "Z"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(any_or:DI (zero_extend:DI (match_dup 1)) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (<CODE>, SImode, operands)"
  "<logic>{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*<code>qi_2_slp"
  [(set (reg FLAGS_REG)
	(compare (any_or:QI (match_operand:QI 0 "nonimmediate_operand" "+q,qm")
			    (match_operand:QI 1 "general_operand" "qmn,qn"))
		 (const_int 0)))
   (set (strict_low_part (match_dup 0))
	(any_or:QI (match_dup 0) (match_dup 1)))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && ix86_match_ccmode (insn, CCNOmode)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))"
  "<logic>{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "*<code><mode>_3"
  [(set (reg FLAGS_REG)
	(compare (any_or:SWI
		  (match_operand:SWI 1 "nonimmediate_operand" "%0")
		  (match_operand:SWI 2 "<general_operand>" "<g>"))
		 (const_int 0)))
   (clobber (match_scratch:SWI 0 "=<r>"))]
  "ix86_match_ccmode (insn, CCNOmode)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))"
  "<logic>{<imodesuffix>}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "<MODE>")])

(define_insn "*<code>qi_ext_0"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(any_or:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (match_operand 2 "const_int_operand" "n")))
   (clobber (reg:CC FLAGS_REG))]
  "!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)"
  "<logic>{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "1")
   (set_attr "modrm" "1")
   (set_attr "mode" "QI")])

(define_insn "*<code>qi_ext_1_rex64"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(any_or:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand 2 "ext_register_operand" "Q"))))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_64BIT
   && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))"
  "<logic>{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*<code>qi_ext_1"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(any_or:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand:QI 2 "general_operand" "Qm"))))
   (clobber (reg:CC FLAGS_REG))]
  "!TARGET_64BIT
   && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))"
  "<logic>{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*<code>qi_ext_2"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(any_or:SI
	  (zero_extract:SI (match_operand 1 "ext_register_operand" "0")
	  		   (const_int 8)
			   (const_int 8))
	  (zero_extract:SI (match_operand 2 "ext_register_operand" "Q")
	  		   (const_int 8)
			   (const_int 8))))
   (clobber (reg:CC FLAGS_REG))]
  "!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)"
  "<logic>{b}\t{%h2, %h0|%h0, %h2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_split
  [(set (match_operand 0 "register_operand" "")
	(any_or (match_operand 1 "register_operand" "")
		(match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC FLAGS_REG))]
   "reload_completed
    && QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (zero_extract:SI (match_dup 0) (const_int 8) (const_int 8))
		   (any_or:SI (zero_extract:SI (match_dup 1)
					       (const_int 8) (const_int 8))
			      (match_dup 2)))
	      (clobber (reg:CC FLAGS_REG))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);
   operands[2] = gen_int_mode ((INTVAL (operands[2]) >> 8) & 0xff, SImode);")


(define_split
  [(set (match_operand 0 "register_operand" "")
	(any_or (match_operand 1 "general_operand" "")
		(match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC FLAGS_REG))]
   "reload_completed
    && ANY_QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (strict_low_part (match_dup 0))
		   (any_or:QI (match_dup 1)
			      (match_dup 2)))
	      (clobber (reg:CC FLAGS_REG))])]
  "operands[0] = gen_lowpart (QImode, operands[0]);
   operands[1] = gen_lowpart (QImode, operands[1]);
   operands[2] = gen_lowpart (QImode, operands[2]);")

(define_expand "xorqi_cc_ext_1"
  [(parallel [
     (set (reg:CCNO FLAGS_REG)
	  (compare:CCNO
	    (xor:SI
	      (zero_extract:SI
		(match_operand 1 "ext_register_operand" "")
		(const_int 8)
		(const_int 8))
	      (match_operand:QI 2 "general_operand" ""))
	    (const_int 0)))
     (set (zero_extract:SI (match_operand 0 "ext_register_operand" "")
			   (const_int 8)
			   (const_int 8))
	  (xor:SI
	    (zero_extract:SI
	     (match_dup 1)
	     (const_int 8)
	     (const_int 8))
	    (match_dup 2)))])])

(define_insn "*xorqi_cc_ext_1_rex64"
  [(set (reg FLAGS_REG)
	(compare
	  (xor:SI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "0")
	      (const_int 8)
	      (const_int 8))
	    (match_operand:QI 2 "nonmemory_operand" "Qn"))
	  (const_int 0)))
   (set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI
	  (zero_extract:SI
	   (match_dup 1)
	   (const_int 8)
	   (const_int 8))
	  (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "xor{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "modrm" "1")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_cc_ext_1"
  [(set (reg FLAGS_REG)
	(compare
	  (xor:SI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "0")
	      (const_int 8)
	      (const_int 8))
	    (match_operand:QI 2 "general_operand" "qmn"))
	  (const_int 0)))
   (set (zero_extract:SI (match_operand 0 "ext_register_operand" "=q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI
	  (zero_extract:SI
	   (match_dup 1)
	   (const_int 8)
	   (const_int 8))
	  (match_dup 2)))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "xor{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "modrm" "1")
   (set_attr "mode" "QI")])


(define_expand "neg<mode>2"
  [(set (match_operand:SDWIM 0 "nonimmediate_operand" "")
	(neg:SDWIM (match_operand:SDWIM 1 "nonimmediate_operand" "")))]
  ""
  "ix86_expand_unary_operator (NEG, <MODE>mode, operands); DONE;")

(define_insn_and_split "*neg<dwi>2_doubleword"
  [(set (match_operand:<DWI> 0 "nonimmediate_operand" "=ro")
	(neg:<DWI> (match_operand:<DWI> 1 "nonimmediate_operand" "0")))
   (clobber (reg:CC FLAGS_REG))]
  "ix86_unary_operator_ok (NEG, <DWI>mode, operands)"
  "#"
  "reload_completed"
  [(parallel
    [(set (reg:CCZ FLAGS_REG)
	  (compare:CCZ (neg:DWIH (match_dup 1)) (const_int 0)))
     (set (match_dup 0) (neg:DWIH (match_dup 1)))])
   (parallel
    [(set (match_dup 2)
	  (plus:DWIH (match_dup 3)
		     (plus:DWIH (ltu:DWIH (reg:CC FLAGS_REG) (const_int 0))
				(const_int 0))))
     (clobber (reg:CC FLAGS_REG))])
   (parallel
    [(set (match_dup 2)
	  (neg:DWIH (match_dup 2)))
     (clobber (reg:CC FLAGS_REG))])]
  "split_double_mode (<DWI>mode, &operands[0], 2, &operands[0], &operands[2]);")

(define_insn "*neg<mode>2_1"
  [(set (match_operand:SWI 0 "nonimmediate_operand" "=<r>m")
	(neg:SWI (match_operand:SWI 1 "nonimmediate_operand" "0")))
   (clobber (reg:CC FLAGS_REG))]
  "ix86_unary_operator_ok (NEG, <MODE>mode, operands)"
  "neg{<imodesuffix>}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "<MODE>")])


(define_insn "*negsi2_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI
	  (neg:DI (ashift:DI (match_operand:DI 1 "register_operand" "0")
			     (const_int 32)))
	(const_int 32)))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_64BIT && ix86_unary_operator_ok (NEG, SImode, operands)"
  "neg{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])


(define_insn "*neg<mode>2_cmpz"
  [(set (reg:CCZ FLAGS_REG)
	(compare:CCZ
	  (neg:SWI (match_operand:SWI 1 "nonimmediate_operand" "0"))
		   (const_int 0)))
   (set (match_operand:SWI 0 "nonimmediate_operand" "=<r>m")
	(neg:SWI (match_dup 1)))]
  "ix86_unary_operator_ok (NEG, <MODE>mode, operands)"
  "neg{<imodesuffix>}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "<MODE>")])

(define_insn "*negsi2_cmpz_zext"
  [(set (reg:CCZ FLAGS_REG)
	(compare:CCZ
	  (lshiftrt:DI
	    (neg:DI (ashift:DI
		      (match_operand:DI 1 "register_operand" "0")
		      (const_int 32)))
	    (const_int 32))
	  (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (neg:DI (ashift:DI (match_dup 1)
					(const_int 32)))
		     (const_int 32)))]
  "TARGET_64BIT && ix86_unary_operator_ok (NEG, SImode, operands)"
  "neg{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])



(define_expand "<code><mode>2"
  [(set (match_operand:X87MODEF 0 "register_operand" "")
	(absneg:X87MODEF (match_operand:X87MODEF 1 "register_operand" "")))]
  "TARGET_80387 || (SSE_FLOAT_MODE_P (<MODE>mode) && TARGET_SSE_MATH)"
  "ix86_expand_fp_absneg_operator (<CODE>, <MODE>mode, operands); DONE;")

(define_insn "*absneg<mode>2_mixed"
  [(set (match_operand:MODEF 0 "register_operand" "=x,x,f,!r")
	(match_operator:MODEF 3 "absneg_operator"
	  [(match_operand:MODEF 1 "register_operand" "0,x,0,0")]))
   (use (match_operand:<ssevecmode> 2 "nonimmediate_operand" "xm,0,X,X"))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_MIX_SSE_I387 && SSE_FLOAT_MODE_P (<MODE>mode)"
  "#")

(define_insn "*absneg<mode>2_sse"
  [(set (match_operand:MODEF 0 "register_operand" "=x,x,!r")
	(match_operator:MODEF 3 "absneg_operator"
	  [(match_operand:MODEF 1 "register_operand" "0 ,x,0")]))
   (use (match_operand:<ssevecmode> 2 "register_operand" "xm,0,X"))
   (clobber (reg:CC FLAGS_REG))]
  "SSE_FLOAT_MODE_P (<MODE>mode) && TARGET_SSE_MATH"
  "#")

(define_insn "*absneg<mode>2_i387"
  [(set (match_operand:X87MODEF 0 "register_operand" "=f,!r")
	(match_operator:X87MODEF 3 "absneg_operator"
	  [(match_operand:X87MODEF 1 "register_operand" "0,0")]))
   (use (match_operand 2 "" ""))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_80387 && !(SSE_FLOAT_MODE_P (<MODE>mode) && TARGET_SSE_MATH)"
  "#")

(define_expand "<code>tf2"
  [(set (match_operand:TF 0 "register_operand" "")
	(absneg:TF (match_operand:TF 1 "register_operand" "")))]
  "TARGET_SSE2"
  "ix86_expand_fp_absneg_operator (<CODE>, TFmode, operands); DONE;")

(define_insn "*absnegtf2_sse"
  [(set (match_operand:TF 0 "register_operand" "=x,x")
	(match_operator:TF 3 "absneg_operator"
	  [(match_operand:TF 1 "register_operand" "0,x")]))
   (use (match_operand:TF 2 "nonimmediate_operand" "xm,0"))
   (clobber (reg:CC FLAGS_REG))]
  "TARGET_SSE2"
  "#")



(define_split
  [(set (match_operand 0 "fp_register_operand" "")
	(match_operator 1 "absneg_operator" [(match_dup 0)]))
   (use (match_operand 2 "" ""))
   (clobber (reg:CC FLAGS_REG))]
  "reload_completed"
  [(set (match_dup 0) (match_op_dup 1 [(match_dup 0)]))])

(define_split
  [(set (match_operand 0 "register_operand" "")
	(match_operator 3 "absneg_operator"
	  [(match_operand 1 "register_operand" "")]))
   (use (match_operand 2 "nonimmediate_operand" ""))
   (clobber (reg:CC FLAGS_REG))]
  "reload_completed && SSE_REG_P (operands[0])"
  [(set (match_dup 0) (match_dup 3))]
{
  enum machine_mode mode = GET_MODE (operands[0]);
  enum machine_mode vmode = GET_MODE (operands[2]);
  rtx tmp;

  operands[0] = simplify_gen_subreg (vmode, operands[0], mode, 0);
  operands[1] = simplify_gen_subreg (vmode, operands[1], mode, 0);
  if (operands_match_p (operands[0], operands[2]))
    {
      tmp = operands[1];
      operands[1] = operands[2];
      operands[2] = tmp;
    }
  if (GET_CODE (operands[3]) == ABS)
    tmp = gen_rtx_AND (vmode, operands[1], operands[2]);
  else
    tmp = gen_rtx_XOR (vmode, operands[1], operands[2]);
  operands[3] = tmp;
})

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(match_operator:SF 1 "absneg_operator" [(match_dup 0)]))
   (use (match_operand:V4SF 2 "" ""))
   (clobber (reg:CC FLAGS_REG))]
  "reload_completed"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (clobber (reg:CC FLAGS_REG))])]
{
  rtx tmp;
  operands[0] = gen_lowpart (SImode, operands[0]);
  if (GET_CODE (operands[1]) == ABS)
    {
      tmp = gen_int_mode (0x7fffffff, SImode);
      tmp = gen_rtx_AND (SImode, operands[0], tmp);
    }
  else
    {
      tmp = gen_int_mode (0x80000000, SImode);
      tmp = gen_rtx_XOR (SImode, operands[0], tmp);
    }
  operands[1] = tmp;
})

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(match_operator:DF 1 "absneg_operator" [(match_dup 0)]))
   (use (match_operand 2 "" ""))
   (clobber (reg:CC FLAGS_REG))]
  "reload_completed"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (clobber (reg:CC FLAGS_REG))])]
{
  rtx tmp;
  if (TARGET_64BIT)
    {
      tmp = gen_lowpart (DImode, operands[0]);
      tmp = gen_rtx_ZERO_EXTRACT (DImode, tmp, const1_rtx, GEN_INT (63));
      operands[0] = tmp;

      if (GET_CODE (operands[1]) == ABS)
	tmp = const0_rtx;
      else
	tmp = gen_rtx_NOT (DImode, tmp);
    }
  else
    {
      operands[0] = gen_highpart (SImode, operands[0]);
      if (GET_CODE (operands[1]) == ABS)
	{
	  tmp = gen_int_mode (0x7fffffff, SImode);
	  tmp = gen_rtx_AND (SImode, operands[0], tmp);
	}
      else
	{
	  tmp = gen_int_mode (0x80000000, SImode);
	  tmp = gen_rtx_XOR (SImode, operands[0], tmp);
	}
    }
  operands[1] = tmp;
})

(define_split
  [(set (match_operand:XF 0 "register_operand" "")
	(match_operator:XF 1 "absneg_operator" [(match_dup 0)]))
   (use (match_operand 2 "" ""))
   (clobber (reg:CC FLAGS_REG))]
  "reload_completed"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (clobber (reg:CC FLAGS_REG))])]
{
  rtx tmp;
  operands[0] = gen_rtx_REG (SImode,
			     true_regnum (operands[0])
			     + (TARGET_64BIT ? 1 : 2));
  if (GET_CODE (operands[1]) == ABS)
    {
      tmp = GEN_INT (0x7fff);
      tmp = gen_rtx_AND (SImode, operands[0], tmp);
    }
  else
    {
      tmp = GEN_INT (0x8000);
      tmp = gen_rtx_XOR (SImode, operands[0], tmp);
    }
  operands[1] = tmp;
})



(define_insn "*<code><mode>2_1"
  [(set (match_operand:X87MODEF 0 "register_operand" "=f")
	(absneg:X87MODEF (match_operand:X87MODEF 1 "register_operand" "0")))]
  "TARGET_80387
   && (reload_completed
       || !(SSE_FLOAT_MODE_P (<MODE>mode) && TARGET_SSE_MATH))"
  "f<absneg_mnemonic>"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "<MODE>")])

(define_insn "*<code>extendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(absneg:DF (float_extend:DF
		     (match_operand:SF 1 "register_operand" "0"))))]
  "TARGET_80387 && (!TARGET_SSE_MATH || TARGET_MIX_SSE_I387)"
  "f<absneg_mnemonic>"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "DF")])

(define_insn "*<code>extendsfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(absneg:XF (float_extend:XF
		     (match_operand:SF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "f<absneg_mnemonic>"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "XF")])

(define_insn "*<code>extenddfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(absneg:XF (float_extend:XF
		     (match_operand:DF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "f<absneg_mnemonic>"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "XF")])



(define_expand "one_cmpl<mode>2"
  [(set (match_operand:SWIM 0 "nonimmediate_operand" "")
	(not:SWIM (match_operand:SWIM 1 "nonimmediate_operand" "")))]
  ""
  "ix86_expand_unary_operator (NOT, <MODE>mode, operands); DONE;")

(define_insn "*one_cmpl<mode>2_1"
  [(set (match_operand:SWI248 0 "nonimmediate_operand" "=rm")
	(not:SWI248 (match_operand:SWI248 1 "nonimmediate_operand" "0")))]
  "ix86_unary_operator_ok (NOT, <MODE>mode, operands)"
  "not{<imodesuffix>}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "<MODE>")])


(define_insn "*one_cmplqi2_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,r")
	(not:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")))]
  "ix86_unary_operator_ok (NOT, QImode, operands)"
  "@
   not{b}\t%0
   not{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "QI,SI")])


(define_insn "*one_cmplsi2_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (not:SI (match_operand:SI 1 "register_operand" "0"))))]
  "TARGET_64BIT && ix86_unary_operator_ok (NOT, SImode, operands)"
  "not{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

(define_insn "*one_cmpl<mode>2_2"
  [(set (reg FLAGS_REG)
	(compare (not:SWI (match_operand:SWI 1 "nonimmediate_operand" "0"))
		 (const_int 0)))
   (set (match_operand:SWI 0 "nonimmediate_operand" "=<r>m")
	(not:SWI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, <MODE>mode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "<MODE>")])

(define_split
  [(set (match_operand 0 "flags_reg_operand" "")
	(match_operator 2 "compare_operator"
	  [(not:SWI (match_operand:SWI 3 "nonimmediate_operand" ""))
	   (const_int 0)]))
   (set (match_operand:SWI 1 "nonimmediate_operand" "")
	(not:SWI (match_dup 3)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (match_dup 0)
		   (match_op_dup 2 [(xor:SWI (match_dup 3) (const_int -1))
				    (const_int 0)]))
	      (set (match_dup 1)
		   (xor:SWI (match_dup 3) (const_int -1)))])])


(define_insn "*one_cmplsi2_2_zext"
  [(set (reg FLAGS_REG)
	(compare (not:SI (match_operand:SI 1 "register_operand" "0"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (not:SI (match_dup 1))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, SImode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")])

(define_split
  [(set (match_operand 0 "flags_reg_operand" "")
	(match_operator 2 "compare_operator"
	  [(not:SI (match_operand:SI 3 "register_operand" ""))
	   (const_int 0)]))
   (set (match_operand:DI 1 "register_operand" "")
	(zero_extend:DI (not:SI (match_dup 3))))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (match_dup 0)
		   (match_op_dup 2 [(xor:SI (match_dup 3) (const_int -1))
				    (const_int 0)]))
	      (set (match_dup 1)
		   (zero_extend:DI (xor:SI (match_dup 3) (const_int -1))))])])




(define_expand "one_cmpl<mode>2"
  [(set (match_operand:SWIM 0 "nonimmediate_operand" "")
	(not:SWIM (match_operand:SWIM 1 "nonimmediate_operand" "")))]
  ""
  "ix86_expand_unary_operator (NOT, <MODE>mode, operands); DONE;")

(define_insn "*one_cmpl<mode>2_1"
  [(set (match_operand:SWI248 0 "nonimmediate_operand" "=rm")
	(not:SWI248 (match_operand:SWI248 1 "nonimmediate_operand" "0")))]
  "ix86_unary_operator_ok (NOT, <MODE>mode, operands)"
  "not{<imodesuffix>}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "<MODE>")])


(define_insn "*one_cmplqi2_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,r")
	(not:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")))]
  "ix86_unary_operator_ok (NOT, QImode, operands)"
  "@
   not{b}\t%0
   not{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "QI,SI")])


(define_insn "*one_cmplsi2_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (not:SI (match_operand:SI 1 "register_operand" "0"))))]
  "TARGET_64BIT && ix86_unary_operator_ok (NOT, SImode, operands)"
  "not{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

(define_insn "*one_cmpl<mode>2_2"
  [(set (reg FLAGS_REG)
	(compare (not:SWI (match_operand:SWI 1 "nonimmediate_operand" "0"))
		 (const_int 0)))
   (set (match_operand:SWI 0 "nonimmediate_operand" "=<r>m")
	(not:SWI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, <MODE>mode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "<MODE>")])

(define_split
  [(set (match_operand 0 "flags_reg_operand" "")
	(match_operator 2 "compare_operator"
	  [(not:SWI (match_operand:SWI 3 "nonimmediate_operand" ""))
	   (const_int 0)]))
   (set (match_operand:SWI 1 "nonimmediate_operand" "")
	(not:SWI (match_dup 3)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (match_dup 0)
		   (match_op_dup 2 [(xor:SWI (match_dup 3) (const_int -1))
				    (const_int 0)]))
	      (set (match_dup 1)
		   (xor:SWI (match_dup 3) (const_int -1)))])])


(define_insn "*one_cmplsi2_2_zext"
  [(set (reg FLAGS_REG)
	(compare (not:SI (match_operand:SI 1 "register_operand" "0"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (not:SI (match_dup 1))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, SImode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")])

(define_split
  [(set (match_operand 0 "flags_reg_operand" "")
	(match_operator 2 "compare_operator"
	  [(not:SI (match_operand:SI 3 "register_operand" ""))
	   (const_int 0)]))
   (set (match_operand:DI 1 "register_operand" "")
	(zero_extend:DI (not:SI (match_dup 3))))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (match_dup 0)
		   (match_op_dup 2 [(xor:SI (match_dup 3) (const_int -1))
				    (const_int 0)]))
	      (set (match_dup 1)
		   (zero_extend:DI (xor:SI (match_dup 3) (const_int -1))))])])

