
abstract set_label_ref extends set
{
	root.2:=label_ref;
}

concrete jump.insn instantiates set_label_ref
{
	set_label_ref(pc,NULL:NULL:"");
}
{:
      ""
	{
                return "j \\t%l0";
        }
:}

concrete indirect_jump.insn instantiates set
{
	set(pc,register_operand:SI:"");
}
{:
	""
	"jr \\t%0"
:}

concrete epilogue.expand instantiates clobber
{
	clobber(const_int:0);
}
{:
      ""
        {
                spim_epilogue();
                DONE;
        }
:}

abstract seq_use extends sequence
{
	root.2:=use;
}

concrete IITB_return.insn instantiates seq_use
{
	seq_use(return,reg(SI:31));
}
{:
	""
	"jr \\t\\$ra"
:}

concrete movsi.expand instantiates set
{
	set(nonimmediate_operand:SI:"",general_operand:SI:"");
}
{:
""
{
	  if(GET_CODE(operands[1])==CONST_INT && INTVAL(operands[1])==0)
	  {
	    emit_insn(gen_IITB_move_zero(operands[0],gen_rtx_REG(SImode,0)));
	    DONE;
  	  }
	  else
	  if(GET_CODE(operands[0])==MEM && GET_CODE(operands[1])!=REG)
	  {
	    
	    if(can_create_pseudo_p())
	    {
		operands[1]=force_reg(SImode,operands[1]);
	    }
  }
}
:}


concrete *load_word.insn instantiates set
{
	set(register_operand:SI:"=r",memory_operand:SI:"m");
}
{:
	""
	"lw \\t%0, %m1"
:}

concrete *store_word.insn instantiates set
{
	set(memory_operand:SI:"=m",register_operand:SI:"r");
}
{:
	""
	"sw \\t%1, %m0"
:}

concrete *constant_load.insn overrides *load_word.insn
{
	root.2.predicate:=const_int_operand;
	root.2.constraint:="i";
}
{:
	""
	"li \\t%0, %c1"
:}

concrete IITB_move_zero.insn instantiates set
{
	set(nonimmediate_operand:SI:"=r,m",zero_register_operand:SI:"z,z");
}
{:
	""
	"@
	move \\t%0,%1
	sw \\t%1, %m0"
:}

concrete *move_regs.insn overrides *load_word.insn
{
	root.2.predicate:=register_operand;
	root.2.constraint:="r";
}
{:
        ""
        "move \\t%0,%1"
:}

abstract set_plus extends set
{
	root.2:=plus;
}

concrete addsi3.insn instantiates set_plus
{
	set_plus(register_operand:SI:"=r,r",register_operand:SI:"r,r",nonmemory_operand:SI:"r,K");
	root.2.mode:=SI;
}
{:
      ""
        "@
         add \\t%0, %1, %2
         addi \\t%0, %1, %c2"
:}

concrete prologue.expand overrides epilogue.expand
{
}
{:
	""
	{
		spim_prologue();
		DONE;
	}
:}

abstract set_abs extends set
{
	root.2:=abs;
}

concrete abssi2.insn instantiates set_abs
{
	set_abs(register_operand:SI:"=r",register_operand:SI:"r");
	root.2.mode:=SI;
}
{:
	""
	"abs \\t%0, %1"
:}

abstract set_and extends set
{
	root.2:=and;
}

concrete andsi3.insn instantiates set_and
{
	set_and(register_operand:SI:"=r,r",register_operand:SI:"r,r",nonmemory_operand:SI:"r,K");
	root.2.mode:=SI;
}
{:
      ""
        "@
         and \\t%0, %1, %2
         andi \\t%0, %1, %c2"
:}


abstract set_div extends set
{
	root.2:=div;
}

concrete divsi3.insn instantiates set_div
{
	set_div(register_operand:SI:"=r",register_operand:SI:"r",register_operand:SI:"r");
	root.2.mode:=SI;
}
{:
""
        "div \\t%1, %2\\n\\tmflo \\t%0"
:}


abstract set_udiv extends set
{
	root.2:=udiv;
}

concrete udivsi3.insn instantiates set_udiv
{
	set_udiv(register_operand:SI:"=r,r",register_operand:SI:"r,r",general_operand:SI:"r,im");
	root.2.mode:=SI;
}
{:
""
        "@
	divu \\t%1, %2\\n\\tmflo \\t%0
	divu \\t%0, %1, %2"
:}


abstract set_mod extends set
{
	root.2:=mod;
}

concrete modsi3.insn instantiates set_mod
{
	set_mod(register_operand:SI:"=r",register_operand:SI:"r",register_operand:SI:"r");
	root.2.mode:=SI;
}
{:
      ""
        "rem \\t%0, %1, %2"
:}
                                                                                                    

abstract set_umod extends set
{
	root.2:=umod;
}

concrete umodsi3.insn instantiates set_umod
{
	set_umod(register_operand:SI:"=r",register_operand:SI:"r",register_operand:SI:"r");
	root.2.mode:=SI;
}
{:
      ""
        "remu \\t%0, %1, %2"
:}


abstract set_neg extends set
{
	root.2:=neg;
}

concrete negsi2.insn instantiates set_neg
{
	set_neg(register_operand:SI:"=r",register_operand:SI:"r");
	root.2.mode:=SI;
}
{:
        ""
        "neg \\t%0, %1"
:}

abstract set_not extends set
{
	root.2:=not;
}

concrete one_cmplsi2.insn instantiates set_not
{
	set_not(register_operand:SI:"=r",register_operand:SI:"r");
	root.2.mode:=SI;
}
{:
	""
	"not \\t%0, %1"
:}


abstract set_ior extends set
{
	root.2:=ior;
}

concrete iorsi3.insn instantiates set_ior
{
	set_ior(register_operand:SI:"=r,r",register_operand:SI:"r,r",nonmemory_operand:SI:"r,K");
	root.2.mode:=SI;
}
{:
        ""
        "@
	  or \\t%0, %1, %2
	  ori \\t%0, %1, %c2"
:}


abstract set_xor extends set
{
	root.2:=xor;
}

concrete xorsi3.insn instantiates set_xor
{
	set_xor(register_operand:SI:"=r,r",register_operand:SI:"r,r",nonmemory_operand:SI:"r,K");
	root.2.mode:=SI;
}
{:
""
        "@
          xor \\t%0, %1, %2
          xori \\t%0, %1, %c2"
:}

abstract set_minus extends set
{
	root.2:=minus;
}

concrete subsi3.insn instantiates set_minus
{
	set_minus(register_operand:SI:"=r",register_operand:SI:"r",register_operand:SI:"r");
	root.2.mode:=SI;
}
{:
      ""
        "sub \\t%0, %1, %2"
:}

abstract set_ashift extends set
{
	root.2:=ashift;
}

concrete ashlsi3.insn instantiates set_ashift
{
	set_ashift(register_operand:SI:"=r,r",register_operand:SI:"r,r",nonmemory_operand:SI:"r,J");
	root.2.mode:=SI;
}
{:
      ""
        "@
	 sllv \\t%0, %1, %2
	 sll \\t%0, %1, %c2"
:}


abstract set_ashiftrt extends set
{
	root.2:=ashiftrt;
}

concrete ashrsi3.insn instantiates set_ashiftrt
{
	set_ashiftrt(register_operand:SI:"=r,r",register_operand:SI:"r,r",nonmemory_operand:SI:"r,J");
	root.2.mode:=SI;
}
{:
      ""
        "@
         srav \\t%0, %1, %2
         sra \\t%0, %1, %c2"
:}


abstract set_lshiftrt extends set
{
	root.2:=lshiftrt;
}

concrete lshrsi3.insn instantiates set_lshiftrt
{
	set_lshiftrt(register_operand:SI:"=r,r",register_operand:SI:"r,r",nonmemory_operand:SI:"r,J");
	root.2.mode:=SI;
}
{:
      ""
        "@
         srlv \\t%0, %1, %2
         srl \\t%0, %1, %c2"
:}

concrete nop.insn instantiates sequence
{
	sequence(const_int:0);
}
{:
""
  "nop"
:}
