#include <stdio.h>
#include <string.h>
#include "srtl-patterns.h"
#include "srtl-parse.tab.h"
#include "srtl-symtab.h"
#include "srtl-support.h"

rtlSpecList * join_Rtl_Spec_List(rtlSpecList * list_1, rtlSpecList * list_2)
{
	rtlSpecList * cur;

	if (list_1 == NULL)
		return list_2;
	else
	{
		cur = list_1;

		while (cur->next != NULL)
			cur = cur->next;

		cur->next = list_2;
	}
	return list_1;
}
	

rtlSpecList * append_Rtl_Spec(rtlSpecList * list, rtlSpec * rtl_spec)
{
	rtlSpecList * cur, * temp;

	temp = (rtlSpecList *)safe_Malloc(sizeof(rtlSpecList));

	temp->rtl_spec = rtl_spec;
	temp->next = NULL;

	if (list == NULL)
		list = temp;
	else
	{
		cur = list;

		while (cur->next != NULL)
			cur = cur->next;

		cur->next = temp;
	}
	return list;
}

rtlList * append_Rtl_list(char * rtl, rtlList * list)
{
	rtlList * cur, * temp;
	temp = (rtlList *)safe_Malloc(sizeof(rtlList));
	temp->rtl = rtl;
	temp->next = list;
	return temp;
}

rtlList * append_Rtl(char * rtl1, char * rtl2)
{
	rtlList * cur, * temp1,*temp2;

	temp1 = (rtlList *)safe_Malloc(sizeof(rtlList));
	temp2 = (rtlList *)safe_Malloc(sizeof(rtlList));
	temp1->rtl = strdup(rtl1);
	temp1->next =temp2;
	temp2->rtl= strdup(rtl2);
	temp2->next = NULL;
	return temp1;
}

opdList * add_brackets_at_ends(opdList *list)
{
	opdList * cur, * temp1, * temp2;
	Operand * opd1, * opd2;
	opd1 = (Operand *)safe_Malloc(sizeof(Operand));
	opd2 = (Operand *)safe_Malloc(sizeof(Operand));	
	opd1->opd_category=6;opd2->opd_category=7;
	opd1->name1=opd1->name2=opd1->name3=opd2->name1=opd2->name2=opd2->name3=NULL;
	opd1->num1=opd1->num2=opd2->num1=opd2->num2=0;
	opd2->op_no=-1;
	temp1 = (opdList *)safe_Malloc(sizeof(opdList));
	temp2 = (opdList *)safe_Malloc(sizeof(opdList));
	temp1->opd=opd1;
	temp2->opd=opd2;
	cur=list;
	while (cur->next != NULL)
		cur = cur->next;
	cur->next=temp2;
	temp1->next=list;
	return temp1;
	
}

opdList * add_special_brackets_at_ends(char * name,opdList *list,int op_no)
{
	opdList * cur, * temp1, * temp2;
	Operand * opd1, * opd2;
	opd1 = (Operand *)safe_Malloc(sizeof(Operand));
	opd2 = (Operand *)safe_Malloc(sizeof(Operand));	
	opd1->opd_category=6;opd2->opd_category=7;
	opd1->name1=opd1->name2=opd1->name3=opd2->name3=opd2->name2=NULL;
	opd2->name1=strdup(name);
	opd2->op_no=op_no;
	opd1->num1=opd1->num2=opd2->num1=opd2->num2=0;
	temp1 = (opdList *)safe_Malloc(sizeof(opdList));
	temp2 = (opdList *)safe_Malloc(sizeof(opdList));
	temp1->opd=opd1;
	temp2->opd=opd2;
	cur=list;
	while (cur->next != NULL)
		cur = cur->next;
	cur->next=temp2;
	temp1->next=list;
	//printf("%s",name);
	return temp1;
	
}

opdList * add_special_brackets_at_ends_sub(int num,opdList *list,int op_no)
{
	opdList * cur, * temp1, * temp2;
	Operand * opd1, * opd2;
	opd1 = (Operand *)safe_Malloc(sizeof(Operand));
	opd2 = (Operand *)safe_Malloc(sizeof(Operand));	
	opd1->opd_category=6;opd2->opd_category=7;
	opd1->name1=opd1->name2=opd1->name3=opd2->name3=opd2->name2=opd2->name1=NULL;
	opd1->num1=opd1->num2=opd2->num1=opd2->num2=0;
	if(op_no==-1)	
		opd2->num1=num;
	opd2->op_no=op_no;
	temp1 = (opdList *)safe_Malloc(sizeof(opdList));
	temp2 = (opdList *)safe_Malloc(sizeof(opdList));
	temp1->opd=opd1;
	temp2->opd=opd2;
	cur=list;
	while (cur->next != NULL)
		cur = cur->next;
	cur->next=temp2;
	temp1->next=list;
	//printf("furr%dfurr\n",num);
	return temp1;
	
}

opdList * join_Opd_list(opdList *list1,opdList * list2)
{
	opdList * temp;
	if(list1==NULL)
		return list2;
	temp=list1;
	while(temp->next!=NULL)
		temp=temp->next;
	temp->next=list2;
	return list1;
}
	
opdList * append_Opd(opdList * list, Operand * opd)
{
	opdList * cur, * temp;

	temp = (opdList *)safe_Malloc(sizeof(opdList));

	temp->opd = opd;
	temp->next = NULL;

	if (list == NULL)
		list = temp;
	else
	{
		cur = list;

		while (cur->next != NULL)
			cur = cur->next;

		cur->next = temp;
	}
	        
	return list;
}
	
stmtList * append_Stmt(stmtList * list, Stmt * stmt)
{
	stmtList * cur, * temp;

	temp = (stmtList *)safe_Malloc(sizeof(stmtList));

	temp->stmt = stmt;
	temp->next = NULL;

	if (list == NULL)
		list = temp;
	else
	{
		cur = list;

		while (cur->next != NULL)
			cur = cur->next;

		cur->next = temp;
	}
	return list;
}
	
stmtList * prefix_Stmt(Stmt * stmt, stmtList * list)
{
	stmtList * temp;

	temp = (stmtList *)safe_Malloc(sizeof(stmtList));

	temp->stmt = stmt;
	temp->next = list;

	return temp;
}
	
nameList * append_Name(nameList * list, char * name)
{
	nameList * cur, * temp;

	temp = (nameList *)safe_Malloc(sizeof(nameList));

	temp->name = strdup(name);
	temp->next = NULL;

	if (list == NULL)
		list = temp;
	else
	{
		cur = list;

		while (cur->next != NULL)
			cur = cur->next;

		cur->next = temp;
	}
	return list;
}
	
childList * append_Child_Number(childList * list, int num)
{
	childList * cur, * temp;

	temp = (childList *)safe_Malloc(sizeof(childList));

	temp->child_number = num;
	temp->next = NULL;

	if (list == NULL)
		list = temp;
	else
	{
		cur = list;

		while (cur->next != NULL)
			cur = cur->next;

		cur->next = temp;
	}
	return list;
}
	
Stmt * create_Stmt(patCategory pat_type, stmtCategory stmt_type, Lhs * lhs, Rhs * rhs)
{
	Stmt * stmt;

	stmt = (Stmt *) safe_Malloc(sizeof(Stmt));
	
	stmt->pat_type = pat_type;
	stmt->stmt_type = stmt_type;
	stmt->lhs = lhs;
	stmt->rhs = rhs;
	return stmt;
}

Stmt * set_Pat_Category_of_Stmt(Stmt * stmt, patCategory cat)
{
	stmt->pat_type = cat;
	return stmt;
}

Rhs * create_Rhs (rhsCategory cat, Operand * opd, opdList * opd_list, char * name, nameList * name_list)
{
	Rhs * rhs;

	rhs = (Rhs *) safe_Malloc(sizeof(Rhs));
	switch (cat)
	{
		case single_operand:
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for single operand");
			check_Invariant( name_list == NULL, "non-NULL name_list for single operand");
			check_Invariant( name == NULL, "non-NULL name for single operand");
			check_Invariant( opd != NULL, "NULL operand for single operand");
			break;
		case single_predicate:
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for single predicate");
			check_Invariant( name_list == NULL, "non-NULL name_list for single predicate");
			check_Invariant( opd == NULL, "non-NULL operand for single predicate");
			check_Invariant( name != NULL, "NULL name for single predicate");
			break;
		case single_constraint:
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for single constraint");
			check_Invariant( name_list == NULL, "non-NULL name_list for single constraint");
			check_Invariant( opd == NULL, "non-NULL opd for single constraint");
			check_Invariant( name != NULL, "NULL name for single constraint");
			break;
		case rtl_operator:
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for rtl operator");
			check_Invariant( name_list == NULL, "non-NULL name_list for rtl operator");
			check_Invariant( opd == NULL, "non-NULL opd for rtl operator");
			check_Invariant( name != NULL, "NULL name for rtl operator");
			break;
		case abstract_pattern:
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for abstract pattern name ");
			check_Invariant( name_list == NULL, "non-NULL name_list for abstract pattern name ");
			check_Invariant( opd == NULL, "non-NULL opd for abstract pattern name ");
			check_Invariant( name != NULL, "NULL name for abstract pattern");
			find_Pattern_Name (abstract, name, no_qualifier);
			break;
		case single_mode:
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for single mode ");
			check_Invariant( name_list == NULL, "non-NULL name_list for single mode ");
			check_Invariant( opd == NULL, "non-NULL opd for single mode ");
			check_Invariant( name != NULL, "NULL name for single mode");
			break;
		case predicate_list:
			check_Invariant( name == NULL, "non-NULL name for predicate name_list");
			check_Invariant( opd == NULL, "non-NULL opd for predicate name_list");
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for predicate name_list");
			check_Invariant( name_list != NULL, "NULL name list for predicate list");
			break;
		case constraint_list:
			check_Invariant( name == NULL, "non-NULL name for constraint name_list");
			check_Invariant( opd == NULL, "non-NULL opd for constraint name_list");
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for constraint name_list");
			check_Invariant( name_list != NULL, "NULL name list for constraint list");
			break;
		case instantiation:
			check_Invariant( name != NULL, "NULL pattern name for instantiation");
			check_Invariant( opd_list != NULL, "NULL operand list for instantiation");
			check_Invariant( opd == NULL, "non-NULL opd for instantiation");
			check_Invariant( name_list == NULL, "non-NULL name_list for instantiation");
			break;
		case const_unspec:
			check_Invariant( opd_list == NULL, "non-NULL opd name_list for single mode ");
			check_Invariant( name_list == NULL, "non-NULL name_list for single mode ");
			check_Invariant( opd == NULL, "non-NULL opd for single mode ");
			check_Invariant( name != NULL, "NULL name for single mode");
			break;
		default:
			report_Internal_Error("Wrong category of rhs");
			break;
	}
	rhs->rhs_category = cat;
	rhs->name = name;
	rhs->opd = opd;
	rhs->name_list = name_list;
	rhs->opd_list = opd_list;

	return rhs;
}

Rhs * create_Single_Operand_Rhs (Operand * opd)
{
	return create_Rhs(single_operand, opd, NULL, NULL, NULL);
}

Rhs * create_Constraint_List_Rhs (nameList * list)
{
	return create_Rhs(constraint_list, NULL, NULL, NULL, list);
}

Rhs * create_Predicate_List_Rhs (nameList * list)
{
	return create_Rhs(predicate_list, NULL, NULL, NULL, list);
}

Rhs * create_Rtl_Op_Rhs (char * name)
{
	return create_Rhs(rtl_operator, NULL, NULL, name, NULL);
}

Rhs * create_Abstract_Pattern_Rhs (char * name)
{
	return create_Rhs(abstract_pattern, NULL, NULL, name, NULL);
}

Rhs * create_Instantiation_Rhs (char * name, opdList * list)
{
	return create_Rhs(instantiation, NULL, list, name, NULL);
}


Rhs * create_Single_Mode_Rhs (char * name)
{
	return create_Rhs(single_mode, NULL, NULL, name, NULL);
}

Rhs * create_Single_Predicate_Rhs (char * name)
{
	return create_Rhs(single_predicate, NULL, NULL, name, NULL);
}

Rhs * create_Single_Constraint_Rhs (char * name)
{
	return create_Rhs(single_constraint, NULL, NULL, name, NULL);
}

Rhs * create_Const_Unspec_Rhs ( char * name)
{
	return create_Rhs(const_unspec,NULL,NULL,name,NULL);
}

Lhs * create_Lhs (lhsCategory cat, childList * child_list, char * name)
{
	Lhs * lhs;

	
	lhs = (Lhs *) safe_Malloc(sizeof(Lhs));
	lhs->lhs_type = cat;
	if (cat == node_access)
	{
		if (name != NULL)
		{
			check_Attribute_Name (name);
			if(!strcmp(name,"predicate"))
				lhs->lhs_type =5;
			else if(!strcmp(name,"constraint"))
				lhs->lhs_type =6;
			else if(!strcmp(name,"mode"))
				lhs->lhs_type =4;	
			else if(!strcmp(name,"const_unspec"))
				lhs->lhs_type =7;	
		}
		check_Invariant ((child_list != NULL ),
				"NULL child list for node access");
	}
	else if (cat == mode_modification)
	{
		check_Invariant ((child_list == NULL),
				"Non-null child list ");
	}
	else 
	{
		check_Invariant ((child_list == NULL && (name == NULL)),
				"Non-null child list and attribute name ");
	}
	lhs->child_list = child_list;
	lhs->name = name;
	return lhs;
}

Operand * create_Operand (opdCategory cat, char * name1, char * name2, char * name3, int num1, int num2,int op_no)
{
	Operand * opd;
	int l;
	opd = (Operand *) safe_Malloc(sizeof(Operand));
	opd->opd_category = cat;
	opd->op_no=op_no;
	switch (cat)
	{
		case p_m_c_spec:

			opd->name1 = name1;
			opd->name2 = name2;
			opd->name3 = name3;
			opd->num1 = opd->num2 = 0;
			break;
		case dup_num_spec:
		case num_spec:
			opd->num1 = num1;
			check_Invariant (((name1 == NULL) &&
					 (name2 == NULL) &&
					 (name3 == NULL)),
					"Names should be NULL for match_dup or number");
			opd->name1 = opd->name2 = opd->name3 = NULL;
			opd->num2 = 0;
			break;
		case reg_spec:
			if (strcmp(name1, "reg") == 0)
			{
				opd->name1 = name1;
				opd->name2 = name2;
				opd->name3 = name3;
				opd->num1 = opd->num2 = 0;
			}
			else
			{	
				l=strlen(name1);
				check_Invariant((strcmp(name1+l-4,"_REG")==0),
						"Error in register specification");
				check_Invariant((name2 == NULL) && (name3 == NULL),
						"Multiple names in fixed register");
				opd->name1 = name1;
				opd->name2 = opd->name3 = NULL;
				opd->num1 = opd->num2 = 0;
			}
			break;
		case reg_num_spec:
			if (strcmp(name1, "reg") == 0)
			{
				opd->name1 = name1;
				opd->name2 = name2;
				opd->num1 = num1;
				opd->num2 = 0;
			}
			else
				check_Invariant(name3 == NULL,
					"Error in reg_num_spec");
			break;
		case extra_reg_spec:
			 check_Invariant(((strcmp(name1, "scratch") == 0) ||
					(strcmp(name1, "cc0") == 0) ||
					(strcmp(name1, "return") == 0)||
					(strcmp(name1, "eh_return") == 0)||
					(strcmp(name1, "pc") == 0)),
					"Error in register specification");
			check_Invariant((name2 == NULL) && (name3 == NULL),
					"Multiple names in fixed register");
			opd->name1 = name1;
			opd->name2 = opd->name3 = NULL;
			opd->num1 = opd->num2 = 0;
			break;
		case const_spec:
			check_Invariant(is_Constant_Specifier(name1),
					"Wrong constant specifier in constant specification");
			check_Invariant(name3 == NULL,
					"Additional name in constant specifier");
			opd->name1 = name1;
			opd->name2 = name2;
			opd->name3 = NULL;
			opd->num1 = num1;
			opd->num2 = 0;
			break;
		case scratch_spec:
			check_Invariant(name3 == NULL,
					"Additional name in scratch specifier");
			opd->name1 = name1;
			opd->name2 = name2;
			opd->name3 = NULL;
			opd->num1 = opd->num2 = 0;
			break;
		default: report_Internal_Error("Wrong operand category");
			break;
	}
	return opd;
}

rtlSpec * create_Rtl_Spec (qualifiedName q_name, refineOp op, stmtList * stmt_list, char * cmd_body)
{
	rtlSpec * rtl_spec;
	char * name;
	insnQualifier qualifier;

	
	rtl_spec = (rtlSpec *) safe_Malloc(sizeof(rtlSpec));

	name = q_name.name;
	qualifier = q_name.qualifier;
	rtl_spec->name = name;
	rtl_spec->qualifier = qualifier;
	rtl_spec->refinement = op;
	rtl_spec->stmt_list = stmt_list;
	rtl_spec->cmd_body = cmd_body;

	return rtl_spec;
}

int peepcount=1,splitcount=1,insnsplitcount=1;
patternSpec * create_Pattern(qualifiedName q_name, patCategory pat_type, rtlSpecList * in_list, rtlSpecList * out_list)
{
	patternSpec * pattern;
	char * name;
	insnQualifier qualifier;

	pattern = (patternSpec *) safe_Malloc(sizeof(patternSpec));

	name = q_name.name;
	qualifier = q_name.qualifier;
	pattern->name = name;
	pattern->qualifier = qualifier;
	pattern->pat_type = pat_type;
	pattern->rtl_spec_list_in = in_list;
	pattern->rtl_spec_list_out = out_list;
	if(name==NULL)
		if(qualifier==3)
		{
			pattern->name=strdup(strcat(strdup("peep"),itoa(peepcount)));
			peepcount++;
		}
		else if (qualifier==5)
		{
			pattern->name=strdup(strcat(strdup("insn_and_split"),itoa(insnsplitcount)));
			insnsplitcount++;
		}
		else
		{
			pattern->name=strdup(strcat(strdup("split"),itoa(splitcount)));
			splitcount++;
		}
	enter_Pattern_in_Symtab(pattern);
	return pattern;
}

#if 0
patternSpec * process_Pattern_Spec(patCategory cat, refineOp op, char * name, char * base, stmtList * list)
{
	rtlSpec * rtl_spec;
	rtlSpecList * rtl_spec_list;
	patternSpec * pattern;

	rtl_spec = create_Rtl_Spec(base, extends, list);
	rtl_spec_list = append_Rtl_Spec(NULL, rtl_spec);
	pattern = create_Pattern (name, abstract, rtl_spec_list);
	print_Pattern (pattern);
	return pattern;
}
#endif

void check_Attribute_Name (char * name)
{
	if (! ((strcmp(name, "mode") == 0) ||
	        (strcmp(name, "constraint") == 0) ||
		(strcmp(name,"const_unspec") == 0) ||
	        (strcmp(name, "predicate") == 0)))
		report_Input_Error ("Wrong attribute name of a node in the pattern tree");
}

void find_Pattern_Name (patCategory cat, char * name, insnQualifier qualifier)
{
	char * mesg;
	bool found = false;
	symEntry * sym;
	char * qualifier_name;
	insnQualifier sym_qualifier;

	if ((name != NULL) && (find_Token_of_Name(name) != RTLOP))
	{
		sym = lookup_Symtab(name);

		if (sym != NULL)
		{
			/* match the qualifier */
			sym_qualifier = get_Qualifier_of_Symbol(sym);
			if ((qualifier == no_qualifier) || (qualifier == sym_qualifier))
				found = true;
		}
		if (!found)
		{
			mesg = (char *) safe_Malloc(strlen(name) + 100);
			qualifier_name = get_Qualifier_String(qualifier);
			if (qualifier_name != NULL)
				sprintf (mesg, "Pattern name %s with qualifier \"%s\" has not been defined", name,
						get_Qualifier_String(qualifier));
			else
				sprintf (mesg, "Pattern name %s has not been defined", name);

			report_Input_Error(mesg);
		}
	}
}

int find_rtl_operator(char * name)
{
	int i;bool found=false;
	char *mesg;
	i = 0;
	while (i<rtl_oper)
	{
		if(!strcmp(name, rtl_tree[i].name))
			return rtl_tree[i].no_of_children;
		i=i+1;
	}
	
	mesg = (char *) safe_Malloc(strlen(name) + 100);
	sprintf (mesg, "No such rtl operator exists %s", name);
	report_Input_Error(mesg);
}

int find_rtl_operator_list(rtlList * rtl_list)
{
	find_rtl_operator(rtl_list->rtl);
}

void gen_error(char *name)
{
	char *mesg;
	mesg = (char *) safe_Malloc(strlen(name) + 100);
	sprintf (mesg, "No of child diff for rtl operator exists %s", name);
	report_Input_Error(mesg);	
}

qualifiedName make_Qualified_Name (char * name, insnQualifier qualifier)
{
	qualifiedName q_name;

	q_name.name = name;
	q_name.qualifier = qualifier;
	
	return q_name;
}
					
/*********************************** Stubs *************************************/

bool is_Constant_Specifier (char * name)
{
	return true;
}

void print_pattern_specs(void)
{}
void evaluate_pattern(void)
{}
void generate_conventional_md_specs(void)
{}

/********************************** Print Functions ******************************/

void print_Rhs(Rhs * rhs)
{
	
	rhsCategory cat;
	Operand * opd;
	char * name;
	nameList * name_list;
        opdList * opd_list;  // new added

	cat = rhs->rhs_category;
	opd = rhs->opd;
	name = rhs->name;
	name_list = rhs->name_list;
        opd_list = rhs->opd_list;
        
	switch (cat)
	{
		case single_operand:
			print_Operand (opd);
			break;
		case single_predicate:
			printf ("Predicate %s ",name);
			break;
		case single_constraint:
			printf ("Constraint %s ",name);
			break;
		case rtl_operator:
			printf ("RTL Operator %s ",name);
			break;
		case abstract_pattern:
			printf ("Abstract Pattern %s ",name);
			break;
		case single_mode:
			printf ("Mode %s ",name);
			break;
		case predicate_list:
			printf ("Predicates : ");
			print_Name_List(name_list);
			break;
		case constraint_list:
			printf ("Constraints : ");
			print_Name_List(name_list);
			break;
		case instantiation:
			printf ("%s(",name);
			print_Operand_List(opd_list);
			printf (")");
			break;
		default:
			report_Internal_Error("wrong category of rhs");
			break;
	}
}

void print_Name_List (nameList * list)
{	if (list != NULL)
	{	
		printf (" %s", list->name);
		list = list->next;
		while (list != NULL)
		{
			printf (", %s", list->name);
			list = list->next;
		}
	} 
}

void print_Operand_List (opdList * list)
{	if (list != NULL)
	{	
		print_Operand (list->opd);
		list = list->next;
		while (list != NULL)
		{
			printf (",");
                        print_Operand (list->opd);
			list = list->next;
		}
	} 
}


void print_Operand (Operand * opd)
{
	opdCategory cat;
	char * name1, *name2, *name3;
	int num1, num2;

	cat = opd->opd_category;
	name1 =	opd->name1;
	name2 =	opd->name2;
	name3 =	opd->name3;
	num1 = opd->num1; 
	num2 = opd->num2;

	switch (cat)
	{
		case p_m_c_spec:	
			printf ("%s:%s:%s", name1, name2, name3);
			break;
		case dup_num_spec:
			printf ("match_dup %d", num1);
			break;
		case num_spec:
			printf ("%d", num1);
			break;
		case reg_spec:
			if (strcmp(name1, "reg") == 0)
				printf ("%s(%s:%s)", name1, name2, name3);
			else
				printf ("%s", name1);
			break;
		case reg_num_spec:
			if (strcmp(name1, "reg") == 0)
				printf ("%s(%s:%d)", name1, name2, num1);
			break;
		case extra_reg_spec:
			printf("%s",name1);
			break;
		case const_spec:
			if (name2 == NULL)
				printf ("%s:%d",name1, num1);
			else
				printf ("%s:%d:%s",name1, num1, name2);
			break;
		case scratch_spec:
				printf ("%s:%s",name1, name2);
			break;
		default: report_Internal_Error("Wrong operand category");
			break;
	}
}

void print_Stmt_List(stmtList * list)
{
	Stmt * stmt;
	Lhs * lhs;
	Rhs * rhs;
	patCategory cat;

	while (list != NULL)
	{
		stmt = list->stmt;
		lhs = stmt->lhs;
		rhs = stmt->rhs;
		cat = stmt->pat_type;

	/*
		print_Pat_Category(cat);
	*/
		printf ("\n\t");
		if (lhs)	/* Lhs is empty for instantiation */
		{
			if (print_Lhs(lhs))
				printf (":= ");
		}
		print_Rhs(rhs);

		list = list->next;
	}
	printf ("\n");
}

void print_Pat_Category(patCategory cat)
{
	switch (cat)
	{
		case abstract:
			printf ("\n\tABSTRACT ");
			break;
		case concrete:
			printf ("\n\tCONCRETE ");
			break;
		case uninitialized:
			printf ("\n\tUNINITIALIZED ");
			break;
		default:
			report_Internal_Error ("Wrong category of pattern");
			break;
	}
}

bool print_Lhs(Lhs * lhs)
{
	childList * clist;
	char * name, *connector;
	bool found_lhs = false;
	lhsCategory cat;
	
	clist = lhs->child_list;
	name = lhs->name;
	cat = lhs->lhs_type;

	if (clist != NULL)
	{
		printf ("root");
		do
		{
			printf (".%d",clist->child_number);
			clist = clist->next;	
		}
		while (clist != NULL);

		found_lhs = true;
	}
	
	if (cat == node_access)
		connector = ".";
	else
		connector = "";
	if (name != NULL)	
	{
		printf ("%s%s ", connector, name);
		found_lhs = true;
	}	

	return found_lhs;
}

void print_Rtl_Spec (rtlSpec * rtl_spec)
{
	char * name, * qualifier, * cmd_body;
	stmtList * stmt_list;
	refineOp op;

	name = rtl_spec->name;
	qualifier = get_Qualifier_String (rtl_spec->qualifier);

	if (qualifier != NULL)
	{
		name = append_String(name, ".");
		name = append_String(name, qualifier);
	}

	stmt_list = rtl_spec->stmt_list;
	op = rtl_spec->refinement;
	cmd_body = rtl_spec->cmd_body;

	if (name != NULL)
	{
		printf (" Base pattern %s is ", name);
	}
		switch (op)
		{
			case extends:
				printf ("extended  with the following statement list");
				print_Stmt_List(stmt_list);
				break;
			case instantiates:
				printf ("instantiated with the following statement list");
				print_Stmt_List(stmt_list);
                                if(cmd_body)
                                printf ("spec body%s", cmd_body);
				break;
			case overrides:
				printf ("overriden with the following statement list");
				print_Stmt_List(stmt_list);
                                if(cmd_body)
				printf ("spec body%s", cmd_body);
				break;
			case cmd_spec: 
				printf ("conventional md specs \n%s", cmd_body);
				break;
			default:
				report_Internal_Error ("Wrong refinement operation");
				break;
		}
	
}

void print_Rtl_Spec_List (rtlSpecList * list)
{
	rtlSpecList * cur;
	rtlSpec * rtl_spec;

	cur = list;

	while (cur != NULL)
	{
		rtl_spec = cur->rtl_spec;
		print_Rtl_Spec(rtl_spec);
		cur = cur->next;
	}
}

void print_Pattern (patternSpec * pattern)
{
	rtlSpecList * rtl_spec_list;
	char * name;
	patCategory cat;

	cat = pattern->pat_type;
	name = pattern->name;

	switch (cat)
	{
		case abstract:
			printf ("\n New Abstract Pattern: ");
			break;
		case concrete:
			printf ("\n New Concrete Pattern: ");
			break;
		default:
			report_Internal_Error ("Uninitialized pattern");
			break;
	}
	
	if (name != NULL)
		printf ("%s\n", name);

	rtl_spec_list = pattern->rtl_spec_list_in;
	print_Rtl_Spec_List(rtl_spec_list);

	rtl_spec_list = pattern->rtl_spec_list_out;
	print_Rtl_Spec_List(rtl_spec_list);
}

char * get_Qualifier_String(insnQualifier qualifier)
{
	char * string;

	switch (qualifier)
	{
		case no_qualifier:
			string = NULL;
			break;
		case insn:
			string = "insn";
			break;
		case expand:
			string = "expand";
			break;
		case peephole2:
			string = "peephole2";
			break;
		case split:
			string = "split";
			break;
		case insn_and_split:
			string = "insn_and_split";
			break;
		default:
			string = NULL;
			report_Internal_Error ("Wrong instruction qualifier");
			break;
	}
	return string;
}
