%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define YYERROR_VERBOSE 0
#include "srtl-patterns.h"
#include "srtl-support.h"
int rtl_oper=96;
int allconstraints = 0;
int allpredicates = 0;
 

//int yydebug=1;
%}

%union
{
	char * name;
	childList * child_list;
	int number;
	insnQualifier qualifier;
	Lhs * lhs;
	nameList * name_list;
	opdList * opd_list;
	Operand * opd;
	patternSpec * pattern;
	rtlSpecList * rtl_spec_list;
	rtlSpec * rtl_spec;
	stmtList * stmt_list;
	Stmt * stmt;
	qualifiedName q_name;
	rtlList * rtllist;
}

%type <child_list> Operand_Access
%type <lhs> Attr_Access
%type <stmt> Common_Stmt
%type <stmt> Mode_Stmt
%type <stmt> Abstract_Stmt 
%type <rtllist> rtl_list
%type <stmt> Concrete_Stmt 
%type <stmt_list> Concrete_Stmt_List
%type <stmt_list> Concrete_Inst_Stmt_List
%type <stmt_list> Abstract_Extend_Body
%type <stmt_list> Abstract_Override_Body
%type <stmt_list> Concrete_Override_Body
%type <stmt_list> Concrete_Instantiate_Body
%type <opd> Operand
%type <opd> Fixed_Reg_or_Const
%type <opd_list> Operands
//%type <opd_list> Roperands
//%type <opd_list> Roperand
%type <name_list> Constraint_List
%type <name_list> Predicate_List
%token <name> FIXED_REG
%type <name> Predicate_or_Mode
%type <name> Derived_Name	
%type <name> Derived_Name1
%type <name> Base_Name	
%type <q_name> Qualified_Derived_Name 
%type <q_name> Qualified_Base_Name 
%type <q_name> Qualified_Split_Name 
%type <qualifier> Qualifier
%type <pattern> Concrete_Pattern
%type <pattern> Abstract_Pattern
%type <rtl_spec_list> Concrete_Rtl_Spec_List_In
%type <rtl_spec_list> Concrete_Rtl_Spec_List_Out
%type <rtl_spec> Abstract_Rtl_Spec
%type <rtl_spec> Concrete_Rtl_Spec
%type <rtl_spec> Concrete_Rtl_Spec_In
%type <rtl_spec> Concrete_Rtl_Spec_Out
%type <rtl_spec> Named_Concrete_Instantiate_Body
%type <rtl_spec> Named_Concrete_Override_Body
%type <rtl_spec> New_Named_Concrete_Instantiate_Body
%type <rtl_spec> New_Named_Concrete_Override_Body
%token <number> NUMBER
//%token <name> Code_iterator
%token <name> ID
%token <name> CONCRETE
%token <name> ATTR_NAME
%token <name> PREDICATE
%token <name> CONSTRAINT
%token <name> RTLOP
%token ASSIGN
%token ROOT
%token INSTANTIATES
%token OVERRIDES
%token CONST_INT
%token DEFINE_CODE_ITERATOR
//%token MATCH_OPERATOR
%token INSN
%token EXPAND
%token EXTENDS
%token ABSTRACT
%token ALLCONSTRAINTS
%token ALLPREDICATES
%token DUPLICATE
%token MODE_MODIFIER
%token OUT
%token IN
%token INSN_AND_SPLIT
%token SPLIT
%token PEEPHOLE2
%token RTL_TEMPLATE
%token CMD_SPEC 
%token <name> CMD_SPEC_BODY

%left ','
%%


Pattern_List 
	: Pattern_List Pattern 
	| Pattern
	;

Pattern : Abstract_Pattern
		{
			allconstraints = allpredicates = 0;

			//print_Pattern($1);
			evaluate_pattern();
		}
	| Concrete_Pattern
		{
			allconstraints = allpredicates = 0;

			//print_Pattern($1);
			evaluate_pattern();
			generate_conventional_md_specs();
		}
	
	| Code_iterator
		{
			
		}
	| CMD_SPEC_BODY
		{
                         printf("%s",$1);
		}
	;


Code_iterator
	: '(' DEFINE_CODE_ITERATOR ID '[' rtl_list ']' ')'
		{
			rtl_tris new;//=(rtl_tris*)malloc(sizeof(rtl_tris));
			new.name=strdup($3);
			new.no_of_children=find_rtl_operator_list($5);
			rtl_tree[rtl_oper]=new;	
			rtl_oper++;	
			char * string;
			string = append_String ("(define_code_iterator ", $3);
			string =append_String(string,"[");
			rtlList* rtl_list = $5;
			while(rtl_list!=NULL)
 			{
				string=append_String(string,rtl_list->rtl);
				if(rtl_list->next!=NULL)
					string=append_String(string," ");
				rtl_list=rtl_list->next;
			}
			
			printf("%s])",string);
		}	
	;

rtl_list 
	: RTLOP rtl_list 
			{ 
				if(find_rtl_operator_list($2)==find_rtl_operator($1))
					$$=append_Rtl_list($1,$2);
				//if($2==find_rtl_operator($1))
				//	$$=$2;
				else
				 	gen_error($1);		 
			}
	| RTLOP RTLOP
		{
			//printf("%d %d",find_rtl_operator($2),find_rtl_operator($1));
			//$$=find_rtl_operator($2);
			if(find_rtl_operator($2)==find_rtl_operator($1))
				//$$=S2;
				$$=append_Rtl($1,$2);
			else
				gen_error($2); 
			 
			
		}
	;


Abstract_Pattern    
	: ABSTRACT Derived_Name1 Abstract_Rtl_Spec
		{
			rtlSpecList * rtl_spec_list;
			qualifiedName q_name;

			q_name = make_Qualified_Name ($2, no_qualifier);
			rtl_spec_list = append_Rtl_Spec (NULL, $3);
			$$ = create_Pattern(q_name, abstract, rtl_spec_list, NULL);
		}
	;

Concrete_Pattern    
	: CONCRETE Qualified_Derived_Name  Concrete_Rtl_Spec
		{
			rtlSpecList * rtl_spec_list;

			rtl_spec_list = append_Rtl_Spec (NULL, $3);
			$$ = create_Pattern($2, concrete, rtl_spec_list, NULL);
		}
	| CONCRETE '.' PEEPHOLE2  Concrete_Rtl_Spec_List_In  Concrete_Rtl_Spec_List_Out
		{
			qualifiedName q_name;

			/* check that the number of RTL specs in List_In 
                           (excluding CMD_SPEC_BODY) do not exceed 1 */

			q_name = make_Qualified_Name (NULL, peephole2);

			$$ = create_Pattern(q_name, concrete, $4, $5);
		}
	| CONCRETE Qualified_Split_Name Concrete_Rtl_Spec_List_In  Concrete_Rtl_Spec_List_Out 
		{
			/* check that the number of RTL specs in List_Out 
                           (excluding CMD_SPEC_BODY) do not exceed 1 */

			$$ = create_Pattern($2, concrete, $3, $4);
		}
	;

Abstract_Rtl_Spec
	: EXTENDS Base_Name 
		{
			find_Pattern_Name (abstract, $2, no_qualifier);
		}
               '{' Abstract_Extend_Body '}'
		{
			qualifiedName q_name;

			q_name = make_Qualified_Name ($2, no_qualifier);
			$$ = create_Rtl_Spec(q_name, extends, $5, NULL);
		}
	| OVERRIDES Base_Name 
		/* Override only allows changing the attribute of a node */
		{
			find_Pattern_Name (abstract, $2, no_qualifier);
		}
		'{' Abstract_Override_Body '}'
		{
			qualifiedName q_name;

			q_name = make_Qualified_Name ($2, no_qualifier);
			$$ = create_Rtl_Spec(q_name, overrides, $5, NULL);
		}
	;

Concrete_Rtl_Spec
	: INSTANTIATES Named_Concrete_Instantiate_Body
		{
			$$ = $2;
		}
	| OVERRIDES Named_Concrete_Override_Body
		{
			$$ = $2;
		}
	;

Concrete_Rtl_Spec_In
	: INSTANTIATES '.' IN New_Named_Concrete_Instantiate_Body 
		{
			$$ = $4;
		}
	| OVERRIDES '.' IN New_Named_Concrete_Override_Body 
		{
			$$ = $4;
		}
	| CMD_SPEC '.' IN CMD_SPEC_BODY
		{
			qualifiedName q_name;
	
			q_name = make_Qualified_Name (NULL, no_qualifier);
			$$ = create_Rtl_Spec (q_name, cmd_spec, NULL, $4);
		}
	;

Concrete_Rtl_Spec_Out
	: INSTANTIATES '.' OUT New_Named_Concrete_Instantiate_Body 
		{
			$$ = $4;
		}
	| OVERRIDES '.' OUT New_Named_Concrete_Override_Body 
		{
			$$ = $4;
		}
	| CMD_SPEC '.' OUT CMD_SPEC_BODY
		{
			qualifiedName q_name;
	
			q_name = make_Qualified_Name (NULL, no_qualifier);
			$$ = create_Rtl_Spec (q_name, cmd_spec, NULL, $4);
		}
	;

Concrete_Rtl_Spec_List_Out
	: Concrete_Rtl_Spec_List_Out Concrete_Rtl_Spec_Out
		{
			$$ = append_Rtl_Spec ($1, $2);
		}
	| Concrete_Rtl_Spec_Out
		{
			$$ = append_Rtl_Spec (NULL, $1);
		}
/*
	| CONVENTIONAL_MD_FRAGMENT
		{
			$$ = NULL;
		}
*/
	;

Concrete_Rtl_Spec_List_In
	: Concrete_Rtl_Spec_List_In Concrete_Rtl_Spec_In
		{
			$$ = append_Rtl_Spec ($1, $2);
		}
	| Concrete_Rtl_Spec_In
		{
			$$ = append_Rtl_Spec (NULL, $1);
		}
	;

Named_Concrete_Instantiate_Body
	: Qualified_Base_Name 
		{
			find_Pattern_Name (concrete, $1.name, $1.qualifier);
		}
		'{' Concrete_Instantiate_Body '}' CMD_SPEC_BODY
		{			
			$$ = create_Rtl_Spec($1, instantiates, $4, $6);
		}
                  
	;

Named_Concrete_Override_Body
	: Qualified_Base_Name 
		{
			find_Pattern_Name (concrete, $1.name, $1.qualifier);
		}
		'{' Concrete_Override_Body '}' CMD_SPEC_BODY
		{
			$$ = create_Rtl_Spec($1, overrides, $4, $6);
		}
	;

New_Named_Concrete_Override_Body
	: Qualified_Base_Name 
		{
			find_Pattern_Name (concrete, $1.name, $1.qualifier);
		}
		'{' Concrete_Override_Body '}' 
		{
			$$ = create_Rtl_Spec($1, overrides, $4, NULL);
		}
	;

New_Named_Concrete_Instantiate_Body
	: Qualified_Base_Name 
		{
			find_Pattern_Name (concrete, $1.name, $1.qualifier);
		}
		'{' Concrete_Instantiate_Body '}' 
		{			
			$$ = create_Rtl_Spec($1, instantiates, $4, NULL);
		}
                  
	;


/*Derived_Name1
	:
	Derived_Name1 Derived_Name{}
	| Derived_Name{}
	|
	;
*/


Derived_Name1
	:
	 Derived_Name1 Derived_Name
		{
			char * string;
			string = append_String ("", $1);
			string = append_String(string, $2);
			$$ = string;
		}
	|Derived_Name
		{
			char * string;
			string = append_String ("", $1);
			$$=string;
		}
	;


Derived_Name	
	: 
	/*Derived_Name '<' ID '>' 
		{
			char * string;

			string = append_String ("", $1);
			string = append_String(string, "<");
			string = append_String(string, $3);
			string = append_String(string, ">");
			$$ = string;
		}
	| Derived_Name '<' ID '>' ID  
		{
			char * string;

			string = append_String ("", $1);
			string = append_String(string, "<");
			string = append_String(string, $3);
			string = append_String(string, ">");
			string = append_String(string, $5);
			$$ = string;
		}
	| Derived_Name  ID  
		{
			char * string;

			string = append_String ("", $1);
			string = append_String(string, $2);
			$$ = string;
		}
	| Derived_Name '<' ID '>' NUMBER 
		{
			char * string;

			string = append_String ("", $1);
			string = append_String(string, "<");
			string = append_String(string, $3);
			string = append_String(string, ">");
			string = append_String(string, itoa($5));
			$$ = string;
		}
	| Derived_Name '<' ID '>' NUMBER ID
		{
			char * string;

			string = append_String ("", $1);
			string = append_String(string, "<");
			string = append_String(string, $3);
			string = append_String(string, ">");
			string = append_String(string, itoa($5));
			string = append_String(string, $6);
			$$ = string;
		}*/
	
	 ID 
		{
			char * string; 
			string = append_String ("", $1);
			$$=string;
		}
	| ID  NUMBER
		{
			char * string; 
			string = append_String ("", $1);
			string = append_String(string, itoa($2));
			$$=string;
		}	
	| '<' ID '>'
		{
                 	char * string; 
			string = append_String ("", "<");
			string = append_String(string, $2);
			string = append_String(string, ">");
			$$=string;
		}
	| '<' ID '>' NUMBER
		{
                 	char * string; 
			string = append_String ("", "<");
			string = append_String(string, $2);
			string = append_String(string, ">");
			string = append_String(string, itoa($4));
			$$=string;
		}
	|RTLOP 
		{
			char * string; 
			string = append_String ("", $1);
			$$=string;
		}
	| RTLOP  NUMBER
		{
			char * string; 
			string = append_String ("", $1);
			string = append_String(string, itoa($2));
			$$=string;
		}	
	| '<' RTLOP '>'
		{
                 	char * string; 
			string = append_String ("", "<");
			string = append_String(string, $2);
			string = append_String(string, ">");
			$$=string;
		}
	| '<' RTLOP '>' NUMBER
		{
                 	char * string; 
			string = append_String ("", "<");
			string = append_String(string, $2);
			string = append_String(string, ">");
			string = append_String(string, itoa($4));
			$$=string;
		}

	; 

Base_Name	
	: Derived_Name1	
	;

Qualified_Derived_Name 
	: Derived_Name1 
		{
			$$ = make_Qualified_Name($1, no_qualifier);
		}
	| Derived_Name1 '.' Qualifier
		{
			$$ = make_Qualified_Name($1, $3);
		}
	;

Qualified_Base_Name 
	: Base_Name
		{
			$$ = make_Qualified_Name($1, no_qualifier);
		}
	| Base_Name '.' Qualifier
		{
			$$ = make_Qualified_Name($1, $3);
		}
	;

Qualifier
	: INSN
		{
			$$ = insn;
		}
	| EXPAND
		{
			$$ = expand;
		}
	;

Qualified_Split_Name 
	: Derived_Name1 '.' INSN_AND_SPLIT	
		{ 
			$$ = make_Qualified_Name($1, insn_and_split);
		}
	| '.' SPLIT
		{ 
			$$ = make_Qualified_Name(NULL, split); 
		}
		/* Attention Ankita: 
		   Can we not have derived name and .SPLIT? Or just .INSN_AND_SPLIT without a name?
	        */
	;

Concrete_Instantiate_Body	
	: ID  '(' Operands ')' ';' Concrete_Inst_Stmt_List  
		/* Check if the first ID is a predefined operator. Further this order is important. 
                   If there is an instantiation, it better be the very first statement. */
		{
			Rhs * rhs;
			Stmt * stmt;
			//printf("kool");
			rhs = create_Instantiation_Rhs ($1, $3);
			stmt = create_Stmt(concrete, pat_instantiation, NULL, rhs);
			$$ = prefix_Stmt(stmt, $6);
		}
	| RTLOP  '(' Operands ')' ';' Concrete_Inst_Stmt_List  
		/* This order is important.  If there is an instantiation, it better be the 
                   very first statement. */
		{
			Rhs * rhs;
			Stmt * stmt;

			rhs = create_Instantiation_Rhs ($1, $3);
			stmt = create_Stmt(concrete, rtl_instantiation, NULL, rhs);
			$$ = prefix_Stmt(stmt, $6);
		}	
	;

Concrete_Inst_Stmt_List 
	: Concrete_Inst_Stmt_List  Mode_Stmt
		{
			$$ = append_Stmt($1, $2);
		}
	| /* Empty concrete body allowed */	
		{
			$$ = NULL;
		}
	;
Predicate_or_Mode
	: PREDICATE
		{
			$$=$1;
		}
	|'<' PREDICATE '>'
		{
			char * string;
			string=append_String("<",$2);
			string=append_String(string,">");
			$$=string;
		}
	|ID
		{
			$$=$1;
		}
	|'<' ID '>'
		{
			char * string;
			string=append_String("<",$2);
			string=append_String(string,">");
			$$=string;
		}
	|"NULL"
		{
			char * string;
			string=append_String("","NULL");
			$$=string;
		}		
	;

	


Concrete_Override_Body	
	: Predicate_or_Mode MODE_MODIFIER Predicate_or_Mode ';' Concrete_Override_Body
		{
			Rhs * rhs;
			Lhs * lhs;
			Stmt * stmt;

			rhs = create_Single_Mode_Rhs ($3);
			lhs = create_Lhs(mode_modification, NULL, $1);
			stmt = create_Stmt(concrete, mode_modifier, lhs, rhs);
			$$ = prefix_Stmt(stmt, $5);
		}
	| Concrete_Stmt_List
	;

Concrete_Stmt_List 
	: Concrete_Stmt_List  Concrete_Stmt
		{
			$$ = append_Stmt($1, $2);
		}
	| /* Empty concrete body allowed */	
		{
			$$ = NULL;
		}
	;

Concrete_Stmt 
	: ROOT Operand_Access ASSIGN Operand ';' /* Set the value of a leaf node as an operand */ 
		{
			Lhs * lhs;
			Rhs * rhs;

			lhs = create_Lhs(node_access,$2,NULL);
			rhs = create_Single_Operand_Rhs($4);
			$$ = create_Stmt(concrete, asgn, lhs,rhs);
		}
	| ALLCONSTRAINTS ASSIGN '(' Constraint_List ')' ';'           
		{      
			Lhs * lhs;
			Rhs * rhs;

			allconstraints++ ; 
		 	if(allconstraints>1) report_Input_Error("Multiple allconstraints assignments");;

			lhs = create_Lhs(all_constraints,NULL,NULL);
			rhs = create_Constraint_List_Rhs($4);
			$$ = create_Stmt(concrete, asgn, lhs,rhs);
		}
	|  ALLPREDICATES ASSIGN '(' Predicate_List ')' ';'  		 
		{
			Lhs * lhs;
			Rhs * rhs;

			allpredicates++;
		        if(allpredicates > 1) report_Input_Error("Multiple allpredicate assignments");;

			lhs = create_Lhs(all_predicates,NULL,NULL);
			rhs = create_Predicate_List_Rhs($4);
			$$ = create_Stmt(concrete, asgn, lhs,rhs);
		}
	| Common_Stmt
		{
			$$ = set_Pat_Category_of_Stmt($1, concrete);
		}
	;

Operand_Access	 
	: Operand_Access '.' NUMBER 
			{
				$$ = append_Child_Number($1, $3);
			}	
	| '.' NUMBER 	{
				$$ = append_Child_Number(NULL, $2);
			}
	
	;     


Operands
	: Operands ',' Operands
		{       
			$$ = join_Opd_list($1, $3);
		}
	| '(' Operands ')'
		{
			$$=add_brackets_at_ends($2);
		}
	| '('  '<' ID '>' ',' Operands ')'
		{
			$$=add_special_brackets_at_ends($3,$6,-1);	
		}
	| '(' '<' '<' ID '>' '>' ',' Operands ')'
		{
			char *string;
			string = append_String ("<",$4 );
			string = append_String (string,">" );
			$$=add_special_brackets_at_ends(string,$8,-1);			
		}
	| '(' '<' PREDICATE '>' ',' Operands ')'
		{
			$$=add_special_brackets_at_ends($3,$6,-1);	
		}
	| '(' '<' '<' PREDICATE '>' '>' ',' Operands ')'
		{
			char *string;
			string = append_String ("<",$4 );
			string = append_String (string,">" );
			$$=add_special_brackets_at_ends(string,$8,-1);
		}	
	| '('  NUMBER '=' '<' ID '>' ',' Operands ')'
		{
			$$=add_special_brackets_at_ends($5,$8,$2);	
		}
	| '(' NUMBER '=' '<' '<' ID '>' '>' ',' Operands ')'
		{
			char *string;
			string = append_String ("<",$6 );
			string = append_String (string,">" );
			$$=add_special_brackets_at_ends(string,$10,$2);			
		}
	| '(' NUMBER '=' '<' PREDICATE '>' ',' Operands ')'
		{
			$$=add_special_brackets_at_ends($5,$8,$2);	
		}
	| '(' NUMBER '=' '<' '<' PREDICATE '>' '>' ',' Operands ')'
		{
			char *string;
			string = append_String ("<",$6 );
			string = append_String (string,">" );
			$$=add_special_brackets_at_ends(string,$10,$2);	
		}
	| '(' Operands ','  '<' ID '>'  ')'
		{
			$$=add_special_brackets_at_ends($5,$2,-1);		
		}
	| '(' Operands ','  '<' NUMBER '>' ')'
		{
			$$=add_special_brackets_at_ends_sub($5,$2,-1);	
		}
	| '(' '<' NUMBER '>' ',' Operands ')'
		{
			$$=add_special_brackets_at_ends_sub($3,$6,$3);
		}
	/*| Operands ',' Operands
		{
			$$=join_Opd_list($1,$3);
		}*/
	| Operand 
		{
			$$ = append_Opd(NULL, $1);
		}
	;


Operand		
	: Predicate_or_Mode ':' Predicate_or_Mode ':' CONSTRAINT
		/* Check if the first operand is a predefined predicate(including null), second ID is a mode  */
		{
			$$ = create_Operand(p_m_c_spec, $1, $3, $5, 0, 0,-1);
		}
	| NUMBER '=' Predicate_or_Mode ':' Predicate_or_Mode ':' CONSTRAINT
		/* Check if the first operand is a predefined predicate(including null), second ID is a mode  */
		{
			$$ = create_Operand(p_m_c_spec, $3, $5, $7, 0, 0,$1);
		}
	| DUPLICATE NUMBER    /* Corresponds to match_dup */
		{
			$$ = create_Operand(dup_num_spec, NULL, NULL, NULL, $2, 0,-1);
		}
	| Predicate_or_Mode ':' CONSTRAINT /* Corresponds to match_scratch */
		{
			$$ = create_Operand(scratch_spec, $1, $3, NULL, 0, 0,-1);
		}
	| NUMBER  '=' Predicate_or_Mode ':' CONSTRAINT /* Corresponds to match_scratch */
		{
			$$ = create_Operand(scratch_spec, $3, $5, NULL, 0, 0,$1);
		}
	| NUMBER
		{
			$$ = create_Operand(num_spec, NULL, NULL, NULL, $1, 0,-1);
		}
	| Fixed_Reg_or_Const	
				/* For register,memory,constant etc operands */	

	;

Fixed_Reg_or_Const
	: ID '(' Predicate_or_Mode ':' FIXED_REG ')' /* First ID should be reg . Corresponds to the register operand */
		{
			char * string;
			string=append_String("",$5);
			$$ = create_Operand(reg_spec, $1, $3, string, 0, 0,-1);
		}
	|ID '(' Predicate_or_Mode ':' NUMBER ')' /* First ID should be reg . Corresponds to the register operand */
		{
			$$ = create_Operand(reg_num_spec, $1, $3,NULL, $5, 0,-1);
		}
	| FIXED_REG /* Should be a REG*/
		{
			char * string;
			string=append_String("",$1);
			$$ = create_Operand(reg_spec, string, NULL, NULL, 0, 0,-1);
		}
	| ID  /*pc,cc0,scratch,return,eh_return */
		{
			$$ = create_Operand(extra_reg_spec, $1, NULL, NULL, 0, 0,-1);
		}
	| CONST_INT ':' NUMBER {/* First ID should be constant specifier */} 
		{
			char * string;
			string=append_String("","const_int");
			$$ = create_Operand(const_spec, string, NULL, NULL, $3, 0,-1);
		}
	| CONST_INT ':' NUMBER  ':' ID {/* First ID should be constant specifier */} 
		{
			char * string;
			string=append_String("","const_int");
			$$ = create_Operand(const_spec, string, $5, NULL, $3, 0,-1);
		}
	;

Abstract_Extend_Body 
	: Abstract_Extend_Body Abstract_Stmt
		{
			$$ = append_Stmt($1, $2);
		}
	| Abstract_Stmt
		{
			$$ = append_Stmt(NULL, $1);
		}
	;

Abstract_Override_Body 
	: Abstract_Override_Body Common_Stmt
		{
			$$ = append_Stmt($1, $2);
		}
	| Common_Stmt
		{
			$$ = append_Stmt(NULL, $1);
		}
	;

Abstract_Stmt 
	: ROOT Operand_Access ASSIGN RTLOP ';' /* Access a node and extend using an operator */
		{
			Lhs * lhs;
			Rhs * rhs;

			lhs = create_Lhs(node_access,$2,NULL);
			rhs = create_Rtl_Op_Rhs($4);
			$$ = create_Stmt(abstract, asgn, lhs, rhs);
		}
	| ROOT Operand_Access ASSIGN ID ';' /* Access a node and extend using an abstract pattern predefined */
		{
			Lhs * lhs;
			Rhs * rhs;

			lhs = create_Lhs(node_access,$2,NULL);
			rhs = create_Abstract_Pattern_Rhs($4);
			$$ = create_Stmt(abstract, asgn, lhs, rhs);
		}
	| Mode_Stmt
		{
			$$ = set_Pat_Category_of_Stmt($1, abstract);
		}
	;

Mode_Stmt
	:ROOT Attr_Access ASSIGN Predicate_or_Mode ';' /* change the value of an attribute of a node */
		{
			Rhs * rhs;
			if($2->lhs_type==4)
				rhs = create_Single_Mode_Rhs($4);
			if($2->lhs_type==5)
				rhs = create_Single_Predicate_Rhs($4);
			$$ = create_Stmt(uninitialized, asgn, $2,rhs);
		}
	;

Common_Stmt     
	: ROOT Attr_Access ASSIGN Predicate_or_Mode ';' /* change the value of an attribute of a node */
		{
			Rhs * rhs;
			if($2->lhs_type==4)
				rhs = create_Single_Mode_Rhs($4);
			if($2->lhs_type==5)
				rhs = create_Single_Predicate_Rhs($4);
			$$ = create_Stmt(uninitialized, asgn, $2,rhs);
		}
	| ROOT Attr_Access ASSIGN CONSTRAINT ';'
		{
			Rhs * rhs;
			rhs = create_Single_Constraint_Rhs($4);
			$$ = create_Stmt(uninitialized, asgn, $2,rhs);
		}
	;

Predicate_List  
	: Predicate_List ',' Predicate_or_Mode /* Since predicates are predefined, they can be passed as tokens */
		{
			$$ = append_Name ($1, $3);
		}
	| Predicate_or_Mode
		{
			$$ = append_Name (NULL, $1);
		}
 	;

Constraint_List 
	: Constraint_List ',' CONSTRAINT 
		{
			$$ = append_Name ($1, $3);
		}
	| CONSTRAINT
		{
			$$ = append_Name (NULL, $1);
		}
	;

Attr_Access	
	: '.' ID /* Change the attribute of a node */
		{
			$$ = create_Lhs (node_access, NULL, $2);
		}
	| Operand_Access '.' ID
		{
			$$ = create_Lhs (node_access, $1, $3);
		}
	;

%%

int main()
{
/* #if YYDEBUG
	yydebug = 1;

#endif */

	return yyparse();
}

int yyerror(char * s)
{
    fprintf(stderr,"%s %d\n", s,get_Line_Number());
    exit (1);
}

