typedef enum {false=0, true=1} bool;
typedef enum {abstract, concrete, uninitialized} patCategory;
typedef enum {extends, instantiates, overrides, cmd_spec} refineOp;
typedef enum {no_qualifier, insn, expand, peephole2, split, insn_and_split} insnQualifier;
typedef enum {rtl_op, user_defined} patNameCategory;
typedef enum {all_constraints, all_predicates, node_access, mode_modification,node_access_mode,node_access_predicate,node_access_constraint,node_access_const_unspec} lhsCategory;
typedef enum {asgn, pat_instantiation, rtl_instantiation, mode_modifier, constraint_modification} stmtCategory;
typedef enum {p_m_c_spec, dup_num_spec, num_spec, reg_spec, const_spec, scratch_spec,bracket_start,bracket_end,extra_reg_spec,reg_num_spec} opdCategory;
typedef enum {single_operand, single_predicate, single_constraint, single_mode, rtl_operator, 
		predicate_list, constraint_list,abstract_pattern, instantiation,const_unspec} rhsCategory;

typedef struct {
		char * name;
		insnQualifier qualifier;
	} qualifiedName;

typedef struct {
	opdCategory opd_category;
	char * name1;
	char * name2;
	char * name3;
	int num1;
	int num2;
	int op_no;
	} Operand;	

typedef struct olist {
	Operand * opd;
	struct olist * next;
	} opdList;

typedef struct children {
	int child_number;
	struct children * next;
	} childList;

typedef struct nlist {
	char * name;
	struct nlist * next;
	} nameList;

typedef struct {
	lhsCategory lhs_type;
	childList * child_list;
	char * name;
	} Lhs;

typedef struct {
	rhsCategory rhs_category;
	char * name;
	Operand * opd;
	opdList * opd_list;
	nameList * name_list;
	} Rhs;

typedef struct {
	patCategory pat_type;
	stmtCategory stmt_type;
	Lhs * lhs;
	Rhs * rhs;
	} Stmt;

typedef struct slist {
	Stmt * stmt;
	struct slist * next;
	} stmtList;



typedef struct tree_struct {
	char * name;
	int no_of_children;
	char * cons_string;
	int cons_number;
	int mop_no;
	char * mode;
	Operand *opd;
	int constraint_flag;
	int predicate_flag;
	struct tree_struct ** children;
        } tris;

typedef struct {
	char * name;
	insnQualifier qualifier;
	refineOp refinement;
	stmtList * stmt_list;
	char * cmd_body;
	tris * tree_struct;
	} rtlSpec;

typedef struct rsl {
	rtlSpec * rtl_spec;
	struct rsl * next;
	} rtlSpecList;


typedef struct rtl {
	char * rtl;
	struct rtl * next;
	} rtlList;

typedef struct {
	patCategory pat_type;
	char * name;
	insnQualifier qualifier;
	rtlSpecList * rtl_spec_list_in;
	rtlSpecList * rtl_spec_list_out;
	} patternSpec;


typedef struct rtl_t{
	char * name;
	int no_of_children;
	} rtl_tris;



Stmt * create_Stmt(patCategory pat_type, stmtCategory stmt_type, Lhs * lhs, Rhs * rhs);
Stmt * set_Pat_Category_of_Stmt(Stmt * stmt, patCategory cat);
Lhs * create_Lhs (lhsCategory cat, childList * child_list, char * attribute_name);
Rhs * create_Single_Operand_Rhs (Operand * opd);
Rhs * create_Constraint_List_Rhs (nameList * list);
Rhs * create_Predicate_List_Rhs (nameList * list);
Rhs * create_Rtl_Op_Rhs (char * name);
Rhs * create_Abstract_Pattern_Rhs (char * name);
Rhs * create_Single_Mode_Rhs (char * name);
Rhs * create_Single_Predicate_Rhs (char * name);
Rhs * create_Single_Constraint_Rhs (char * name);
Rhs * create_Instantiation_Rhs (char * name, opdList * list);
Operand * create_Operand (opdCategory cat, char * name1, char * name2, char * name3, int num1, int num2,int op_no);
rtlSpec * create_Rtl_Spec (qualifiedName q_name, refineOp op, stmtList * stmt_list, char * cmd_body);
patternSpec * create_Pattern(qualifiedName q_name, patCategory pat_type, rtlSpecList * in_list, rtlSpecList * out_list);

bool is_Constant_Specifier (char * name);
void check_Attribute_Name (char * name);
void find_Pattern_Name (patCategory cat, char * name, insnQualifier qualifier);
qualifiedName make_Qualified_Name (char * name, insnQualifier qualifier);
char * get_Qualifier_String(insnQualifier qualifier);

nameList * append_Name(nameList * list, char * name);
childList * append_Child_Number(childList * list, int num);
stmtList * append_Stmt(stmtList * list, Stmt * stmt);
stmtList * prefix_Stmt(Stmt * stmt, stmtList * list);
opdList * append_Opd(opdList * list, Operand * opd);
rtlSpecList * append_Rtl_Spec(rtlSpecList * list, rtlSpec * rtl_spec);
rtlSpecList * join_Rtl_Spec_List(rtlSpecList * list_1, rtlSpecList * list_2);

void print_pattern_specs(void);
void print_Stmt_List(stmtList * list);
void print_Pat_Category(patCategory cat);
bool print_Lhs(Lhs * lhs);
void print_Rhs(Rhs * rhs);
void print_Operand (Operand * opd);
void print_Name_List (nameList * list);
void print_Rtl_Spec(rtlSpec * rtl_spec);
void print_Rtl_Spec_List (rtlSpecList * list);
void print_Pattern (patternSpec * pattern);

void evaluate_pattern(void);
void generate_conventional_md_specs(void);


extern rtl_tris rtl_tree[];
extern int rtl_oper;
