
%{
#include <stdio.h>
#include<string.h>
#include "srtl-patterns.h"
#include"srtl-parse.tab.h"
#include "srtl-known-names.h"

int line_count=1;
int token(char * name, int code);
int find_Token_of_Name(char * value);
int get_Line_Number(void);
char * cmd_body;

%}

%x in_conventional_md_constructs

ws 			   [ \t ]*
punctuation 		   [!<>;@&?\["}{\.\]),(:=] 	  
first_char_in_names 	   [*a-z_A-Z]
other_chars_in_names 	   [a-z_A-Z0-9]
first_char_in_constraints  ({first_char_in_names}|[ %=<>?!,+]|[0-9])
other_chars_in_constraints ({first_char_in_constraints}|[0-9>&])

%%

"{:"		{ 	
			cmd_body = "";
		  	BEGIN(in_conventional_md_constructs); 
		}

<in_conventional_md_constructs>^":}"	{ 
			BEGIN 0;
				yylval.name = cmd_body;
				return(token("Conventional MD Spec Body", CMD_SPEC_BODY));
	        }

<in_conventional_md_constructs>([^\n]|":"[^}\n])*	{ 
			cmd_body = append_String (cmd_body, yytext);
		}

<in_conventional_md_constructs>\n	{ 
			cmd_body = append_String (cmd_body, "\n");
			line_count++;
		}

concrete	{
			return(token("concrete", CONCRETE));
		}

abstract	{
			return(token("abstract", ABSTRACT));
		}

const_int	{
			return(token("const_int", CONST_INT));
		}

[A-Z]*[0-9]*_REG	{
				yylval.name = strdup(yytext);
				return(token("fixed_reg",FIXED_REG));
							}

define_code_iterator	{
				return(token("define_code_iterator",DEFINE_CODE_ITERATOR));
			}

insn		{
			return(token("insn", INSN));
		}

expand		{
			return(token("expand", EXPAND));
		}

insn_and_split	{
			return(token("insn_and_split",INSN_AND_SPLIT));
		}

split		{
			return(token("split",SPLIT));
		}

peephole2	{
			return(token("peephole2", PEEPHOLE2));
		}

allconstraints 	{
			return(token("allconstraints",ALLCONSTRAINTS));
		}

allpredicates 	{
			return(token("allpredicates",ALLPREDICATES));
		}

overrides 	{
			return(token("overrides", OVERRIDES));
		}

extends 	{
			return(token("extends", EXTENDS));
		}

instantiates	{
			return(token("instantiates", INSTANTIATES));
		}

duplicate 	{
			return(token("duplicate", DUPLICATE));
		}

cmd_spec 	{
			return(token("cmd_spec", CMD_SPEC));
		}


root 		{
			return(token("root", ROOT));
		}

in		{
	 		return(token("in", IN));
		}

out		{
			return(token("out", OUT));
		}

{first_char_in_names}({other_chars_in_names})* {
			yylval.name = strdup(yytext);
			return find_Token_of_Name(yytext);
		}

\"({first_char_in_constraints}{other_chars_in_constraints}*)*\"     {
			yylval.name = strdup(yytext);
			return (token("constraint", CONSTRAINT));
	       	}

->		{
			return(token("->",MODE_MODIFIER));
		}

[0-9]+|-[0-9]+		{
			yylval.number = atoi(yytext);
			return(token ("Number", NUMBER));
		}

{punctuation}	{
			return(token ("punctuation", yytext[0]));
		}

":="		{
		 	return(token ("assign", ASSIGN));
		}

({ws}|"\\\\".*) 		;

\n		{ 
			line_count++;
		}

%%

int token(char * name, int code)
{
#if TEST_SCANNER
	printf ("Found token %s with token code %d and lexeme \"%s\" on line %d\n", name, code, yytext, line_count);
#endif
	return code;
}

int find_Token_of_Name(char * value)
{
	int i;

	i = 0;
	while (i<rtl_oper)
		if(strcmp(value, rtl_tree[i++].name) == 0)
			return(token("rtloperator",RTLOP));
	
#if 0
	i = 0;	
	while (srtl_attr_names[i] != NULL)
		if(strcmp(value, srtl_attr_names[i++]) == 0)
			return(token("attribute",ATTR_NAME));
#endif
	
	i = 0;	
	while (known_predicate_names[i] != NULL)
		if(strcmp(value, known_predicate_names[i++]) == 0)
			return(token("predicate",PREDICATE));
	

	return(token("ID",ID));
}

int get_Line_Number(void)
{
	return line_count;
}

/*
<in_srtl_constructs>('*'?[<>=*%a-z_A-Z][<>=*%a-zA-Z_0-9]+) | 
<in_srtl_constructs>\"('*'?[<>=*?!%a-z_,+A-Z][<>=*!?%a-z,+A-Z_0-9]*)*\"     {
						return find_Toke_of_Name(yytext);
			        		}
*/
