/*-----------------------------------------------------------------
                       Symtab Handler Code                        
                       -------------------                        

      Implemented by : Uday Khedker (www.cse.iitb.ac.in/~uday)
      Copyright      : Uday Khedker

                                                                  
 Operations Supported :                                           

          symEntry * lookup_Symtab(char *name)              
          int GetNumFromSymtab(char *name)               
          void enterNumInSymtab(char *name, int value)   
                                                                  
 Points to be noted                                               
                                                                  
        - Independent testing and integration into the main         
          program without touching the source code after it is      
          compiled and tested.                                      
          
          Run `make symtabTest' for independent testing.

        - Use of program invariants: conditions which must hold at 
          specific program points during every execution of the program.                              

	- Observe an attempt to make the testing verbose and robust.
                                                                    
--------------------------------------------------------------------*/

#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include "srtl-patterns.h"
#include "srtl-support.h"
#include "srtl-symtab.h"


int operand_no=0;




//extern rtl_tris rtl_tree[];



static symEntry * symtab;

char * get_Name_of_Symbol(symEntry * sym_node)
{	check_Invariant (sym_node != NULL, "Attempt to get name from a NULL symEntry node");
	return strdup (sym_node->name);
}

void set_Name_of_Symbol(symEntry * sym_node, char * name)
{	check_Invariant ((sym_node != NULL) && (name != NULL), "Attempt to set either NULL name or name of a NULL symEntry node");
	sym_node->name = name;
}

void set_Pattern_of_Symbol(symEntry * sym_node, patternSpec * pattern)
{	check_Invariant ((sym_node != NULL) && (pattern != NULL), "Attempt to set either NULL pattern or pattern of a NULL symEntry node");
	sym_node->pattern = pattern;
}

patternSpec * get_Pattern_of_Symbol(symEntry * sym_node)
{	check_Invariant (sym_node != NULL, "Attempt to get pattern from a NULL symEntry node");
	return sym_node->pattern;
}

void set_Qualifier_of_Symbol(symEntry * sym_node, insnQualifier qualifier)
{	check_Invariant ((sym_node != NULL), "Attempt to set qualifier of a NULL symEntry node");
	sym_node->qualifier = qualifier;
}

insnQualifier get_Qualifier_of_Symbol(symEntry * sym_node)
{	check_Invariant (sym_node != NULL, "Attempt to get pattern from a NULL symEntry node");
	return sym_node->qualifier;
}


symEntry * get_Next_of_Sym(symEntry * sym_node)
{	check_Invariant (sym_node != NULL, "Attempt to get next pointer from a NULL symEntry node");
	return sym_node->next;
}

void set_Next_of_Sym(symEntry * sym_node, symEntry * next)
{	check_Invariant (sym_node != NULL, "Attempt to set next pointer of a NULL symEntry node");
	sym_node->next = next;
}

symEntry * lookup_Symtab(char * name)
{   	
	symEntry * cur;
	char * sym_name;
	cur = symtab;
    	while (cur != NULL)
    	{    	
		sym_name = get_Name_of_Symbol(cur);
		if (!strcmp(name,sym_name))
        		return cur;
        	else
            		cur = get_Next_of_Sym(cur);
    	}
    	return cur;    
}

symEntry * lookup_Symtab_wqual(char * name,insnQualifier qual)
{   	
	symEntry * cur;
	char * sym_name;
	insnQualifier sym_qual;
	cur = symtab;
    	while (cur != NULL)
    	{    	
		sym_name = get_Name_of_Symbol(cur);
		sym_qual = get_Qualifier_of_Symbol(cur);
		if (!strcmp(name,sym_name)&&(sym_qual==qual))
        		return cur;
        	else
            		cur = get_Next_of_Sym(cur);
    	}
    	return cur;    
}

void print_leaf(tris * root)
{
	switch (root->opd->opd_category)
		{
			case p_m_c_spec:	
				if(strcmp(root->opd->name2,"NULL"))				
				{
					if(root->opd->op_no==-1)				
						root->opd->op_no=operand_no;
					if(!strcmp(root->opd->name1,"NULL"))
						printf("(match_operand:%s %d \"\" %s)",root->opd->name2,root->opd->op_no,root->opd->name3);					
					else
						printf("(match_operand:%s %d \"%s\" %s)",root->opd->name2,root->opd->op_no,root->opd->name1,root->opd->name3);
				}
				else
				{
					if(root->opd->op_no==-1)
						root->opd->op_no=operand_no;
					if(!strcmp(root->opd->name1,"NULL"))
						printf("(match_operand %d \"\" %s)",root->opd->op_no,root->opd->name3);					
					else
						printf("(match_operand %d \"%s\" %s)",root->opd->op_no,root->opd->name1,root->opd->name3);
				}
				operand_no++;
				break;
			case dup_num_spec:
				printf("(match_dup %d)",root->opd->num1);
				break;
			case num_spec:
				printf("(number %d)",root->opd->num1);
				break;
			case reg_spec:
				if (strcmp(root->opd->name1, "reg") == 0)
				{	
					if(root->opd->name2 && strcmp(root->opd->name2,"NULL"))
						printf("(%s:%s %s)",root->opd->name1,root->opd->name2,root->opd->name3);
					else
						printf("(%s %s)",root->opd->name1,root->opd->name3);
				}
				else
				{
					if(root->opd->name2 && strcmp(root->opd->name2,"NULL"))
						printf("(reg:%s %s)",root->opd->name2,root->opd->name1);
					else
						printf("(reg %s)",root->opd->name1);
				}
				break;
			case reg_num_spec:
				if (strcmp(root->opd->name1, "reg") == 0)
				{	
					if(root->opd->name2 && strcmp(root->opd->name2,"NULL"))
						printf("(%s:%s %d)",root->opd->name1,root->opd->name2,root->opd->num1);
					else
						printf("(%s %d)",root->opd->name1,root->opd->num1);
				}
				break;
			case extra_reg_spec:
					printf("(%s)",root->opd->name1);
					break;
			case const_spec:
				if (root->opd->name2 == NULL)
					{
					printf("(const_int %d)",root->opd->num1);
					}
				else
					{
					printf("(const_spec:%s %d %s)",root->opd->name1,root->opd->num1,root->opd->name2);	
					}
				break;
			case scratch_spec:
				if(strcmp(root->opd->name2,"NULL"))					
				{	
					if(root->opd->op_no==-1)
						root->opd->op_no=operand_no;
					printf("(match_scratch:%s %d %s)",root->opd->name1,root->opd->op_no,root->opd->name2);
				}
				else
				{	
					if(root->opd->op_no==-1)
						root->opd->op_no=operand_no;
					printf("(match_scratch %d %s)",root->opd->op_no,root->opd->name2);
				}
				operand_no++;
				break;
			default: report_Internal_Error("Wrong operand category");
				break;
		}	
	
}



void  print_pattern_tree(tris * root)
{	

	//printf("duplicate%d",root->children[0]->children[0]->opd->opd_category);
	//return;
	if(root==NULL)
		return;
	
	if(!strcmp(root->name,"leaf"))
	{	//printf("dup_no%d",root->opd->num1);
		print_leaf(root);
		return;
	}	
	else
	{	
		if(strcmp(root->name,"sequence"))
			if(root->mode && strcmp(root->mode,"NULL"))
				printf("(%s:%s",root->name,root->mode);
			else
				printf("(%s",root->name);			
	}
	int x=0;
	if(!strcmp(root->name,"unspec")||!strcmp(root->name,"parallel")||!strcmp(root->name,"unspec_volatile"))
		printf("[");
	if(!strcmp(root->name,"match_op_dup"))
		printf(" %d [",root->mop_no);
	if(!strcmp(root->name,"match_operator"))
		{
			if(root->mop_no==-1)
			{
				root->mop_no=operand_no;
				operand_no++;
			}
			printf(" %d \"%s\" [",root->mop_no,root->cons_string);
		}			
	while(x<root->no_of_children)
	{	
		if(root->children[x])
		{
			print_pattern_tree(root->children[x]);
		}
		x=x+1;
	}
	if(!strcmp(root->name,"unspec")||!strcmp(root->name,"unspec_volatile"))
		printf(" ]%s",root->cons_string);
	
	if(!strcmp(root->name,"parallel")||!strcmp(root->name,"match_operator")||!strcmp(root->name,"match_op_dup"))
		printf("]");
	if(!strcmp(root->name,"subreg"))
		printf(" %d",root->cons_number);
	if(strcmp(root->name,"sequence"))	
		printf(")");
} 



tris * copy_rtl_tree(tris * new_tree, rtl_tris *exist_tree)
{
	new_tree = (tris*)malloc(sizeof(tris));
	new_tree->name=strdup(exist_tree->name);
	new_tree->no_of_children=exist_tree->no_of_children;
	new_tree->constraint_flag=0;
	new_tree->predicate_flag=0;
	//new_tree->mode=strdup("none");
	new_tree->children=(tris *)malloc(exist_tree->no_of_children*sizeof(tris));
	return new_tree;
}



void * copy_tree(tris * new_tree , tris * exist_tree,int y)
{	
	new_tree->name=strdup(exist_tree->name);
	new_tree->no_of_children=exist_tree->no_of_children;
	new_tree->constraint_flag=0;
	new_tree->predicate_flag=0;
	if(exist_tree->mode)
		new_tree->mode=strdup(exist_tree->mode);
	new_tree->mop_no=exist_tree->mop_no;
	if(exist_tree->cons_string)
		new_tree->cons_string=exist_tree->cons_string;
	new_tree->cons_number=exist_tree->cons_number;
	if(exist_tree->opd)
	{	
		new_tree->opd = (Operand*)malloc(sizeof(Operand));
		new_tree->opd->opd_category=exist_tree->opd->opd_category;
		switch (exist_tree->opd->opd_category)
		{
			case p_m_c_spec:	
				new_tree->opd->name1=strdup(exist_tree->opd->name1);
				new_tree->opd->name2=strdup(exist_tree->opd->name2);
				new_tree->opd->name3=strdup(exist_tree->opd->name3);
				new_tree->opd->op_no=exist_tree->opd->op_no;
				break;
			case dup_num_spec:
				new_tree->opd->num1=exist_tree->opd->num1;
				break;
			case num_spec:
				new_tree->opd->num1=exist_tree->opd->num1;
				break;
			case reg_spec:
				if (strcmp(exist_tree->opd->name1, "reg") == 0)
					{
						new_tree->opd->name1=strdup(exist_tree->opd->name1);
						new_tree->opd->name2=strdup(exist_tree->opd->name2);
						new_tree->opd->name3=strdup(exist_tree->opd->name3);
					}
				else
					new_tree->opd->name1=strdup(exist_tree->opd->name1);
				break;
			case extra_reg_spec:
				new_tree->opd->name1=strdup(exist_tree->opd->name1);
				break;
			case reg_num_spec:
				if (strcmp(exist_tree->opd->name1, "reg") == 0)
					{
						new_tree->opd->name1=strdup(exist_tree->opd->name1);
						new_tree->opd->name2=strdup(exist_tree->opd->name2);
						new_tree->opd->num1=exist_tree->opd->num1;
					}
				break;
			case const_spec:
				if (exist_tree->opd->name2 == NULL)
					{
						new_tree->opd->name1=strdup(exist_tree->opd->name1);
						new_tree->opd->num1=exist_tree->opd->num1;
					}
				else
					{
						new_tree->opd->name1=strdup(exist_tree->opd->name1);
						new_tree->opd->num1=exist_tree->opd->num1;
						new_tree->opd->name2=strdup(exist_tree->opd->name2);
					}
				break;
			case scratch_spec:
				new_tree->opd->name1=strdup(exist_tree->opd->name1);
				new_tree->opd->name2=strdup(exist_tree->opd->name2);
				new_tree->opd->op_no=exist_tree->opd->op_no;
				break;
			default: report_Internal_Error("Wrong operand category");
				break;
		}	
	}	
	if(!strcmp(new_tree->name,"leaf")) return;
	new_tree->children=(tris *)malloc(exist_tree->no_of_children*sizeof(tris));
	int x=0;
	while(x<exist_tree->no_of_children)
	{	if(exist_tree->children[x])
		{
			new_tree->children[x]=(tris *)malloc(sizeof(tris));
			copy_tree(new_tree->children[x],exist_tree->children[x],y);
		}
		x=x+1;
	}
	return;
}

int fl=0;

tris * instan_tree(tris * root,Operand * opd,char *patternname)
{	
	if(root!=NULL)
	{	
		int x=0;
		while(x<root->no_of_children)
		{	
			root->children[x]=instan_tree(root->children[x],opd,patternname);
			if(fl==2)
			{	
				root->no_of_children=x;
				root->mop_no=opd->op_no;
				if(!strcmp(root->name,"subreg"))
					root->cons_number=opd->num1;
				else if((!strcmp(root->name,"unspec"))||
					(!strcmp(root->name,"match_operator"))||(!strcmp(root->name,"unspec_volatile")))
					{	
						if(!opd->name1)
						{
							report_Internal_Error_new("cons_string_not_Specified",patternname);
							return;
						}
						root->cons_string=strdup(opd->name1);
					}
				fl=1;
			}
			if(fl==1)
				return root;	
			x=x+1;
		}
	}
	else
	{		
		if(opd->opd_category==7)
			{fl=2;return NULL;}
		if(opd->opd_category==6)
			{fl=1;return NULL;}
		root = (tris*)malloc(sizeof(tris));
		root->name=strdup("leaf");
		root->no_of_children=0;
		root->opd = (Operand*)malloc(sizeof(Operand));
		root->opd->opd_category=opd->opd_category;
		root->opd->op_no=opd->op_no;
		root->constraint_flag=0;
		root->predicate_flag=0;
		switch (opd->opd_category)
		{	
			case p_m_c_spec:	
				root->opd->name1=strdup(opd->name1);
				root->opd->name2=strdup(opd->name2);
				root->opd->name3=strdup(opd->name3);
				break;
			case dup_num_spec:
				root->opd->num1=opd->num1;
				break;
			case num_spec:
				root->opd->num1=opd->num1;
				break;
			case reg_spec:
				if (strcmp(opd->name1, "reg") == 0)
					{
						root->opd->name1=strdup(opd->name1);
						root->opd->name2=strdup(opd->name2);
						root->opd->name3=strdup(opd->name3);
					}
				else
					root->opd->name1=strdup(opd->name1);
				break;
			case reg_num_spec:
				if (strcmp(opd->name1, "reg") == 0)
					{
						root->opd->name1=strdup(opd->name1);
						root->opd->name2=strdup(opd->name2);
						root->opd->num1=opd->num1;
					}
				break;
			case extra_reg_spec:
				root->opd->name1=strdup(opd->name1);
				break;
			case const_spec:
				if (opd->name2 == NULL)
					{
						root->opd->name1=strdup(opd->name1);
						root->opd->num1=opd->num1;
					}
				else
					{
						root->opd->name1=strdup(opd->name1);
						root->opd->num1=opd->num1;
						root->opd->name2=strdup(opd->name2);
					}
				break;
			case scratch_spec:
				root->opd->name1=strdup(opd->name1);
				root->opd->name2=strdup(opd->name2);
				break;
			default: report_Internal_Error("Wrong operand category");
				break;
		}
		fl=1;
	}
	return root;		
}

tris * print_tree(tris * root)
{
	if(root)
	{	printf("%s",root->name);	
		int x=0;
		while(x<root->no_of_children)
		{	
			print_tree(root->children[x]);	
			x=x+1;
		}
	}
	return NULL;
}


tris * modify_tree(tris * new_tree,Stmt *stmt,char * patternname)
{	symEntry * pattern;
	Lhs * lhs=stmt->lhs;
	childList * node_access=lhs->child_list;
	tris *temp=new_tree;
	while(node_access->next!=NULL)
		{
		if(!new_tree->children[node_access->child_number-1])
			{
				
				report_Internal_Error_new("wrong tree access in abstract pattern having pattern name",patternname);
				return;
			}
		new_tree=new_tree->children[node_access->child_number-1];
		node_access=node_access->next;
		}		
	tris * extend,*rhs_tree;
	Rhs * rhs =stmt->rhs;
        char * name=rhs->name;
	
 	int i,flag=0;
	i = 0;
	while (i<rtl_oper)
		if(strcmp(name, rtl_tree[i++].name) == 0)
		{
			flag=1;
			break;
		}
	if(!flag)
	{	
     		pattern = lookup_Symtab(name);
		rhs_tree=pattern->pattern->rtl_spec_list_in->rtl_spec->tree_struct;
		if (rhs_tree != NULL)
   		{	
			extend=(tris *)malloc(sizeof(tris));
			copy_tree(extend,rhs_tree,1);
			new_tree->children[node_access->child_number-1]=extend;
		}
		
	}
	else
	{	
		extend=copy_rtl_tree(extend,&rtl_tree[i-1]);
		new_tree->children[node_access->child_number-1]=extend;
	}
	return temp;				
}




tris * const_pred_tree(tris * root,char * name,int i)
{	
   	if(!strcmp(root->name,"leaf"))
	{
		if(root->opd->opd_category==0 && (root->constraint_flag!=1) && (i==1)&&fl!=1)
		{
			root->opd->name3=strdup(name);
			root->constraint_flag=1;
			fl=1;
		}
		else if(root->opd->opd_category==0 && (root->predicate_flag!=1) && (i==0)&&fl!=1)
		{
			root->opd->name1=strdup(name);
			root->predicate_flag=1;
			fl=1;
		}
		
		
	}
	int x=0;
	while(x<root->no_of_children)
	{	
		if(root->children[x])
		{
			const_pred_tree(root->children[x],name,i);
		}
		x=x+1;
	} 

}

void mode_replace(tris *root,char * lhs,char * rhs)
{
	
	if(!strcmp(root->name,"leaf"))
	{
		if(root->opd->name2 && !strcmp(root->opd->name2,lhs))
			root->opd->name2=strdup(rhs);
	}
	else
	{
		if(root->mode && !strcmp(root->mode,lhs))
			root->mode=strdup(rhs);
	}
	int x=0;
	while(x<root->no_of_children)
	{	
		if(root->children[x])
		{
			mode_replace(root->children[x],lhs,rhs);
		}
		x=x+1;
	}
}


tris * single_tree(tris * new_tree,Stmt *stmt,int k,char * patternname)
{                symEntry * pattern;
                Lhs * lhs=stmt->lhs;
                childList * node_access;
                tris *temp=new_tree; 	 	
		if((stmt->lhs->lhs_type==3)&&(stmt->stmt_type==3))
		{
			mode_replace(new_tree,stmt->lhs->name,stmt->rhs->name);	
			return new_tree;
		}
		else
			node_access=lhs->child_list;
		
                while(node_access!=NULL)
                {	
			if(!new_tree->children[node_access->child_number-1])
			{
				report_Internal_Error_new("wrong tree access in concrete pattern having pattern name",patternname);
				return;
			}
                        new_tree=new_tree->children[node_access->child_number-1];
                        node_access=node_access->next;
                }
		

                if(!strcmp(new_tree->name,"leaf"))
		{
			if(k==1 && stmt->rhs->name)
				new_tree->opd->name2=strdup(stmt->rhs->name);
               		else if(k==0 && stmt->rhs->name)
               		        new_tree->opd->name1=strdup(stmt->rhs->name);
                	else if(k==2 && stmt->rhs->name)
                        	new_tree->opd->name3=strdup(stmt->rhs->name);
		}
		else
		{
			if(k==1 && stmt->rhs->name)
				new_tree->mode=strdup(stmt->rhs->name);
			if(k==4 && stmt->rhs->name)
				new_tree->cons_string = strdup(stmt->rhs->name);
        	}
}



tris * single_opr(tris * new_tree,Stmt *stmt,char * patternname)
        {       symEntry * pattern;
                Lhs * lhs=stmt->lhs;
                childList * node_access=lhs->child_list;
                tris *temp=new_tree;
                while(node_access->next!=NULL)
                {
			if(!new_tree->children[node_access->child_number-1])
			{
				report_Internal_Error_new("wrong tree access in concrete pattern single operand setting having pattern name",patternname);
				return;
			}
                        new_tree=new_tree->children[node_access->child_number-1];
                        node_access=node_access->next;
                }

               	new_tree->children[node_access->child_number-1]->opd->opd_category=stmt->rhs->opd->opd_category;
		if(stmt->rhs->opd->name1)
			new_tree->children[node_access->child_number-1]->opd->name1=strdup(stmt->rhs->opd->name1);
		if(stmt->rhs->opd->name2)
			new_tree->children[node_access->child_number-1]->opd->name2=strdup(stmt->rhs->opd->name2);
		if(stmt->rhs->opd->name3)		
			new_tree->children[node_access->child_number-1]->opd->name3=strdup(stmt->rhs->opd->name3);
		new_tree->children[node_access->child_number-1]->opd->num1=stmt->rhs->opd->num1;
		new_tree->children[node_access->child_number-1]->opd->num2=stmt->rhs->opd->num2;
        }



tris * create_tree_structure(patternSpec * pattern)
{
	Stmt *stmt;tris *temp;
	stmtList *stmt_list;
	symEntry * prev;
	rtlSpecList * pattern_lst_in;
	rtlSpecList * pattern_lst_out;
	rtlSpec * pat;
	char * ex_name;	
	insnQualifier qual;
	pattern_lst_in=pattern->rtl_spec_list_in;
	pattern_lst_out=pattern->rtl_spec_list_out;	 
	while(pattern_lst_in!=NULL)
	{
		pat=pattern_lst_in->rtl_spec;   
		ex_name=pat->name;  
		qual=pat->qualifier;
		if(pat->refinement==3)
		{pattern_lst_in=pattern_lst_in->next;continue;}
		int i=0,flag=0;
		while (i<rtl_oper)
			if(strcmp(ex_name, rtl_tree[i++].name) == 0)
			{
				if(qual==0)
					flag=1;
				break;
			}
		if(!flag)
		{	
			if(qual==0)
				prev = lookup_Symtab(ex_name);
			else	
				prev = lookup_Symtab_wqual(ex_name,qual);
			if (prev != NULL)
		    	{	
				temp=(tris *)malloc(sizeof(tris));
				copy_tree(temp,prev->pattern->rtl_spec_list_in->rtl_spec->tree_struct,1);
			}
		
		}
		else
		{
		
			temp=copy_rtl_tree(temp,&rtl_tree[i-1]);
		}
		stmt_list=pat->stmt_list;		
		while(stmt_list!=NULL)
		{	
			stmt=stmt_list->stmt;
			opdList *opdlst=stmt->rhs->opd_list;
			nameList *namelst=stmt->rhs->name_list;
			switch(stmt->rhs->rhs_category)
			{
				case instantiation:
					while(opdlst)
					{
						fl=0;	
						instan_tree(temp,opdlst->opd,pattern->name);
						opdlst=opdlst->next;
					}
					break;
				case abstract_pattern:
				case rtl_operator:
					temp=modify_tree(temp,stmt,pattern->name);
					break;
				case constraint_list:
					while(namelst)
					{
						fl=0;
						const_pred_tree(temp,namelst->name,1);
						namelst=namelst->next;
					}
					break;
				case predicate_list:
					while(namelst)
					{
						fl=0;
						const_pred_tree(temp,namelst->name,0);
						namelst=namelst->next;
					}
					break;
				case single_predicate:
					if(stmt->lhs->lhs_type==4)
						single_tree(temp,stmt,1,pattern->name);
					else
						single_tree(temp,stmt,0,pattern->name);	
					break;
				case single_mode:
					if(stmt->lhs->lhs_type==4)
						single_tree(temp,stmt,1,pattern->name);
					else
						single_tree(temp,stmt,0,pattern->name);	
					break;
				case single_constraint:
					single_tree(temp,stmt,2,pattern->name);
					break;
				case single_operand:
					single_opr(temp,stmt,pattern->name);
				case const_unspec:
					single_tree(temp,stmt,4,pattern->name);
					break;
			}			
			stmt_list=stmt_list->next;
		}
		
		pat->tree_struct=temp;
		pattern_lst_in=pattern_lst_in->next;
	}
	while(pattern_lst_out!=NULL)
	{
		pat=pattern_lst_out->rtl_spec;   
		ex_name=pat->name;  
		qual=pat->qualifier;
		int i=0,flag=0;
		if(pat->refinement==3)
		{pattern_lst_out=pattern_lst_out->next;continue;}
		while (i<rtl_oper)
			if(strcmp(ex_name, rtl_tree[i++].name) == 0)
			{
				if(qual==0)	
					flag=1;
				break;
			}
		if(!flag)
		{	
			if(qual==0)
				prev = lookup_Symtab(ex_name);
			else	
				prev = lookup_Symtab_wqual(ex_name,qual);
			if (prev != NULL)
		    	{	
				temp=(tris *)malloc(sizeof(tris));
				copy_tree(temp,prev->pattern->rtl_spec_list_in->rtl_spec->tree_struct,1);
			}
		
		}
		else
		{
		
			temp=copy_rtl_tree(temp,&rtl_tree[i-1]);
		}
	
		stmt_list=pat->stmt_list;		
		while(stmt_list!=NULL)
		{
			stmt=stmt_list->stmt;
			opdList *opdlst=stmt->rhs->opd_list;
			nameList *namelst=stmt->rhs->name_list;
			switch(stmt->rhs->rhs_category)
			{
				case instantiation:
					while(opdlst)
					{
						fl=0;
						instan_tree(temp,opdlst->opd,pattern->name);
						
						opdlst=opdlst->next;
					}
					break;
				case abstract_pattern:
				case rtl_operator:
					temp=modify_tree(temp,stmt,pattern->name);
					break;
				case constraint_list:
					while(namelst)
					{
						fl=0;
						const_pred_tree(temp,namelst->name,1);
						namelst=namelst->next;
					}
					break;
				case predicate_list:
					while(namelst)
					{
						fl=0;
						const_pred_tree(temp,namelst->name,0);
						namelst=namelst->next;
					}
					break;
				case single_predicate:
					if(stmt->lhs->lhs_type==4)
						single_tree(temp,stmt,1,pattern->name);
					else
						single_tree(temp,stmt,0,pattern->name);	
					break;
				case single_mode:
					if(stmt->lhs->lhs_type==4)
						single_tree(temp,stmt,1,pattern->name);
					else
						single_tree(temp,stmt,0,pattern->name);	
					break;
				case single_constraint:
					single_tree(temp,stmt,2,pattern->name);
					break;
				case single_operand:
					single_opr(temp,stmt,pattern->name);
					break;
			}			
			stmt_list=stmt_list->next;
		}
	
	pat->tree_struct=temp;
	pattern_lst_out=pattern_lst_out->next;
	}
}		
	

symEntry * enter_Pattern_in_Symtab(patternSpec * pattern)
{   symEntry * temp;
    symEntry * prev;
    insnQualifier qualifier, temp_qualifier;
    bool found = false;
    
    char * name;

    name = pattern->name;
    qualifier = pattern->qualifier;

    /*temp = lookup_Symtab(name);

    if (temp != NULL)
    {
    	temp_qualifier = get_Qualifier_of_Symbol(temp);
	if (qualifier == temp_qualifier)
		found = true;
    } */

    if (!found)
    {  	
	prev = symtab;
 
	temp = (symEntry *) malloc(sizeof(symEntry));
        check_Invariant ((temp != NULL),
            	"Can't allocate memory for symbol");
        set_Name_of_Symbol(temp, strdup(name));
	set_Pattern_of_Symbol(temp, pattern);
	create_tree_structure(pattern);
	rtlSpecList * rtlspeclist_in,*rtlspeclist_out;
	rtlspeclist_in=temp->pattern->rtl_spec_list_in;
	rtlspeclist_out=temp->pattern->rtl_spec_list_out;
	
	if(temp->pattern->pat_type==1)
	{	if(temp->pattern->qualifier==1)
		{	printf("\n(define_insn \"%s\"\n[",temp->name);
			while(rtlspeclist_in!=NULL)
			{	operand_no=0;
				if(rtlspeclist_in->rtl_spec->tree_struct)
					print_pattern_tree(rtlspeclist_in->rtl_spec->tree_struct);
				if(rtlspeclist_in->rtl_spec->cmd_body)
					printf("]%s",rtlspeclist_in->rtl_spec->cmd_body);
				printf(")");
				rtlspeclist_in=rtlspeclist_in->next;
			}
			printf("\n\n\n\n");	
		}
		else if(temp->pattern->qualifier==2)
		{	printf("\n(define_expand \"%s\"\n[",temp->name);
			while(rtlspeclist_in!=NULL)
			{	operand_no=0;
				if(rtlspeclist_in->rtl_spec->tree_struct)
					print_pattern_tree(rtlspeclist_in->rtl_spec->tree_struct);
				if(rtlspeclist_in->rtl_spec->cmd_body)
					printf("]%s",rtlspeclist_in->rtl_spec->cmd_body);
				printf(")");
				rtlspeclist_in=rtlspeclist_in->next;
			}
			printf("\n\n\n\n");	
		}
		else if(temp->pattern->qualifier==3)
		{	printf("\n(define_peephole2 \n[");
			int flag1=5;
			while(rtlspeclist_in!=NULL)
			{
				operand_no=0;
				if(rtlspeclist_in->rtl_spec->tree_struct)
				{	if(flag1==1)
						printf("[");
					flag1=0;
					print_pattern_tree(rtlspeclist_in->rtl_spec->tree_struct);
				}	
				if(rtlspeclist_in->rtl_spec->cmd_body)	
				{
					if(flag1==0)
						printf("]%s",rtlspeclist_in->rtl_spec->cmd_body);
					else
						printf("%s",rtlspeclist_in->rtl_spec->cmd_body);
					flag1=1;
				}
				rtlspeclist_in=rtlspeclist_in->next;
			}	
			if(flag1!=1)
				printf("]");
			while(rtlspeclist_out!=NULL)
			{
				operand_no=0;
				if(rtlspeclist_out->rtl_spec->tree_struct)
				{	if(flag1==1)
						printf("[");
					flag1=0;
					print_pattern_tree(rtlspeclist_out->rtl_spec->tree_struct);
				}	
				if(rtlspeclist_out->rtl_spec->cmd_body)	
				{
					if(flag1==0)
						printf("]%s",rtlspeclist_out->rtl_spec->cmd_body);
					else
						printf("%s",rtlspeclist_out->rtl_spec->cmd_body);
					flag1=1;
				}
				rtlspeclist_out=rtlspeclist_out->next;
			}
			if(flag1!=1)
				printf("]");	
			printf(")");
		}
		else if(temp->pattern->qualifier==4)
		{	printf("\n(define_split \n[");
			int flag1=5;
			while(rtlspeclist_in!=NULL)
			{
				operand_no=0;
				if(rtlspeclist_in->rtl_spec->tree_struct)
				{	if(flag1==1)
						printf("[");
					flag1=0;
					print_pattern_tree(rtlspeclist_in->rtl_spec->tree_struct);
				}	
				if(rtlspeclist_in->rtl_spec->cmd_body)	
				{
					if(flag1==0)
						printf("]%s",rtlspeclist_in->rtl_spec->cmd_body);
					else
						printf("%s",rtlspeclist_in->rtl_spec->cmd_body);
					flag1=1;
				}
				rtlspeclist_in=rtlspeclist_in->next;
			}	
			while(rtlspeclist_out!=NULL)
			{
				operand_no=0;
				if(rtlspeclist_out->rtl_spec->tree_struct)
				{	if(flag1==1)
						printf("[");
					flag1=0;
					print_pattern_tree(rtlspeclist_out->rtl_spec->tree_struct);
				}	
				if(rtlspeclist_out->rtl_spec->cmd_body)	
				{
					if(flag1==0)
						printf("]%s",rtlspeclist_out->rtl_spec->cmd_body);
					else
						printf("%s",rtlspeclist_out->rtl_spec->cmd_body);
					flag1=1;
				}
				rtlspeclist_out=rtlspeclist_out->next;
			}	
			if(flag1!=1)
				printf("]");	
			printf(")");	

		}
		else if(temp->pattern->qualifier==5)
		{	printf("\n(define_insn_and_split\"%s\"\n[",temp->name);
			int flag1=5;
			while(rtlspeclist_in!=NULL)
			{
				operand_no=0;
				if(rtlspeclist_in->rtl_spec->tree_struct)
				{	if(flag1==1)
						printf("[");
					flag1=0;
					print_pattern_tree(rtlspeclist_in->rtl_spec->tree_struct);
				}	
				if(rtlspeclist_in->rtl_spec->cmd_body)	
				{
					if(flag1==0)
						printf("]%s",rtlspeclist_in->rtl_spec->cmd_body);
					else
						printf("%s",rtlspeclist_in->rtl_spec->cmd_body);
					flag1=1;
				}
				rtlspeclist_in=rtlspeclist_in->next;
			}	
			while(rtlspeclist_out!=NULL)
			{
				operand_no=0;
				if(rtlspeclist_out->rtl_spec->tree_struct)
				{	if(flag1==1)
						printf("[");
					flag1=0;
					print_pattern_tree(rtlspeclist_out->rtl_spec->tree_struct);
				}	
				if(rtlspeclist_out->rtl_spec->cmd_body)	
				{
					if(flag1==0)
						printf("]%s",rtlspeclist_out->rtl_spec->cmd_body);
					else
						printf("%s",rtlspeclist_out->rtl_spec->cmd_body);
					flag1=1;
				}
				rtlspeclist_out=rtlspeclist_out->next;
			}	
			if(flag1!=1)
				printf("]");	
			printf(")");	

		}
	}		

	set_Qualifier_of_Symbol(temp, qualifier);
        set_Next_of_Sym(temp, prev);	/* symbols are added at the start */
	symtab = temp;
    	check_Invariant (temp != NULL, "Symtab can't be empty after inserting a name");
    }
    return temp;
}

#if SYMTABTEST  /*********************** Code for Testing *******/

#define SETVAL 1
#define GETVAL 2
#define EXIT 3

bool is_Valid_Name( char * name)
{	if (name != NULL)
		return (isalpha(name[0]));
	else 
		return false;
}
	
main(void)
{    
    char name[10];     /* fixing length only for testing */
    int  value ;    /* fixing type only for testing */
    int choice;
    char junk_buffer[100];

    while (1)
    {   char * temp_name;

        printf ("**************************** Enter name\n\t"); 
        scanf  ("%s",name);
    	if (!is_Valid_Name(name))
		report_Internal_Error("Not a valid name");
        printf ("Read name is %s \n",name); 

        printf ("\t \t %d for entering value\n", SETVAL);
        printf ("\t \t %d for retrieving value\n", GETVAL);
        printf ("\t \t %d for exiting\n", EXIT);

        if (scanf ("%d", &choice))  /* found input matching %d */
        {   printf ("Your option is %d\n",choice);
            switch (choice)
            {  case SETVAL : printf("Enter Num\n");
                              scanf ("%d", &value);
                              EnterNumInSymtab(name,value);
                              break;
                case GETVAL : if (lookup_Symtab(name))
                              {    value =  GetNumFromSymtab(name);
                                   printf ("Num of %s is %d\n",name,value);
                              }
                              else
                                   printf ("Name %s has not been entered\n",name);
                              break;
                case EXIT  :  exit(0);
                              break;
                default    :  fprintf (stderr, "Invalid Option\n");
                              break;
    
            }
        }
        else                     /* read junk to discard the entire line */
        {   fprintf (stderr, "Invalid Option\n");
            fgets (junk_buffer,100,stdin); 
        }
    }
}
                             
#endif  /******************* End of code for testing  *********************/


