/*--------------------------------------------------------------------

      Implemented by : Uday Khedker (www.cse.iitb.ac.in/~uday)
      Copyright      : Uday Khedker

---------------------------------------------------------------------*/

#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <execinfo.h>
#include <stdlib.h>
#include "srtl-patterns.h"

char * get_Caller_Function_Name(char * full_name);
void check_Invariant(bool invariant, char * msg);

void report_Input_Error(char * msg)
{    
	fprintf (stderr, "Error on line %d: %s\n", get_Line_Number(),msg);
	exit (1);
}

void * safe_Malloc(int size)
{	
	void * ptr;

	ptr = (void *) malloc(size);
	check_Invariant((ptr != (void *) NULL),
			"Dynamic memory allocation failed");
	return ptr;
}

char * append_String(char * str_1, char * str_2)
{	
	char * temp;

	temp = (char *) safe_Malloc (strlen(str_1) + strlen(str_2) + 10);

	//temp = strncpy(temp,str_1,50);
	//temp = strcat(temp,str_2);
	sprintf (temp, "%s%s", str_1, str_2);

	return temp;
}

void check_Invariant(bool invariant, char * msg)
{
  	void *array[10];
  	size_t size;
  	char **strings;
  	char * caller;
	
  	if (! invariant)
  	{	
  		size = backtrace (array, 100);
  		strings = backtrace_symbols (array, size);

#if TEST_BACKTRACE
  	size_t i;
	for (i = 0; i < size; i++)
		printf("backtrace symbol %d is %s\n",i,strings[i]);
#endif
	
  		caller = get_Caller_Function_Name(strings[1]);
		
  		fprintf (stderr, "Internal error: %s in function \"%s\"\n",msg,caller);
		exit(1);
  	}
}

void report_Internal_Error(char * msg)
{
  	void *array[10];
  	size_t size;
  	char **strings;
  	char * caller;
	
  	size = backtrace (array, 100);
  	strings = backtrace_symbols (array, size);

#if TEST_BACKTRACE
  	size_t i;
	for (i = 0; i < size; i++)
		printf("backtrace symbol %d is %s\n",i,strings[i]);
#endif
	
  	caller = get_Caller_Function_Name(strings[1]);
		
  	fprintf (stderr, "Internal error: %s in function \"%s\"\n",msg,caller);
  	exit(1);	
}

char * get_Caller_Function_Name(char * full_name)
{
	int i, j, n;
	char * name;
	bool start;

	n = strlen(full_name+10);

	name = (char *) safe_Malloc(n);

	start = false;
	j = 0;
	
	for (i = 0; i <= n; i++)
	{	
		if (full_name[i] == '(')
			start = true;
		else if (start)
		{ 	
			if (full_name[i] == '+')
			{ 	
				name[j] = '\0';
				return name;
			}	
			else
				name[j++] = full_name[i];
		}
		else
			; /* ignore */
	}
  	fprintf (stderr, "Reached the end of getCallerFunction name for name %s \n",full_name);
  	exit (1);
}

char * strip_Directory_Names(char * source)
{
	char * dest;

	int di, si;

	dest = (char *) safe_Malloc(strlen(source)+1);

	for (di=si=0; source[si] != '\0'; si++)
	{
		if (source[si] == '/')
			di = 0;
		else
			dest[di++] = source[si];
	}
	dest[di] = '\0';
	return dest;
}

#define MAXLEN 100


char * itoa(int num)
{
	int base = 10;
        int lastpos;
        char digit;
        char  str [MAXLEN];

        lastpos = MAXLEN - 1;

        str[lastpos] = '\0';

        while (num > 0)
        {
                lastpos = lastpos - 1;
                digit = num % base;
                if ((base > 10) && (digit > 9))
                        digit = digit - 10 + 'a';
                else    digit = digit + '0';
                str[lastpos] = digit;
                num = num/base;
        }

        return strdup(&str[lastpos]);
}

	
