/* What this must do --
   Scan PPT_Sched and send mail to T&P staff to book venue
   Scan Round_Sched and <same as above>
   Scan Offer_Letter and check for people who have not replied. Take action:
        Email them, and tell them their jobs are gone!
	Set yesno to N
*/

/* Later, use a config file containing: 
   Username of T&P staff
   Password of T&P staff
   Email Address of T&P staff
   Currently, these are HARDCODED
*/

import DatabaseConnection;
import Mailer;
import java.sql.*;

public class MainDaemon {
  /*  public MainDaemon() {}*/
  public static void VenueBooking_Rem (DatabaseConnection db) {
      String qry;
      ResultSet rs;

      qry =" select Company.company_name, to_char(PPT_Sched.PPT_Time, 'DD-MM-YYYY HH24:MI:SS'), PPT_Venue from PPT_Sched, Company where ((PPT_Time - SYSDATE) < 7) and ((PPT_Time - SYSDATE) >= 0) and PPT_Sched.company_id = Company.company_id";

      try {
	rs = db.query (qry);
      }
      catch (SQLException e) {
        System.out.println ("Ouch! Query not done!" + e);
	System.out.flush();
        return;
      }
      PPT_Round_Mailer (rs);

      qry =" select Company.company_name, to_char(Round_Sched.Round_Time, 'DD-MM-YYYY HH24:MI:SS'), Round_Venue from Round_Sched, Company where ((Round_Time - SYSDATE) < 7) and Round_Sched.company_id = Company.company_id";

      try {
	rs = db.query (qry);
      }
      catch (SQLException e) {
        System.out.println ("Ouch! Query not done!" + e);
	System.out.flush();
        return;
      }
      PPT_Round_Mailer (rs);
  }

  public static void PPT_Round_Mailer (ResultSet rs) {
    String venue, time, comp_name;
    
      try {
	while (rs.next()) {
	  comp_name = rs.getString(1);
	  venue = rs.getString (3);
	  time = rs.getString (2);
	  try {
	    Mailer.mail ("hrishi@cse.iitb.ernet.in", "Subject: Arrange venue for Selection Round/PPT \n\n Company = " + comp_name + "\n Venue = " + venue + "\n Date/Time = " + time + "\n\n");
	  }
	  catch (java.io.IOException e) {
	    System.out.println ("Mailer gotcha: "+ e);
	    return;
	  }
	}
      }
      catch (SQLException e) {
	System.out.println ("Worst Pain!" + e);
	return;
      }
  }

  public static void Offer_Accepting (DatabaseConnection db) {
    String qry, s_id, s_email, comp_id, comp_name, last_date;
    String upd;
    ResultSet rs;

    qry = "select Student.student_id, email, Offer_Letter.company_id, company_name, to_char (last_date, 'DD-MM-YYYY HH24:MI:SS') from Offer_Letter, Company, Student where (last_date - SYSDATE) < 0 and (yesno is Null) and (Offer_Letter.company_id = Company.company_id) and (Student.student_id = Offer_Letter.student_id)";
    
    try {
        rs = db.query (qry);
    }
    catch (SQLException e) {
        System.out.println ("Ouch! Offer_Letter Query not done!" + e);
        System.out.flush();
        return;
    }
    try {
      while (rs.next()) {
	s_id = rs.getString(1);
	s_email = rs.getString(2);
	comp_id = rs.getString (3);
	comp_name = rs.getString (4);
	last_date = rs.getString (5);
	System.out.println (s_id + s_email + comp_id + comp_name + last_date);
	System.out.flush();
	try {
	  Mailer.mail (s_email, "Subject: Alas! Your job is no more! \n\n Since you did not reply to " + comp_name + "'s offer \n by their last date = " + last_date + " YOUR JOB HAS BEEN HEREBY KHATCHED!\n\n");
	}
	catch (java.io.IOException e) {
	  System.out.println ("Mailer gotcha: "+ e);
	  return;
	  }

	upd = "update Offer_Letter set yesno = 'N' where ((student_id = '" + s_id + "') and (company_id = '" + comp_id + "'))";
	try {
	  int i = db.update (upd);
	}
	catch (SQLException e) {
	  System.out.println ("Ouch! Offer_Letter Update not done!" + e);
	  System.out.flush();
	  return;
	}
      }
    }
    catch (SQLException e) {
      System.out.println ("Offer_Letter Worst Pain!" + e);
      return;
    }
  }
  
  public static void main (String argv[]) {
    DatabaseConnection db;

    try{
      db = new DatabaseConnection("hrishi", "bisux", true);
    } 
    catch (SQLException e) {
      System.out.println("Something wrong. Can't connect !!");
      System.out.flush();
      return;
    }
    VenueBooking_Rem (db);
    Offer_Accepting (db);
  }
}
  



