Rem **************************************************************************
Rem Creating the table Company

create table Company (
  company_id varchar(8),
  company_name varchar(50),
  address varchar(100),
  contacts varchar(2000),
  url varchar(80), 
  profile_filename varchar(50),  
  constraint Company_PK_company_id primary key (company_id));

Rem **************************************************************************
Rem Creating the table Password
create table Password (
  student_id varchar(8), 
  password varchar(10),
  constraint Password_PK_student_id primary key (student_id));

Rem **************************************************************************
Rem Creating the table Student
Rem I dont really know what can_reg flag is.

create table Student (
  student_id,
  resume_valid char(1),
  has_job char(1),
  num_jobs number(2) default 0,
  company_id,
  email varchar(50),
  can_reg char(1),
  constraint Student_PK_student_id primary key (student_id),
  constraint Student_FK_student_id foreign key (student_id) references Password (student_id),
  constraint Student_FK_company_id foreign key (company_id) references Company(company_id));

Rem **************************************************************************
Rem Creating the table Dept

create table Dept (
  dept_id varchar(5),
  dept_name varchar(50),
  prog varchar(5),
  total_students number(4) default 0,
  reg_students number(4) default 0,
  jobA number(4) default 0,
  jobB number(4) default 0,
  jobC number(4) default 0,
  constraint Dept_PK_dept_id_prog primary key (dept_id, prog));

Rem **************************************************************************
Rem Creating the table Resume

create table Resume (
  student_id,
  last_name varchar(20),
  first_name varchar(20),
  middle_name varchar(20),
  hostel_number number(2),
  room_number number(3),
  perm_address varchar(100),
  curr_address varchar(100),
  dept_id,
  prog,
  Xboard varchar(50),
  Xsubjects varchar(50),
  Xmarks number(4,2) default 0,
  XIIboard varchar(50),
  XIIsubjects varchar(50),
  XIImarks number(4,2) default 0,
  FreshieCPI number(4,2) default 0,
  FreshieCourses varchar(80),
  SophieCPI number(4,2) default 0,
  SophieCourses varchar(80),
  JuniorCPI number(4,2) default 0,
  JuniorCourses varchar(80),
  SeniorCPI number(4,2) default 0,
  SeniorCourses varchar(80),
  Resume_filename varchar(50),
  constraint Resume_PK_student_id primary key (student_id),
  constraint Resume_FK_student_id foreign key (student_id) references Password(student_id),
  constraint Resume_FK_dept_id_prog foreign key (dept_id, prog) references Dept(dept_id, prog));

Rem **************************************************************************
Rem Creating the table Auth

create table Auth (
  dept_id,
  prog,
  auth_id char(5),
  auth_email varchar(50), /* added by kaushy */
  constraint Auth_PK_auth_id primary key (auth_id),
  constraint Auth_FK_dept_id_prog foreign key (dept_id, prog) references Dept(dept_id, prog));
  
Rem **************************************************************************
Rem Creating the table PPT_Sched 

create table PPT_Sched (
  company_id,
  ppt_time date,
  ppt_venue varchar(30),
  last_reg_date date,
  constraint PPT_Sched_PK_company_id primary key (company_id),
  constraint PPT_Sched_FK_company_id foreign key (company_id) references Company(company_id));

Rem **************************************************************************
Rem Creating the table Round_Sched

create table Round_Sched (
  company_id,
  round number(2) default 0,
  round_time date,
  round_venue varchar(30),
  constraint Round_Sched_PK_compid_round primary key (company_id, round),
  constraint Round_Sched_FK_company_id foreign key (company_id) references Company(company_id));

Rem **************************************************************************
Rem Creating the table Job_Reg 

create table Job_Reg (
  company_id,
  student_id,
  constraint Job_Reg_PK_sid_cid primary key (student_id, company_id),
  constraint Job_Reg_FK_student_id foreign key (student_id) references Password(student_id),
  constraint Job_Reg_FK_company_id foreign key (company_id) references Company(company_id));

Rem **************************************************************************
Rem Creating the table Job_Choice

create table Job_Choice (
  company_id,
  student_id,
  constraint Job_Choice_PK_sid_cid primary key (student_id, company_id),
  constraint Job_Choice_FK_student_id foreign key (student_id) references Password(student_id),
  constraint Job_Choice_FK_company_id foreign key (company_id) references Company(company_id));

Rem **************************************************************************
Rem Creating the table Sel_Stud

create table Sel_Stud (
  company_id,
  round,
  student_id,
  constraint Sel_Stud_FK_student_id foreign key (student_id) references Password(student_id),
  constraint Sel_Stud_FK_company_id_round foreign key (company_id, round) references Round_Sched (company_id, round));
	
Rem **************************************************************************
Rem Creating the table Job_Offer

create table Job_Offer (
  company_id,
  pay number(8) default 0,
  dept_id,
  prog,
  minCPI number(4,2) default 0,
  maxCPI number(4,2) default 0,
  miscQual varchar(2000),
  description varchar(2000),
  constraint Job_Offer_FK_company_id foreign key (company_id) references Company(company_id),
  constraint Job_Offer_FK_dept_id_prog foreign key (dept_id, prog) references Dept (dept_id, prog));

Rem **************************************************************************
Rem Creating the table Comp_Category

create table Comp_Category (
  company_id,
  isclub char(1),
  category char(1),
  payment_tot number(9,2) default 0,
  payment_paid number(9,2) default 0,
  constraint Comp_Category_FK_company_id foreign key (company_id) references Company(company_id));

Rem **************************************************************************
Rem Creating the table Offer_Letter

create table Offer_Letter (
  company_id,
  student_id,
  offer_recd char(1),
  last_date date,
  yesno char(1),
  constraint Offer_Letter_FK_company_id foreign key (company_id) references Company(company_id),
  constraint Offer_Letter_FK_student_id foreign key (student_id) references Password(student_id));

Rem **************************************************************************
Rem Creating the constraints, and other very updatable type queries table

create table Cons (
  cons_cat char(3),
  cons_desc varchar(500),
  cons varchar(2000));




