import java.sql.*;
import java.lang.*;

/** Class DatabaseConnection.java 
  * Written by Kaustubh */

/* The database connectivity is cogged from kedar, refer to him for
 * original details. 
 *
 * This class deals will all the low level operations on the database, ie.
 * creating a connection, updating tables, running queries etc. 
 *
 * Note: almost all procedures throw an SQLException when an error is
 * encountered.
 *
 * The constructors are:
 * 1. this( user, pass, boolean autoCommit) 
 * 2. this (user, pass)
 * Here user is username, pass is password. Boolean indicates whether
 * each SQL query should be commited when executed.
 * NOTE: by default autoCommit is OFF
 *
 * The various functions in this class are as follows :
 * prepareStatement(String s) 
 * 	creates a prepared SQL query with parameters from string s. The
 * 	parameters are initially cleared. This is a public data member
 * 	and to set its parameters just say 
 *		name.prepStmt.setXXX(int,XXX) 
 *	XXX denotes the type of the parameter (e.g. int, string etc.)
 *	int denotes the position of the parameter.
 *
 * update()
 *	updates, inserts, deletes in the database with the prepared statement;
 * update(boolean commit)
 *	commits the update if commit is true.
 * update(String s)
 *	updates the database with the SQL statement s;
 * update(String s, boolean commit)
 *	commits the update if commit is true.
 * query (String sql)
 * 	makes an sql query which returns a single ResultSet
 * 
 * NOTE: use the following two methods ONLY when autoCommit is OFF.
 * commit()
 *	commits the updates
 * rollback()
 *	rolls back the updates
 */

public class DatabaseConnection {
	Connection conn;
	Statement stmt;
	public PreparedStatement prepStmt;

	// copied the driver manager from kedar
	
	// by default the autocommit is *off* 
	public DatabaseConnection() { } //empty constructor -- avoid using.
	public DatabaseConnection( String user, String pass) throws SQLException 
	{
		this(user,pass,false);
	}

	public DatabaseConnection( String user, String pass, boolean
			autoCommit) throws SQLException 
	{
// Load the Oracle JDBC driver
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		
// Connect to the database
// You must put a database name after the @ sign in the connection URL.
// You can use either the fully specified SQL*net syntax or a short cut
// syntax as <host>:<port>:<sid>.  The example uses the short cut syntax.
		this.conn = DriverManager.getConnection
			(Config.getVal("connection_manager"), user, pass); 

    // Create a Statement
		this.stmt = this.conn.createStatement ();
		this.conn.setAutoCommit(autoCommit);
	}

    // Creates a prepared statement. (this proc is unused)
	public void prepareStatement(String s) throws SQLException 
	{
		prepStmt=conn.prepareStatement(s);
		prepStmt.clearParameters();
	}

	public int update() throws SQLException
	{
		return update(false);
	}
	
	public int update(boolean commit) throws SQLException
	{
		int a = prepStmt.executeUpdate();
		if (commit == true )
			conn.commit();
		return a;
	}
	
// update with the query str
	public int update(String str) throws SQLException
	{
		return update(str,false);
	}

// update with the query str
	public int update(String str,boolean commit) throws SQLException
	{
		System.err.println(str);
		int a = stmt.executeUpdate(str);
		System.err.println("Query Executed");
		if (commit == true )
			conn.commit();
		return a;
	}

// runs a query str on the database
	public ResultSet query(String str) throws SQLException
	{
		// note: a statement needs to be created everytime for some
		// vague reason.
		this.stmt = this.conn.createStatement (); 
		System.err.println(str);
		return stmt.executeQuery(str);
	}

	// commit
	public void commit() throws SQLException
	{
		conn.commit();
		System.err.println("The updates have got commited");
	}

	//rollback
	public void rollback() throws SQLException
	{
		conn.rollback();
		System.err.println("The updates have got ROLLED BACK");
	}
}
	
