import java.lang.*;
import java.io.*;
import java.util.*;

/** Class Functions
  * written by Kaustubh */

/* This class contains all the static functions of everyday utility. Each
 * function is described where it is defined.
 */

class Functions {
	
	// this function replaces a substring in the given string by 
	// another given substring. 
	// String main -- String in which replacment should occur
	// String rep  -- String to be replaced.
	// String by   -- String to replace by.
	public static String replace(String main, String rep, String by)
	{	
		int i;
		String temp1,temp2,temp3;
		i = main.indexOf(rep);
		if (i != -1) {
			temp1 = main.substring(0,i);
			temp2 = main.substring(i+rep.length());
			main = temp1+by+temp2;
		}
		return main;
	}

	// this function is invoked whenever an illegal access is tried.
	// it just writes out the contents of illegal page on the output.
	// the html page illegal.html contains the contents to be displayed
	// when such an error occurs.
	public static void stdError(PrintWriter out) 
	{
		try {
		HtmlPage illegal = new HtmlPage(Config.getVal("illegal"));
		illegal.writeout(out);
		} catch (FileNotFoundException e) {
			out.println("The data you requested was not available on this server.");
		}
		out.flush();
	}

	// This function creates a list of check boxes in html. The properties
	// object p, contains an association (id,name), where id will be the
	// name of the checkbox, while name is the text to be displayed in
	// front of each checkbox.
	//
	// The property object check contains an association (id,id) for all
	// checkboxes having name id, and which have to be marked by default.
	public static String createCheckBoxList(Properties p,Properties check)
	{
		String page = new String();
		String id;
		Enumeration list = p.propertyNames();
		String isChecked="";
		while(list.hasMoreElements()) {
			id = (String)list.nextElement();
			// isChecked = "CHECKED" when check contains that id.
			if(id.equals(check.getProperty(id)))
			{
				isChecked="CHECKED";
				System.err.println("ch "+id+" "+isChecked);
			}
			else
				isChecked="";
			page += "<input type=\"checkbox\" name=\""+id+
				"\""+isChecked+">"+p.getProperty(id)+"<br>";
		}
		return page;
	}
}

