import java.lang.*;
import java.io.*;
import java.util.*;

/** Class HtmlPage
  * written by Kaustubh */

/* This class reads an html file and prints them on the output stream.
 * 
 * The constructor of this class is 
 * HtmlPage(String filename)
 * Here filename is the name of the Html file which we want to show, i.e. print
 * on the output stream.
 *
 * The functions are
 * writeout(PrintWriter out)  -- writes the file on the PrintWriter out.
 *
 * writeout(PrintWriter out, Properties prop)
 * 	Here props is a property object which contains default values for
 * various fields in the file. The fields in the file are of type "$name",
 * while the Properties object contains (name,value). Here the first occurance
 * of $name is replaced by "value".
 *
 */

public class HtmlPage {
	FileReader page;
	
	//constructor 
	public HtmlPage(String filename) throws FileNotFoundException{
		File fp = new File(filename);
		page = new FileReader(fp);
	}

	// writes file to output stream.
	public void writeout(PrintWriter out) {
		int c;
		try {
		while ((c=page.read()) != -1)
			out.print((char)c);
		out.flush(); 
		}
		catch (IOException e) { }
	}

	// writes file to output stream with substitution.
	// uses function Functions.replace()
	public void writeout(PrintWriter out, Properties props)
	{
		int c;
		StringWriter sw = new StringWriter();
		try {
		while ((c=page.read()) != -1)
			sw.write((char)c);
		}
		catch (IOException e) { }
		String contents = sw.toString();

		Enumeration colnames = props.propertyNames();
		while (colnames.hasMoreElements())
		{
			String name = (String)colnames.nextElement();
			contents = Functions.replace(contents,"$"+name.toLowerCase(),props.getProperty(name));
		}
		out.print(contents);
		out.flush();
/* 		System.err.println(contents); */
	}
}
