import java.util.*;
import java.sql.*;
import java.lang.*;

/** Class ListGenerator
  * written by Kaustubh */

/* This class inserts a list of elements in a Table. 
 * The constructor has the following arguments in the given order:
 * database - a DatabaseConnection.
 *
 * list - an Enumeration of the members u want to insert. Note: all the members
 * are required to be Strings.
 *
 * columnName - the column into which the members are to be inserted.
 *
 * tableName - the table into which the names r to be inserted.
 *
 * otherEntries -  a Property object containing all the other entries in the
 * table. 
 *
 * cons_cat - The value of the field cons_cat in the contraint table (cons).
 * This variable is there so that you can check contraints while registering
 * students for various companies. If the value of cons_cat is null then the
 * constraints are not checked.
 *
 *
 * To use this class, call constructor and then use the function
 * process() which throws SQLException.
 * 
 * This should have actually been a function, but is a class for some vague
 * reasons which even I dont know of.
 */

public class ListGenerator {
	Enumeration list;
	DatabaseConnection database;
	String tableName,columnName;
	Properties otherEntries;
	String cons_cat;

	public ListGenerator(DatabaseConnection database, Enumeration list, 
			String columnName, String tableName, 
			Properties otherEntries, String cons_cat) {
		this.database=database;
		this.list=list;
		this.tableName=tableName;
		this.columnName=columnName;
		this.otherEntries=otherEntries;
		this.cons_cat = cons_cat;
	}

	// this function does all the processing of inserting the whole list
	// into the table.
	public void process() throws SQLException {
		// Table object into which to insert.
		Table t = new Table(tableName,database); 
		otherEntries.remove(columnName);
		String kela = new String();
		// string to be return incase there is an error.
		boolean allowed = true; // are u allowed to insert.

		while(list.hasMoreElements()) {
			String nextElement=(String) list.nextElement();
			System.err.println(nextElement);
			otherEntries.put(columnName,nextElement);
			t.insert(otherEntries);
			if (cons_cat != null) {
				try {
				constraint_check(otherEntries,cons_cat);
				}
				catch (SQLException e)
				{
					if(e.getErrorCode()==5037)
					{
						// this code indicates that one
						// of the contraints failed.
						allowed=false;
						kela+="\n"+e.toString()+"\n";
					}
					else
						throw e;
				}
			}
			otherEntries.remove(columnName);
		}
		if(!allowed)
			throw new SQLException(kela+"\n\n\nHence no updates done.\n");

		// The final kela was added, to give the user an indication of
		// the errors during insertion of each company, even though the
		// results are not going to be commited.
	}
	
	// smitao added this 
	// shifted here from Table.java by me.
	// Properties is an object which contains the primary keys, i.e.
	// "company_id" and "student_id". 
	// cons_cat is the category of the contraints.

	// in the query $1 is replaced by student_id and $2 by company_id.
	// An SQLException is thrown with no. = 5037 if u r not allowed to
	// register. It also returns the reason for this denial in the
	// Execption.
	// A return value of 'Y' indicates successful query.
	// All the contraint queries are executed one by one.
	public void constraint_check(Properties row, String cons_cat) throws SQLException {
		row.list(System.err);	
 		String com_id = row.getProperty("company_id");
		String stud_id = row.getProperty("student_id");
		ResultSet qry = this.database.query("select cons from Cons where cons_cat = '"+cons_cat+"'");
		while(qry.next()) 
		{
			String upd = qry.getString(1);
			upd = replace_string(upd,"$1",stud_id);
			upd = replace_string(upd,"$2",com_id);
			System.err.println(upd);
			ResultSet rs = database.query(upd);
			rs.next();
			String reason= rs.getString(1);
			if(!reason.equalsIgnoreCase("Y"))
			{	
				System.err.println(reason);
				reason = reason.substring(1);
				throw new SQLException(
					"You are not allowed to register for "+
					getCompName(com_id)+" because: "+reason,"",5037);
			}
		}
	}

	// written by smitao
	// this function replaces all occurences a substring in the given
	// string by another given substring. The version in Functions is an
	// adaptation of this. In fact this function should also have been
	// there.
	// Imp NOTE: The function encloses the replaced string in single quotes.
	String replace_string(String main, String rep, String rep_by)
	{	
	  int i;
	  String temp1,temp2,temp3;
	  temp3=main;
	  i= main.indexOf(rep);
	  while(i != -1)
	  {
	  temp1 = temp3.substring(0,i);
	  temp2 = temp3.substring(i+rep.length());
	  temp3=temp1+"'"+rep_by+"'"+temp2;
	  i= temp3.indexOf(rep);
	  }
	  return temp3;
	  }

	// This functions returns the name of the company, given its id.
	public String getCompName(String cid) throws SQLException
	{
		ResultSet rs=database.query("select company_name from company where company_id = '"+cid+"'");
		if(rs.next())
			return rs.getString(1);
		else
			throw new SQLException("This company doesnt exist");
	}
}
		

