import java.lang.*;
import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Class MainScreen.java
  * written by kaustubh */

/*  This is the main servlet. It takes in input from index.html -- the login
 *  form. It gives the main menu as the output, if the user gets authenticated.
 *  The get part also displays the main menu. This class maintains sessions.
 */
public class MainScreen extends HttpServlet { 
	DatabaseConnection database;
	String stud;

	public void init (ServletConfig cfg) throws ServletException{
		// load the initial configuration file.
		Config.makeConfig(); 
	}

	public void doGet(HttpServletRequest req,HttpServletResponse res) 
		throws ServletException, IOException
	{
	  	res.setContentType("text/html");
		PrintWriter out = res.getWriter();

		// check if session is still valid.
		HttpSession hs = req.getSession(false);
		if (hs == null) {
			Functions.stdError(out);
			return;
		}

		// If there is a query string, then a request is made for
		// logging out. The HttpSession is invalidated and the index 
		// page is loaded.
		if(req.getQueryString() != null) 
		{
			hs.invalidate();
			System.err.println("Logging Out");
			HtmlPage mainpage = new HtmlPage(Config.getVal("mainpage"));
			mainpage.writeout(out);
			return;
		}
			
		// these values are stored inside the session object.
		String stud = (String) hs.getValue("student_id");
		DatabaseConnection db = (DatabaseConnection) hs.getValue("connection");

		try {
		// the file login.html is displayed on the screen.
		HtmlPage login = new HtmlPage(Config.getVal("login"));
		login.writeout(out);
		} catch (FileNotFoundException e) {
			out.println("The data you requested was not available on this server.");
		}
		out.flush();
	}
		
	// this method is called when a submission is done through the login
	// form.
	public void doPost(HttpServletRequest req,HttpServletResponse res) 
		throws ServletException, IOException
	{
	  	res.setContentType("text/html");
		PrintWriter out = res.getWriter();

		// start a new session
		HttpSession session = req.getSession(true);
		
		// Open a database connection.
		try {
		database = new DatabaseConnection(Config.getVal("username"),Config.getVal("password"));
		}
		catch (SQLException e) {
			session.invalidate();
			System.err.println("Major gotcha\n"+e+"\n");
			out.println("The Database refuses to accept your connection\n"+e+"\n");
			out.flush();
			return;
		}

		// find out user name and password
		stud = req.getParameter("student_id");
		String passwd = req.getParameter("password");

		// store these values in the session.
		session.putValue("student_id",stud);
		session.putValue("connection",database);

		// check whether user is a vaild one
		try {
		authenticate(stud,passwd);
		database.commit();
		}
		catch (SQLException e ) {
			session.invalidate();
			out.println("Error: "+e);
			out.flush();
			return ;
		}
		try {
		// the file login.html is displayed on the screen.
		HtmlPage login = new HtmlPage(Config.getVal("login"));
		login.writeout(out);
		} catch (FileNotFoundException e) {
			out.println("The data you requested was not available on this server.");
		}
		out.flush();
	}
		
	// This method checks whether the student_id and password are valid. 
	// The password is stored in the password table.
	void authenticate(String student_id, String passwd) throws SQLException
	{
		ResultSet rs;
		String dbp;
		try {
		// find out password of student from password table
		rs = database.query("select password from password" 
				+" where student_id = '" +student_id+"'");
		rs.next();
		dbp=rs.getString("password");
		System.err.println("Input:"+passwd +"\nPresent:"+dbp);
		}
		catch (SQLException e) {
			throw new SQLException("Invalid username");
		}

		//check whether input and output are same.
		if (!dbp.equals(passwd)) 
			throw new SQLException("Invalid username/password");
	}
}
