import java.lang.*;
import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Class Reg
  * written by kaustubh */

/* This is another servlet, which deals with registering students for companies.
 * and students selecting companies of their choice. If the queryString is null
 * then request is for registering students, else it is for choosing the
 * company. 
 */

public class Reg extends HttpServlet{
	Properties table;
	PrintWriter out;
	String stud;
	int type;
	
	public void init (ServletConfig cfg) throws ServletException{
/* 		LOT.makeLOT();  // why here? */
	}

	// For a get request, display a list of companies with a checkbox in
	// front of each. If a company is selected before, then by default it
	// is checked initially.
	public void doGet(HttpServletRequest req,HttpServletResponse res) 
		throws ServletException, IOException
	{
		out = res.getWriter();

		res.setContentType("text/html");
		// check for validity of session.
		HttpSession hs = req.getSession(false);
		if (hs == null) {
			Functions.stdError(out);
			return;
		}

		stud = (String) hs.getValue("student_id");
		DatabaseConnection db = (DatabaseConnection) hs.getValue("connection");
		
		String header;
		String table;
		if(req.getQueryString() == null) 
		{
			// filling the registration list
			header=Config.getVal("reg_head");
			table = "job_reg";
		}
		else // it is filling the choice list
		{
			header=Config.getVal("choice_head");
			table = "job_choice";
		}

			
		try {
		Table comp = new Table("company",db);
		Properties p = comp.multiquery("company_id","company_name",null);
		Table reg = new Table(table,db);
		
		Properties checked = reg.multiquery("company_id","company_id"," where student_id = '"+stud+"'");

		// p contains the list of all companies and 
		// checked contains a list of all companies which should be checked initially.
		String boxes = Functions.createCheckBoxList(p,checked);
		// hence boxes contains this list in html format.
		HtmlPage head = new HtmlPage(header);
		HtmlPage tail = new HtmlPage(Config.getVal("tail"));
		head.writeout(out);
		out.println(boxes);
		tail.writeout(out);
		}
		catch(SQLException e) {
			out.println("Error "+e);
			System.err.println("Error "+e);
		}
		out.flush();
	}

	// for a post request make the correct addendums and deletions from the
	// database.
	public void doPost(HttpServletRequest req,HttpServletResponse res) 
		throws ServletException, IOException
	{
		out = res.getWriter();

		HttpSession hs = req.getSession(false);
		if (hs == null) {
			Functions.stdError(out);
			return;
		}

		stud = (String) hs.getValue("student_id");
		DatabaseConnection db = (DatabaseConnection) hs.getValue("connection");

	    	// first get the properties object
		table = getProp(req);

		SCC list;
		if(req.getQueryString() == null)
		{
			list= new SCC(table,out,db,1);
		}
		else
		{
			list = new SCC(table,out,db,2);
		}
		list.process();
	}

	// This gives a property object containing all parameters passed by the
	// request.
	Properties getProp(HttpServletRequest req)
	{
		Properties p = new Properties();
		p.put("student_id",stud);
		Enumeration test = req.getParameterNames();
		while(test.hasMoreElements())
		{
			String compid = (String)test.nextElement();
			System.err.println(compid);
			p.put(compid,"");
		}
		return p;
	}
}
