import java.lang.*;
import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Class Resume.java
  * written by kaustubh 
  */

/*  This is yet another servlet, which deals with updating of resumes. */

public class Resume extends HttpServlet{
	Properties table;
	PrintWriter out;
	int type;
	
	public void init (ServletConfig cfg) throws ServletException{
/* 		LOT.makeLOT();  // why here? */
	}

	// The get request first checks whether the student has already
	// submitted a resume. If he has, he is given a warning and redirected
	// somewhere else. If he hasnt, then a blank form is submitted to him.
	public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{

		out = res.getWriter();
		// check validity
		HttpSession hs = req.getSession(false);
		if (hs == null) {
			Functions.stdError(out);
			return;
		}

		res.setContentType("text/html");

		String stud = (String) hs.getValue("student_id");
		DatabaseConnection db = (DatabaseConnection) hs.getValue("connection");

		//first check whether the student has already submitted resume
		boolean submitted = true;
		try {
		ResultSet rs = db.query("select student_id from resume where student_id = '"+stud+"'");
		if(!rs.next())
			submitted = false;
		}
		catch (SQLException e) { 
			out.println("Error: "+e);
			System.err.println("Error: "+e);
			out.flush();
			return;
		}
		
		if(submitted)
		{
			// redirect
			HtmlPage resume = new HtmlPage(Config.getVal("submitted_resume"));
			resume.writeout(out);
		}
		else
		{
			// show empty form
			HtmlPage resume = new HtmlPage(Config.getVal("resume"));
			resume.writeout(out);
		}
		out.flush();
	}

	// the post request takes the resume and inserts it in the table, using
	// the class SCC.
	public void doPost(HttpServletRequest req,HttpServletResponse res) 
		throws ServletException, IOException
	{
	    	// first get the properties object
		table = getProp(req);
		out = res.getWriter();

		// get the HttpSession and check for compatiblity
		HttpSession hs = req.getSession(false);
		if (hs == null) {
			Functions.stdError(out);
			return;
		}

		String stud = (String) hs.getValue("student_id");
		DatabaseConnection db = (DatabaseConnection) hs.getValue("connection");
		
		// add student name to the propertly list
		table.put("student_id",stud);

		SCC resume= new SCC(table,out,db,0);
		resume.process();
	}

	// this procedure gets all the arguments in a form, and puts them in a
	// properties object in (name,value) pairs.
	Properties getProp(HttpServletRequest req)
	{
		Enumeration props=req.getParameterNames();
		Properties p = new Properties();
		while (props.hasMoreElements())
		{
			String name=(String) props.nextElement();
			String val=req.getParameter(name);
			if ( val.length() != 0)
				p.put(name,val);
		}
		return p;
	}
}
