import java.lang.*;
import java.io.*;
import java.util.*;
import java.sql.*;

/** Class SCC.java
  * written by kaustubh */

/* This class exists for purely historical reasons, and to maintain
 * compatibility with previously written code. Its code could have easily been
 * transfered to the respective servlets.
 *
 * The constructor of this class is:
 * SCC( Properties, PrintWriter,type)
 * Properties = table containing name=value
 * PrintWriter = an output stream
 * DatabaseConnection = a connection to the database
 * type = integer indicating what type of operation.
 * 0 - resume insertion/updation
 * 1 - reg list insertion
 * 2 - choice list insertion
 *
 * Start processing this information with SCC.process();
 */

public class SCC extends Thread {
	Properties table;
	PrintWriter output;
	int type;
	DatabaseConnection database;
	String stud;
	
	// constructor
	public SCC(Properties table, PrintWriter output, DatabaseConnection db, int type){
		this.table = table;
		this.output = output;
		this.type = type;
		database=db;
		stud=table.getProperty("student_id");
	}
	
	public void process (){

		// decide which path to take
		switch(type) {
			case 0: personalInfoUpdater();
				break;
			case 1: listUpdater("job_reg","STR");
				break;
			case 2: listUpdater("job_choice",null);
				break; 
		}
	}

	// this function updates the resumes.
	void personalInfoUpdater() {
		PInfo info = new PInfo(database,table);
 		try { 
		info.process();
		database.commit();
		output.println("Your resume information has been updated and sent for verification.");
		output.flush();
		}
		catch (SQLException e) 
		{ System.err.println("Err: "+e); 
		  output.println("Err: "+e); 
		  System.err.println("The complete transaction is undone.");
		  try {
		  database.rollback(); }
		  catch (SQLException e1) 
		  { System.err.println("Giving up on oracle/sql/bisproject."
				 +e1); }
		}
	}
	
	// This function updates the list to the table "whichList", and
	// constraints "cons_cat"
	void listUpdater(String whichList,String cons_cat) {
		table.remove("student_id");
		Enumeration list=table.propertyNames();
		Properties p = new Properties();
		p.put("student_id",stud);
		ListGenerator lst = new ListGenerator(database,list,
				"company_id", whichList,p,cons_cat);
 		try { 
		// first delete all the initial values
		database.query("delete from "+whichList+" where student_id='"+stud+"'");
		// then process and insert
		lst.process();
		database.commit();
		output.println("You have selected the following companies:\n\n");
 		display(table,output); 
		}
		catch (SQLException e) 
		{ System.err.println("Err: "+e); 
		  output.println("Err: "+e); 
		  System.err.println("The complete transaction is undone.");
		  try {
		  database.rollback(); }
		  catch (SQLException e1) 
		  { System.err.println("Giving up on oracle/sql/bisproject."
				 +e1); }
		}
	}

	// this function is not used 
	void write(ResultSet rs) throws SQLException{
    // Iterate through the result and print the values
		while (rs.next())
		{
			output.println(rs.getString(1));
		}
			output.flush();
	}

	// displays a property object nicely on the output out.
	public void display(Properties list,PrintWriter out)
	{
		Enumeration p = list.propertyNames();
		try {
		Table comp = new Table("company",database);
		Properties cnames = comp.multiquery("company_id","company_name",null);
		String comp_id;
		int i=1;
		while(p.hasMoreElements())
		{
			comp_id= (String)p.nextElement();
			out.println((i++)+". "+cnames.getProperty(comp_id)+"\n");
		}
		}
		catch(SQLException e ) { out.println("Error "+e);
			System.err.println("Error "+e);
		}
	}
}

/** Class PInfo 
  * Written by kaustubh
  * Note: This class is not for public use. */

/* Right now this class doesnt seem to do anything other than adding the resume
 * details to the database tables. It also manages to sendmail to the
 * authenticator.
 */

class PInfo {
	Properties studInfo;
	DatabaseConnection database;
	
	PInfo(DatabaseConnection database,Properties studInfo) {
		this.studInfo=studInfo;
		this.database=database;
	}
	
	// main process
	public void process() throws SQLException
	{
		Table t;
/* 		t = new Table("student",database); */
/* 		t.insert(studInfo); */
		t = new Table("resume",database);
		try {
		// insert the values into the table
		t.insert(studInfo);
		}
		catch (SQLException e) {
			if(e.getErrorCode()==1) 
				// if insertion fails due to primary key error,
				// then try an update.
				t.update(studInfo,"student_id");
			else
				throw e;
		}
		mailAuth();
	}

	// Send a mail to the authenticator indicating that the fellow has
	// changed resume. Uses class Mailer.
	void mailAuth() throws SQLException
	{
		String dept=studInfo.getProperty("dept_id");
		String prog=studInfo.getProperty("prog");
		ResultSet rs = database.query("select auth_email from "+
				"auth"+" where dept_id='" +
				dept+"' and prog ='"+prog+"'");
		rs.next();
		String email=rs.getString(1);
		try {
		System.err.println("sending mail to "+email);
		String mesg = "Subject: T&P Authentication.\n u r authenticator\n"+
			studInfo.getProperty("student_id")+" has submitted resume.";
		Mailer.mail(email,mesg);
		} catch (IOException e)
		{ System.err.println("Cant send mail."+e); }
	}
}
