import java.util.*;
import java.sql.*;

/** Class Table.java 
  * Written by kaustubh */

/* This is a generic class, denoting a table in the database. It is designed to
 * make the inserting, quering and updating in a table simpler and easier to
 * write. It defines the highlevel functions in the database.
 * The datamembers of this class are :
 * 	tableName = name of the table;
 * 	conn = a connection to the db;
 * call the constructor with these two members 
 * 
 * The functions provided are:
 * 	columnInfo : returns the names of the columns in the table;
 *
 * 	insert(Properties row) throws SQLException : extracts the appropriate
 * 		column values from row and inserts the row in the table. Note
 * 		no updates are commited. Please commit them yourselves.
 *
 *	// written by smitao
 *	update(Properties row, String primary_key) throws SQLException : 
 *		updates the column values where the primary_key is given. The
 *		value of the primary_key must be present in the properties
 *		object row. again note that the updates are *NOT* commited by
 *		default. please commit them urselves.
 *
 *	query - Returns a property object which contains pairs
 *	(column_name,value). 
 *
 * NOTE: Important Assumption
 *	the Property row _MUST_ have all its field names in LowerCase. The
 *	search is case sensitive. 
 */

public class Table {
	String tableName;
	DatabaseConnection conn;
	ResultSet columnInfo;
	

	public Table(String name, DatabaseConnection
			conn)  throws SQLException {
		tableName = name.toUpperCase();
		this.conn = conn;
	}

	public ResultSet columnInfo() throws SQLException{
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
		return columnInfo;
	}

	public int insert(Properties row) throws SQLException{
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
		columnInfo.next();
		String colName = columnInfo.getString(1);
		String list = colName;
		String upd = getColValue(row,colName);
		while(columnInfo.next()) {
			colName = columnInfo.getString(1);
			list += ","+colName;
			upd += ","+getColValue(row,colName);
		}
		upd = "insert into "+tableName +" ("+ list +")"+ "values (" +
			upd+")";
		columnInfo.close();
		int i= conn.update(upd);
		System.err.println("Note: insert is not committed");
		return i;
	}
	
	// this function is written by smitao 

	public int update(Properties row, String primary_key) 
			throws SQLException {
/* 		System.out.println("I am here 1"+tableName);		 */
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
/* 		System.out.println("I am here");		 */
		columnInfo.next();
		String colName = columnInfo.getString(1);
		String upd = colName + "=" +getColValue(row,colName);
		String key_val = getColValue(row,primary_key);
		while(columnInfo.next()) {
			colName = columnInfo.getString(1);
			upd += ","+ colName +"=" +getColValue(row,colName);
		}
		upd = "update "+tableName + " set "+ upd+" where "+ 
			primary_key +"=" +key_val;
		columnInfo.close();
		int i = conn.update(upd);
		System.err.println("Note: update is not committed");
		return i;
	}
	

	// this function returns the value of item colName, put in appropriate
	// quotes depending on what type of field the column is.
	private String getColValue(Properties row,String colName) throws SQLException
	{
		String val=row.getProperty(colName.toLowerCase());
		if(val == null)
			return "NULL";
		String type = columnInfo.getString(2);
		if(type.equalsIgnoreCase("varchar2") || type.equalsIgnoreCase("char") )
			return "'"+val+"'";
		else 
			return val;
	}

	public void query(Properties row, String primary_key) throws SQLException
	{
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
		String key_val = row.getProperty(primary_key);
		String query = "select * from "+ tableName+" where "+
			primary_key+"='"+key_val+"'";
		ResultSet r=conn.query(query);
		row.clear();

		// this exception is thrown when the result set contains no rows.
		if(!r.next()) { 
			throw new SQLException("No rows found","",5032); }
		while(columnInfo.next())
		{
			String colName = columnInfo.getString(1);
/* 			System.err.println(colName); */
			String str=r.getString(colName);
			if(str != null)
				row.put(colName,str);
			else
				row.put(colName,"");
		}
/* 		row.list(System.err); */
		columnInfo.close();
	}

	// for some reason the query function requires a property object. 
	// so here is a query function which takes only the key-value and 
	// returns the row in a property object. It uses the previous function 
	// which is retained for compatiblity.
	public Properties query(String key_val, String primary_key) throws SQLException
	{
		Properties row = new Properties();
		row.put(primary_key,key_val);
		query(row,primary_key);
		return row;
	}

	// this is a nice and helpful function, about whose helpfulness is
	// beyond words, so i wont be commenting on it.
	public Properties multiquery( String id,String value, String condClause) 
		throws SQLException
	{
		String where = "";
		if(condClause != null ) 
			where = condClause;
		String query = "select "+ id +","+ value +" from "+tableName
			+where;
		ResultSet rs = conn.query(query);
		Properties list = new Properties();
		while (rs.next())
			list.put(rs.getString(id) ,rs.getString(value));
		return list;
	}
}
