import java.lang.*;
import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Class Viewer.java
  * written by kaustubh
  */

/* Yet another servlet. This one displays the resume and makes it amenable for
 * updating. This class does not handle post requests.
 */
public class Viewer extends HttpServlet{
	
	// A get request, reads the resume from the database, and dumps it on
	// the screen in an html form. Uses the function HtmlPage.writeout() to
	// generate that form.
	public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{
		PrintWriter out = res.getWriter();

		// check for validity.
		HttpSession hs = req.getSession(false);
		if (hs == null) {
			Functions.stdError(out);
			return;
		}

		String stud = (String) hs.getValue("student_id");
		DatabaseConnection db = (DatabaseConnection) hs.getValue("connection");

		res.setContentType("text/html");
		try {
		Table t = new Table("resume",db);
		Properties row = t.query(stud,"student_id");
		HtmlPage hp = new HtmlPage(Config.getVal("filled_resume"));
		hp.writeout(out,row);
		out.flush();
		} catch (SQLException e) {
			if(e.getErrorCode() == 5032)
				// this exception indicates that the resume is
				// not filled.
				out.println("You have not yet submitted your resume even once.");
			else 
				out.println("Error "+e);
		}
		out.flush();
	}
}
