import java.lang.*;
import java.io.*;
import java.util.*;
import java.sql.*;

/** @author garg */
/* This class provides functions to manipulate the tables associated
 * with companies. It takes a properties object and a connection to the
 * database which it uses to make changes to the database as required. 
 */


/* The functions used are :-
 * add() - inserts the information of the company given in properties
 * object to the database
 * remove() - removes the information regarding the company from the
 * database
 * update() - modifies the information.
 * addPPT() - inserts in the ppt scheule of the specified company.
 * removePPT() and updatePPT() are the other 2 corresponding functions.
 * For interview data manipulation, similarly, there is addInterview,
 * removeInterview(), updateInterview(). All of these functions take in
 * their parameters from the properties object which was specified to
 * it.
 *
 */

 /* The methods use the functionality provided by the Table class. */

public class COM {
	Properties profile;
	DatabaseConnection database;
	

void setProperty(Properties profile){
     this.profile=profile;
 }

 void setDatabase(DatabaseConnection database){
 	this.database=database;
 }
	
 void update() throws SQLException {
	    	Table c;
	    	c=new Table("company",database);
	    	c.update(profile,"company_id");
	    
	    	c=new Table("comp_category",database);
	    	c.update(profile,"company_id");

		database.commit();
}
 
void remove() throws SQLException {
	    	Table c;
		c=new Table("comp_category",database);
	    	c.remove("company_id='"+profile.getProperty("company_id")+"'");
	    	c=new Table("company",database);
	    	c.remove("company_id='"+profile.getProperty("company_id")+"'");
	    
		database.commit();
}


void add() throws SQLException {
	/* currently doesn't know what else should be done 
	 * updates the table company & comp_category 
	 */
		process("company");
		process("comp_category");
		database.commit();
}

void PlacementOffer(){
	  /* update database
	   * email to all the students registered for the company?
	   * update the web page ?
	   */
	try{
		process("job_offer");
		database.commit();
	}
	catch (SQLException e) { 
	}	 

	email_gen();
}

void email_gen(){

// the email generator and some interface will come here...
// different criteria to determine who get mail and the message to send. 
// is the function needed at all ? Mailer.mail can do the actual sending	    
}

void addPPT() throws SQLException {
	/* updates database
	 * email to studetns registered for it?
	 * update the web page?
	 * data to EP (everyday program).?
 	*/

	process("ppt_sched");
	database.commit();

	email_gen(); // this will also involve some manipulations to
// determine who all to send mail to.

}

void updatePPT() throws SQLException {
	Table c;
	c=new Table("ppt_sched",database);
	c.update(profile,"company_id");
	database.commit();

	email_gen();
}

void removePPT() throws SQLException {

    	Table c;
	c=new Table("ppt_sched",database);
    	c.remove("company_id='"+profile.getProperty("company_id")+"'");
	
	database.commit();
	email_gen();
}

void addInterview() throws SQLException {
	/* updates database
	 * email to studetns registered for it?
	 * update the web page?
	 * data to EP (everyday program).?
 	*/

	process("round_sched");
	database.commit();

	email_gen();
}

void updateInterview() throws SQLException {
	Table c;
	c=new Table("round_sched",database);
	c.update(profile,"company_id");
	database.commit();

	email_gen();
}

void removeInterview() throws SQLException {

    	Table c;
	c=new Table("round_sched",database);
    	c.remove("company_id='"+profile.getProperty("company_id")+"'");
	
	database.commit();
	email_gen();
}

private void process(String s) throws SQLException {
            Table c;
            c=new Table(s,database);
            c.insert(profile);
}

} // class
