
import java.io.*;
import java.sql.*;
import java.util.*;
import java.lang.reflect.*;

import javax.servlet.*;
import javax.servlet.http.*;

/** @author garg */
/* CompanyList generates a list of all company id , company names from
 * the companies table. Each generated entry is a link to Company Modify
 * servlet which will generate a form to change that company's info 
 */
 
public class CompanyList extends HttpServlet 
{
	
public void init(ServletConfig cfg) throws ServletException {

}


// doPost not supported by this URL

public void doGet(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException {
	
	DatabaseConnection db;

	HttpSession session = request.getSession(false);

	if(session==null){
		response.sendError(HttpServletResponse.SC_UNAUTHORIZED,"Unauthorized access attempted. You must login first!");
		return;
	}

	response.setContentType("text/html");
	PrintWriter out = response.getWriter();

	out.println("<HTML> <HEAD>"); 
	out.println("<TITLE>T&amp;P Cell IIT-Bombay</TITLE>");
	out.println(" </HEAD> ");
	out.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFCC\" LINK=\"#0000EF\" VLINK=\"#51188E\" ALINK=\"#FF0000\">");
	out.println("<H1> <U>T&amp;P Cell IIT-Bombay</U></H1>");

	db=(DatabaseConnection) session.getValue(session.getId()+".databaseHandle");

	// CompanyUtils.generateList(db,out);
	
	Properties list=null;

	try { 
		Table tab = new Table("company",db);
		list = tab.multiquery("company_id","company_name",null); 
	}
	catch(SQLException e){
		out.println("Error reading database: " + e + "\n");
	}
	out.println("<table valign=center width=80%>\n");	
	out.println("<tr>\n<td>Company ID</td>\n<td>Company Name</td></tr>\n");
	out.println(CompanyUtils.format("<tr>\n<td><a href=CompanyModify?id=$1>$1</a></td>\n<td><a href=CompanyModify?id=$1>$2</a></td></tr>\n", list));
	out.println("</table>\n");	
	out.println("<HR> <A HREF=Logout>Logout</A>");
	out.println("<HR> <A HREF=CompanyModify>Add</A>");
	out.println("<A HREF=StaffServlet>Back</A>");
	out.println("</BODY></HTML>");

} // doGet

public String getServletInfo() {
	return "T&P Server";
} 
		 
} //class

