
import java.io.*;
import java.sql.*;
import java.util.*;
import java.lang.reflect.*;

import javax.servlet.*;
import javax.servlet.http.*;

/** @author garg */
/* This class generates the required forms for individual companies for
 * updation. If the get method is used without any query then a form to
 * add a company is generated. If the company name is given in the
 * query then a form for making changes to that companies database is
 * generated. 
 */
 
public class CompanyModify extends HttpServlet 
{
	
public void init(ServletConfig cfg) throws ServletException {

}

public void doGet(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException {
	
	DatabaseConnection db;
	HtmlPage cominfo;

	HttpSession session = request.getSession(false);

	// check if session is valid
	if(session==null){
		response.sendError(HttpServletResponse.SC_BAD_REQUEST,"Unauthorized access attempted. You must login first!");
		return ;
	}

	// send standard headers.
	response.setContentType("text/html");
	PrintWriter out = response.getWriter();

	out.println("<HTML> <HEAD>"); 
	out.println("<TITLE>T&amp;P Cell IIT-Bombay</TITLE>");
	out.println(" </HEAD> ");
	out.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFCC\" LINK=\"#0000EF\" VLINK=\"#51188E\" ALINK=\"#FF0000\">");
	out.println("<H1> <U>T&amp;P Cell IIT-Bombay</U></H1>");

	db=(DatabaseConnection)session.getValue(session.getId()+".databaseHandle");

	String query = request.getQueryString();

	// if no query then generate a blank form
	if(query==null){
		cominfo = new HtmlPage(Configuration.getProperty("companyInfoForm_blank"));
		cominfo.writeout(out);

		out.println("<HR> <A HREF=Logout>Logout</A>");
		out.println("</BODY></HTML>");
		out.close();
		return ;
	}

	Hashtable hash = HttpUtils.parseQueryString(query);

	String id = (String)Array.get((hash.get("id")),0);

	// if query does not specify id generate a blank form
	if (id==null) { 
		cominfo = new HtmlPage(Configuration.getProperty("companyInfoForm_blank"));
		cominfo.writeout(out);

		out.println("<HR> <A HREF=Logout>Logout</A>");
		out.println("</BODY></HTML>");
		out.close();
		return ;
	}

	Properties p = CompanyUtils.getCompanyInfo(db,id); 
	cominfo = new HtmlPage(Configuration.getProperty("companyInfoForm"));
	
	if(p==null){
		cominfo = new HtmlPage(Configuration.getProperty("companyInfoForm_blank"));
		cominfo.writeout(out);

		out.println("<HR> <A HREF=Logout>Logout</A>");
		out.println("</BODY></HTML>");
		out.close();
		return ;
	}  // proper info not available from database then blank form
 
	cominfo.writeout(out,p);  // generate form filled in with values

	out.println("<HR> <A HREF=Logout>Logout</A>");
	out.println("</BODY></HTML>");
	out.close();
	return;

} // doGet


// post method recieves the data from the form and process it. 
// adds , updates , removes companies from database
//
public void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {

	HttpSession session = request.getSession(false);

	// check validity of session

	if(session==null){
		response.sendError(HttpServletResponse.SC_BAD_REQUEST,"Unauthorized access attempted. You must login first!");
		return ;
	}
	
	// get all the name of the values of form fields 
	Enumeration params = request.getParameterNames();

	Properties p = new Properties();

	String paramName ;

	// for each parameter extract its corresponding value and put in
	// properties oject
	while(params.hasMoreElements()){	
		paramName = (String)params.nextElement();
		p.put(paramName,request.getParameter(paramName));
	}

	DatabaseConnection db;

	db=(DatabaseConnection)session.getValue(session.getId()+".databaseHandle");


	// the com object has all the functions to be performed on the
	// company table. set it up and perform action.
	COM company = new COM();

	company.setDatabase(db);
	company.setProperty(p);
	
	response.setContentType("text/html");
	PrintWriter out = response.getWriter();

	out.println("<HTML> <HEAD>"); 
	out.println("<TITLE>T&amp;P Cell IIT-Bombay</TITLE>");
	out.println(" </HEAD> ");
	out.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFCC\" LINK=\"#0000EF\" VLINK=\"#51188E\" ALINK=\"#FF0000\">");
	out.println("<H1> <U>T&amp;P Cell IIT-Bombay</U></H1>");


	String action = request.getParameter("submit");
	
	// try performing the requested action. 
	try {
		if(action.equals("Add")){
			company.add();
		}
		else if(action.equals("Remove")){
			company.remove();
		}
		else if(action.equals("Update")){
			company.update();
		}
	}
	catch (SQLException e){
		out.println("Error executing query!!\n" + e);
		try{
			db.rollback();
		}
		catch(SQLException err){
			System.out.println("Fatal Errors!! Give-up!" + err + "\n");
		}
		return;
	} // roll back if error occurs and inform user
	
	// else if succesful inform same.
	out.println("Action performed successfully!");
	out.println("<HR> <A HREF=Logout>Logout</A>");
	out.println("<HR> <A HREF=StaffServlet> Back </a>");
	out.println("</BODY></HTML>");
	out.close();
	return;
	
} // doPost 

public String getServletInfo() {
	return "T&P Server";
} 
		 
} //class

