

import java.io.*;
import java.sql.*;
import java.util.*;
import java.lang.reflect.*;

import javax.servlet.*;
import javax.servlet.http.*;

/** @author garg */
/* PPT Scheduler -- if called with no arguments it will generate a list
 * of all PPT's scheduled and will provide a link to see any of them.
 * Also a link at the bottom to add a new PPT will be provided. 
 * As soon as an PPT is scheduled it sends an email to all interested
 * students informing of the company being opening for registrations
 */
 
public class CompanyScheduler extends HttpServlet 
{
	
public void init(ServletConfig cfg) throws ServletException {

}

public void doGet(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException {
	
	HttpSession session = request.getSession(false);
	DatabaseConnection db=(DatabaseConnection) session.getValue(session.getId()+".databaseHandle");
	HtmlPage PPTPage ;
	PrintWriter out = response.getWriter();

	if(session==null){
		response.sendError(HttpServletResponse.SC_BAD_REQUEST,"Unauthorized access attempted. You must login first!");
		return;
	}

	response.setContentType("text/html");

	out.println("<HTML> <HEAD>"); 
	out.println("<TITLE>T&amp;P Cell IIT-Bombay</TITLE>");
	out.println(" </HEAD> ");
	out.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFCC\" LINK=\"#0000EF\" VLINK=\"#51188E\" ALINK=\"#FF0000\">");
	out.println("<H1> <U>T&amp;P Cell IIT-Bombay</U></H1>");
	

	String query = request.getQueryString();

	if(query==null || query.length()==0){
		generatePPTTable(out,db);
		generateInterviewTable(out,db);
		
		writeFooter(out);
		return;
	}
	

	Hashtable hash = HttpUtils.parseQueryString(query);
	 
	String[] type = (String[])hash.get("type");
	
	if(type==null || Array.get(type,0)==null || ((String)Array.get(type,0)).length()==0){
	
		generatePPTTable(out,db);
		generateInterviewTable(out,db);
		
		writeFooter(out);
		return;
	}
		  
	if(((String)Array.get(type,0)).toLowerCase().equals("ppt")){

		String[] action = (String[])(hash.get("action"));

		if(action!=null && Array.get(action,0)!= null && ((String)Array.get(action,0)).equals("new")){
			PPTPage = new HtmlPage(Configuration.getProperty("companyPPTForm_blank"));		
			PPTPage.writeout(out);
			writeFooter(out);
			return ;
		}
			
		String[] id = (String[])hash.get("id");

		if(id==null || Array.get(id,0)==null || ((String)Array.get(id,0)).length()==0){
			generatePPTTable(out,db);
			writeFooter(out);
			return;
		}
		else{
			Properties p = CompanyUtils.getPPTInfo(db,(String)Array.get(id,0));
			PPTPage = new HtmlPage(Configuration.getProperty("companyPPTForm"));		
			
			PPTPage.writeout(out,p);
			writeFooter(out);
			return;
		}
		
	}
	else if(((String)Array.get(type,0)).toLowerCase().equals("interview")){

		String[] action = (String[])hash.get("action");

		if(action!=null && Array.get(action,0)!= null && ((String)Array.get(action,0)).equals("new")){
                        PPTPage = new HtmlPage(Configuration.getProperty("companyInterviewForm_blank"));
                        PPTPage.writeout(out);
			writeFooter(out);
                        return ;
                }
				
		String[] id = (String[])hash.get("id");

		if(id==null || Array.get(id,0)==null || ((String)Array.get(id,0)).length()==0){
			generateInterviewTable(out,db);
			writeFooter(out);
			return;
		}
		else{
			Properties p = CompanyUtils.getInterviewInfo(db,(String)Array.get(id,0));
			PPTPage = new HtmlPage(Configuration.getProperty("companyInterviewForm"));		
			
			PPTPage.writeout(out,p);
			writeFooter(out);
			return;
		}
		
	}

} // doGet


public void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {

        HttpSession session = request.getSession(false);

        // check validity of session

        if(session==null){
		response.sendError(HttpServletResponse.SC_BAD_REQUEST,"Unauthorized access attempted. You must login first!");
                return ;
        }

        // get all the name of the values of form fields
        Enumeration params = request.getParameterNames();

        Properties p = new Properties();

        String paramName ;

	// for each parameter extract its corresponding value and put in
        // properties oject 
        while(params.hasMoreElements()){
                paramName = (String)params.nextElement();
                p.put(paramName,request.getParameter(paramName));
        }

        DatabaseConnection db;

	db=(DatabaseConnection)session.getValue(session.getId()+".databaseHandle");

	// the com object has all the functions to be performed on the
        // companies. set it up and perform action.
        COM company = new COM();

        company.setDatabase(db);
        company.setProperty(p);
        
	response.setContentType("text/html");
        PrintWriter out = response.getWriter();
 
        out.println("<HTML> <HEAD>");
        out.println("<TITLE>T&amp;P Cell IIT-Bombay</TITLE>");
        out.println(" </HEAD> ");
        out.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFCC\" LINK=\"#0000EF\" VLINK=\"#51188E\" ALINK=\"#FF0000\">");
        out.println("<H1> <U>T&amp;P Cell IIT-Bombay</U></H1>");
	
	String action = request.getParameter("submit");

        // try performing the requested action.
        try {
                if(action.equals("Add PPT")){
                        company.addPPT();
                }
                else if(action.equals("Remove PPT")){
                        company.removePPT();
                }
                else if(action.equals("Update PPT")){
                        company.updatePPT();
                }
		else if(action.equals("Add Interview")){
                        company.addInterview();
                }
                else if(action.equals("Remove Interview")){
                        company.removeInterview();
                }
                else if(action.equals("Update Interview")){
                        company.updateInterview();
                }	
        }
	catch (SQLException e){
                out.println("Error executing query!!\n" + e);
                try{
                        db.rollback();
                }
                catch(SQLException err){
                        System.out.println("Fatal Errors!! Give-up!" + err + "\n");
                }
                return;
        } // roll back if error occurs and inform user

	// else if succesful inform same.
        out.println("Action performed successfully!");
        out.println("<HR> <A HREF=Logout>Logout</A>");
        out.println("<HR> <A HREF=StaffServlet> Back </a>");
        out.println("</BODY></HTML>");
        out.close();
        return;

}

private void generatePPTTable(PrintWriter out,DatabaseConnection db){
		
	Properties list=null;

	try { 
		Table tab = new Table("ppt_sched",db);
		list = tab.multiquery("company_id","ppt_time", null ); 
	}
	catch(SQLException e){
		out.println("Error reading database: " + e + "\n");
	}
	out.println("<table valign=center width=80%>\n");	
	out.println("<tr>\n<td>PPT Date</td>\n<td>Company Id</td></tr>\n");
	out.println(CompanyUtils.format("<tr>\n<td><a href=CompanyScheduler?type=ppt&id=$1>$2</a></td>\n<td><a href=CompanyScheduler?type=ppt&id=$1>$1</a></td></tr>\n", list));
	out.println("</table>\n");	
	out.println("<HR> <A HREF=CompanyScheduler?type=ppt&action=new> Add PPT to database </A>");
	out.println("<A HREF=StaffServlet>Back</A>");
	out.println("<HR>");
	return;
}


private void generateInterviewTable(PrintWriter out, DatabaseConnection db){
		
	Properties list=null;

	try { 
		Table tab = new Table("round_sched",db);
		list = tab.multiquery("company_id","round_time", null ); 
	}
	catch(SQLException e){
		out.println("Error reading database: " + e + "\n");
	}
	out.println("<table valign=center width=80%>\n");	
	out.println("<tr>\n<td>Interview Date</td>\n<td>Company Id</td></tr>\n");
	out.println(CompanyUtils.format("<tr>\n<td><a href=CompanyScheduler?type=interview&id=$1>$2</a></td>\n<td><a href=CompanyScheduler?type=interview&id=$1>$1</a></td></tr>\n", list));
	out.println("</table>\n");	
	out.println("<HR> <A HREF=CompanyScheduler?type=interview&action=new> Add Interview to database </A>");
	out.println("<A HREF=StaffServlet>Back</A>");
	out.println("<HR>");
	return;
}


private void writeFooter(PrintWriter out){

	out.println("<HR> <A HREF=Logout>Logout</A>");
	out.println("<A HREF=StaffServlet>Back</A>");
	out.println("</BODY></HTML>");

}

public String getServletInfo() {
	return "T&P Server";
} 
		 
} //class

