
import javax.servlet.*;
import java.util.*;
import java.io.*;

/** @author garg */

/* 
 * The configuration class contains all the configuration data of the
 * servelet. It contains the file name of the configuration file. The
 * url of the database as well as the file name of the initial menu
 */
 
public class Configuration
{

private static String jdbcURL;
private static String initialFileName;
private static Properties props;

public Configuration(ServletConfig cfg){
	
	jdbcURL = cfg.getInitParameter("jdbcURL");
	initialFileName = cfg.getInitParameter("initialFile");
	String rcfile = cfg.getInitParameter("configFile");

	// load rc file as key,value pair in a properties object which
	// can be queried. exit if error occurs.
	try {
		FileInputStream fi = new FileInputStream(rcfile);
		props = new Properties();
		props.load(fi);
	}
	catch (IOException e){
		System.out.println("Error Loading Configuration: " + e + "\n" );
		System.exit(1);
	}
	
	// System.out.println("jdbc URL" + jdbcURL + "\n initialFile" + initialFileName +"\n configFile" + rcfile ) ;
}

public static String getDbURL(){
	return jdbcURL;
} // give database servers url

public static String getInitialFile(){
	return initialFileName;
} // give initial menu file

public static String getProperty(String prop){
	return props.getProperty(prop);
} // return the queried property 

}
