
import java.io.*;
import java.sql.*;
import java.util.*;
import java.lang.reflect.*;

import javax.servlet.*;
import javax.servlet.http.*;

/** @author garg */
/* This is the initial class that authenticates the user and then
 * initializes the session. It loads in the name of the configuration
 * file from the servlet init parameters and loads that file which
 * contains other parameters required by other servlets.
 * When a valid login takes place, it sends a standard menu file to the
 * user, the name of which is loaded from the init parameters.
 */
 
 
public class StaffServlet extends HttpServlet 
{

private	Configuration conf;

// constructor sets up the initial configuration which is shared by all
// servlets
public void init(ServletConfig cfg) throws ServletException {
	conf = new Configuration(cfg);
}	

// The get method works only if the session is a valid one. i.e the
// user has pressed the 'back' link provided in the pages.
//
public void doGet(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException {

	HttpSession session;

	if((session=request.getSession(false))==null){
		response.sendError(HttpServletResponse.SC_BAD_REQUEST,"Unauthorized access!!");
		return;
	}

	response.setContentType("text/html");
	PrintWriter out = response.getWriter();
	writePage(out);

}

// Post is the initial method used to connect to the deamon. It
// authenticates the user by logging him/her into the database and puts
// the database handle in the session object
//
public void doPost(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException {
	
	String loginName = (String) request.getParameter("loginname");
	String password = (String) request.getParameter("password");
	
	DatabaseConnection db;

	try{
		if(conf.getDbURL()!=null)
		  db = new DatabaseConnection(conf.getDbURL(),loginName,password);
		else
 		  db = new DatabaseConnection(loginName,password);
	}
	catch (SQLException e){	
		response.sendError(HttpServletResponse.SC_BAD_REQUEST,"Login Failed!");
		System.out.println("Error: " + e + "\n");
		return ;
	}
	
	HttpSession session;

	if((session=request.getSession(false))!=null){
		session.invalidate();
	}  // invalidate session if any exists  
	session = request.getSession(true); // and create a new one

	session.putValue(session.getId()+".databaseHandle",db);

	response.setContentType("text/html");
	PrintWriter out = response.getWriter();  // write out menu page

	writePage(out);

} // doPost

private void writePage(PrintWriter out){

	out.println("<HTML> <HEAD>"); 
	out.println("<TITLE>T&amp;P Cell IIT-Bombay</TITLE>");
	out.println(" </HEAD> ");
	out.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFCC\" LINK=\"#0000EF\" VLINK=\"#51188E\" ALINK=\"#FF0000\">");
	out.println("<H1> <U>T&amp;P Cell IIT-Bombay</U></H1>");

	try {
		HtmlPage first = new HtmlPage(conf.getInitialFile());
	
		first.writeout(out);
	
	}
	catch(FileNotFoundException e){ }
	
	out.println("<HR> <A HREF=Logout>Logout</A>");
	out.println("</BODY></HTML>");

}  // write initial menu page


public String getServletInfo() {
	return "T&P Server";
} 
		 
} //class


