import java.util.*;
import java.sql.*;

/** Class Table.java 
  * Written by kaustubh */

/* This is a generic class, denoting a table in the database. It is
 * designed to make the inserting and quering in a table simpler and
 * easier to write.
 * The datamembers of this class are :
 * 	tableName = name of the table;
 * 	conn = a connection to the db;
 * call the constructor with these two members 
 * 
 * The functions provided are:
 * 	columnInfo : returns the names of the columns in the table;
 *
 * 	insert(Properties row) throws SQLException : extracts the appropriate
 * 		column values from row and inserts the row in the table. Note
 * 		no updates are commited. Please commit them yourselves.
 *
 *	// written by smitao
 *	update(Properties row, String primary_key) throws SQLException : 
 *		updates the column values where the primary_key is given. The
 *		value of the primary_key must be present in the properties
 *		object row. again note that the updates are *NOT* commited by
 *		default. please commit them urselves.
 *
 * NOTE: Important Assumption
 *	the Property row _MUST_ have all its field names in LowerCase. The
 *	search is case sensitive.
 */

public class Table {
	String tableName;
	DatabaseConnection conn;
	ResultSet columnInfo;
	

	public Table(String name, DatabaseConnection
			conn)  throws SQLException {
		tableName = name.toUpperCase();
		this.conn = conn;
	}

	public ResultSet columnInfo() throws SQLException{
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
		return columnInfo;
	}

	public int insert(Properties row) throws SQLException{
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
		columnInfo.next();
		String colName = columnInfo.getString(1);
		String list = colName;
		String upd = getColValue(row,colName);
		while(columnInfo.next()) {
			colName = columnInfo.getString(1);
			list += ","+colName;
			upd += ","+getColValue(row,colName);
		}
		upd = "insert into "+tableName +" ("+ list +")"+ "values (" +
			upd+")";
		columnInfo.close();
		int i= conn.update(upd);
		System.err.println("Note: insert is not committed");
		return i;
	}
	
/*
 * This function is to remove the specified rows on the specified cols
 * --garg
 */
        public void remove(String condition) throws SQLException{
                conn.query("delete from " + tableName + " where "
                + condition );
                return ;
        }


	// this function is written by smitao 
	// i havent tested it so far
	// so i dont trust it. but it seems right

	public int update(Properties row, String primary_key) 
			throws SQLException {
/* 		System.out.println("I am here 1"+tableName);		 */
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
/* 		System.out.println("I am here");		 */
		columnInfo.next();
		String colName = columnInfo.getString(1);
		String upd = colName + "=" +getColValue(row,colName);
		String key_val = getColValue(row,primary_key);
		while(columnInfo.next()) {
			colName = columnInfo.getString(1);
			upd += ","+ colName +"=" +getColValue(row,colName);
		}
		upd = "update "+tableName + " set "+ upd+" where "+ 
			primary_key +"=" +key_val;
		columnInfo.close();
		int i = conn.update(upd);
		System.err.println("Note: update is not committed");
		return i;
	}
	

	// this function returns the value of item colName, put in appropriate
	// quotes depending on what type of field the column is.
	private String getColValue(Properties row,String colName) throws SQLException
	{
		String val=row.getProperty(colName.toLowerCase());
		if(val == null || val.length() == 0 )
			return "NULL";
		String type = columnInfo.getString(2);
		if(type.equalsIgnoreCase("varchar2") || type.equalsIgnoreCase("char") )
			return "'"+val+"'";
		else if(type.equalsIgnoreCase("date")){
			return "to_date('"+ val + "', 'DD-MM-YYYY')";
		else 
			return val;
	}

	// this function is unchecked and may have bughs!!
	// dont use it
	public void query(Properties row, String primary_key) throws SQLException
	{
		columnInfo = this.conn.query("select column_name, data_type from cols where table_name = '"
				+tableName+"'");
		String key_val = row.getProperty(primary_key);
		String query = "select * from "+ tableName+" where "+
			primary_key+"='"+key_val+"'";
		ResultSet r=conn.query(query);
	 	// row.clear();

		// this exception is thrown when the result set contains no rows.
		if(!r.next()) { 
			throw new SQLException("No rows found","",5032); }
		while(columnInfo.next())
		{
			String colName = columnInfo.getString(1);
/* 			System.err.println(colName); */
			String str=r.getString(colName);
			if(str != null)
				row.put(colName,str);
			else
				row.put(colName,"");
		}
		row.list(System.err);
		columnInfo.close();
	}

	// for some reason the query function requires a property object. 
	// so here is a query function which takes only the key-value and 
	// returns the row in a property object. It uses the previous function 
	// which is retained for compatiblity.
	public Properties query(String key_val, String primary_key) throws SQLException
	{
		Properties row = new Properties();
		row.put(primary_key,key_val);
		query(row,primary_key);
		return row;
	}

	public Properties multiquery(String id,String value, String condition) 
		throws SQLException
	{
		String query = "select "+ id +","+ value +" from "+tableName;
		if(condition!=null)
			query += " " + condition;
		ResultSet rs = conn.query(query);
		Properties list = new Properties();
		while (rs.next())
			list.put(rs.getString(id) ,rs.getString(value));
		return list;
	}
			
	// smitao added this 
	// & i modified it to suit my needs
	// dont know why she added it here
	public boolean constr(Properties row) throws SQLException {
		row.list(System.err);	
 		String com_id = row.getProperty("company_id");
		String stud_id = row.getProperty("student_id");
		ResultSet qry = this.conn.query("select cons from Cons where cons_cat = 'STR'");
		qry.next();
		String upd = qry.getString(1);
		upd = replace_string(upd,"$1",stud_id);
		upd = replace_string(upd,"$2",com_id);
		System.err.println(upd);
		ResultSet rs = conn.query(upd);
		rs.next();
		if(rs.getString(1).equalsIgnoreCase("Y"))
			return true;
		else 
			return false;
	}

	// this function replaces a substring in the given string by 
	// another given substring.
	String replace_string(String main, String rep, String rep_by)
	{	
	  int i;
	  String temp1,temp2,temp3;
	  temp3=main;
	  i= main.indexOf(rep);
	  while(i != -1)
	  {
	  temp1 = temp3.substring(0,i);
	  temp2 = temp3.substring(i+rep.length());
	  temp3=temp1+"'"+rep_by+"'"+temp2;
	  i= temp3.indexOf(rep);
	  }
	  return temp3;
	  }
	
}
