## This shell script enables the user of the package to initialise the 
## settings according to his requirements.
## -------------------------------------------------------------------
## It also leads to the process of installation and compilation 
## of the source files which is carried out by running 'make'
## -------------------------------------------------------------------
## All copyrights reserved. Any duplication may lead to severe legal 
## consequences.

clear 
echo 'Welcome to The Central Authentication Server Software Package.'
echo 
echo 'You are now about to begin the installation of this package on your
system. Make sure youve read all the details of the readme files before
running this script.'
echo

#echo "Press Y to continue/N to abort\n" 
while true
do
	echo 'Press Y to continue/N to abort'
	read e
	if (test $e = 'Y') || (test $e = 'y')
	then
		break
	elif (test $e = 'N') || (test $e = 'n')
	then
		exit 
	else 
		continue
	fi
done

#echo "Enter the directory root where you want to install the package (Current
#Directory is the default)..."
echo
echo 'Enter the COMPLETE server name where you will run the CAS...'
read servername

echo
echo 'Enter the port number at which SSL is running on your server...'
read port

echo
echo 'Enter the domain name of the server...'
read domain

echo
echo 'Enter the appurl  of the server...'
read appurl



echo
echo 'Enter the file (complete path) in which the secret key of the server will
be stored...'
read skey

echo
echo 'Enter the directory containing the public keys of the applications...'
read pkey

echo 
echo 'Enter the JDBC driver...'
read driver

echo
echo 'Enter the JDBC URL...'
read url

echo 
echo 'Enter the root login for the database...'
read login

echo 
echo 'Enter the root password...'
read passwd

echo "--------------------------------------------------------------------"
echo
echo 'YOUR SERVER CONFIGURATIONS...'
echo 
echo 'Enter the servlet path for your apache server...'
read servlet

echo 
echo 'Enter the path for html docs configured for your server...'
read html

## Generate the config file which will be used by all other files

echo 'class CASConfig {' > CASConfig.java
echo '// The servername and domain ' >> CASConfig.java
echo 'public static final String servername = "'$servername':8080" ;' >> CASConfig.java
echo 'public static final String servletroot = "https://'$servername':'$port'/servlets" ;' >> CASConfig.java
echo 'public static final String serverssl = "'$servername':'$port'/";' >> CASConfig.java
echo 'public static final String domainname = "'$domain'"; ' >> CASConfig.java
	

echo 'public static final String secretkey = "'$skey'";' >> CASConfig.java
echo 'public static final String AppPublickey = "'$pkey'/clientPublicKey" ;' >> CASConfig.java

echo '// The JDBC driver' >> CASConfig.java
echo 'public static final String jdbcDriver = "'$driver'";' >> CASConfig.java
echo 'public static final String jdbcURL = "'$url'?user='$login'&password='$passwd'";' >> CASConfig.java
echo 'public static final String dbLogin = "'$login'";' >> CASConfig.java
echo 'public static final String dbPwd = "'$passwd'";' >> CASConfig.java

echo '// The links to servlets' >> CASConfig.java
echo 'public static final String SecureServ = "'$servername':'$port'/CAS/authentication_secure.shtml";' >> CASConfig.java 
echo 'public static final String InsecureServ = "'$servername':'$port'/CAS/authentication_insecure.shtml";' >> CASConfig.java 
echo 'public static final String cur_session = "cur_sess";' >>CASConfig.java
echo '	public static final String indexapp = "indexapp";' >>CASConfig.java

echo '	public static final String netaccess = "netaccess";' >>CASConfig.java

echo  '   public static final String sysadd = "sysadd" ; ' >>CASConfig.java

echo '	public static final String roleperms = "rollperms" ; ' >>CASConfig.java

echo  ' public static final String super_root_tbl = "super_root_tbl";' >>CASConfig.java

echo 'public static final String logs = "logs" ;	' >>CASConfig.java
echo 'public static final String appurl  = "'$appurl'" ;	' >>CASConfig.java




echo '}' >> CASConfig.java

## The 2nd config file...

echo 'class CASConf {' > CASConf.java
echo '// The servername and domain ' >> CASConf.java
echo 'public static final String servername = "'$servername':8080" ;' >> CASConf.java
echo 'public static final String servletroot = "https://'$servername':'$port'/servlets" ;' >> CASConf.java
echo 'public static final String serverssl = "https://'$servername':'$port'/";' >> CASConf.java
echo 'public static final String domainname = "'$domain'"; ' >> CASConf.java
	

echo 'public static final String secretkey = "'$skey'";' >> CASConf.java
echo 'public static final String AppPublickey = "'$pkey'/clientPublicKey" ;' >> CASConf.java

echo '// The JDBC driver' >> CASConf.java
echo 'public static final String jdbcDriver = "'$driver'";' >> CASConf.java
echo 'public static final String jdbcURL = "'$url'?user='$login'&password='$passwd'";' >> CASConf.java
echo 'public static final String dbLogin = "'$login'";' >> CASConf.java
echo 'public static final String dbPwd = "'$passwd'";' >> CASConf.java
echo '// The links to servlets' >> CASConf.java
echo 'public static final String SecureServ = "'$servername':'$port'/CAS/authentication_secure.shtml";' >> CASConf.java 
echo 'public static final String InsecureServ = "'$servername':'$port'/CAS/authentication_insecure.shtml";' >> CASConf.java 

echo 'public static final String cur_session = "cur_sess";' >>CASConf.java
echo '	public static final String indexapp = "indexapp";' >>CASConf.java

echo '	public static final String netaccess = "netaccess";' >>CASConf.java

echo  '   public static final String sysadd = "sysadd" ; ' >>CASConf.java

echo '	public static final String roleperms = "rollperms" ; ' >>CASConf.java

echo  ' public static final String super_root_tbl = "super_root_tbl";' >>CASConf.java

echo 'public static final String logs = "logs" ;	' >>CASConf.java

	


echo '}' >> CASConf.java


## The Config file in java has been created now.
## Create the corresponding class file using javac compiler..

echo 
echo 'YOUR CONFIG FILE IS NOW BEING CREATED AND COMPILED'

javac -classpath $CLASSPATH CASConfig.java
javac -classpath $CLASSPATH CASConf.java

cp CASConfig.* ../config/
cp CASConf.* ../config/

## CHange the classpath to contain bin files
CLASSPATH=$CLASSPATH:`pwd`'/../bin/:.:'`pwd`':/../config/:'`pwd`'/../pkgs/'
CLASSPATH=$CLASSPATH:`pwd`'../pkgs/cryptix/jardir/:'`pwd`'/../pkgs/cryptix/classes:'
CLASSPATH=$CLASSPATH:`pwd`'../pkgs/cryptix'
export CLASSPATH

# Let the java coded remain in install for checking up later on, if required

echo 'CONFIGURATION PROCESS IS OVER...! YOU ARE NOW SET TO USE THE CONFIG FILE.'

echo
echo 'Compilation process beginning.............'
echo



## Now compile the rest of the java files
cp ../src/java/CAS/*.java ../bin/
javac -classpath $CLASSPATH ../bin/*.java 
rm ../bin/*.java

cp ../src/java/CAS-CLIENT/*.java ../bin/
javac -classpath $CLASSPATH ../bin/*.java 
rm ../bin/*.java

cp ../src/java/SYSAD-FUNCTIONS/*.java ../bin/
javac -classpath $CLASSPATH ../bin/*.java 
rm ../bin/*.java

echo 'Sucessfully Compiles..!!! '
echo 
echo 'YOU MAY NOW START UP YOUR SERVER AND RUN CAS ON THE PORT AT WHICH SSL IS RUNNING'

