import java.io.*;
package CAS.CAS_CLIENT;
import java.util.*;
import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;

import CASConfig;
import App_CasConnection;

/** The following class is a conglomeration of all the functions that will 
 * be performed on the side of an application in relation with authenticating
 * and authorizing its users; There are 3 functions to accomplish the same.
 */

public class MainFunction  {

   /** Function to check for authenticity of the connecting user 
	*	Signature of the function :-
	* 		  
	* 		 doAuthentication (<request>, <printwriter>, <App-ID>, 
	* 		 	     <App-PrivateKey-File>, <Server-PublicKey-File>, 
	* 		 	     <boolean-for-wanting-info-on-user>, <mode>,
	* 		 	     <hashtable-for-storing-info>)
	* 		 	 
	*/
	 
   public static boolean doAuthentication (HttpServletRequest req, PrintWriter out,
			 String clientId,String clientSK,String serverPK,boolean want_info,
			 String mode,Hashtable ht){  
		 // mode is the token for knowing whether the more secure password is 
		 // required for authentication  it can take two values : "secure" 
		 // or "insecure"
		 int i;
		 boolean flag = false;
		 Hashtable ht1 = new  Hashtable();
		 try {
         	//res.setContentType("text/html");
         	URL url=null;
         	url=new URL("http://"+CASConfig.appurl);
         	Cookie[] cooki=req.getCookies();
         	String cuki="";
			try{
         	for (i=0;i<cooki.length;i++) {
         	   if(cooki[i].getName().equals("Challenge")) 
					cuki=cooki[i].getValue();
			}
			}catch(Exception e){}
			if(cuki.equals("")){
				  ht.put("response","false");
				out.println("<html><title>Not authenticated yet</title>");
				out.println("<body bgcolor=00ffcc text=000cff><h1>You have not been authenticated !</h1>");
				out.println("<center>");
            	out.println("You have not yet been authenticated by the Central Authentication Server.<p>");
				out.println("Click here to get yourself authenticated.<p><br>");
				if (mode.equals("secure"))
                	out.println("<a href=https://" + CASConfig.SecureServ + ">Click here</a>");
				else
			    	out.println("<a href=https://" + CASConfig.InsecureServ + ">Click here</a>");	 
			

				//out.println("<a href=https://" + CASConfig.MainPage + "> CLICK </a>");
				
				out.println("</center></body></html>");				  
			}
				
			else{
        	      App_CasConnection appcas= new App_CasConnection(clientId,// application id
        	           clientSK, // client's secret key path
        	           serverPK, // server's public key path
                  	   url);    
		 	if(want_info)
            	appcas.registerRequest("getUserInfo");
         		appcas.registerRequest("cookie",cuki); 
		 		appcas.registerRequest("appId",clientId);
         		appcas.PostObject1("/servlet/App_CasInterface");
		 		ht1 = appcas.gettable();
				Enumeration data = ht1.keys();
				while(data.hasMoreElements()){
					 String str = (String) data.nextElement();
					 if ((str.equals("getUserInfo")) || (str.equals("cookie")) || (str.equals("appId")) || (str.equals("response"))){
					 }
					 else{
						  ht.put(str,ht1.get(str));
					 }
				}
				if (ht1.get("response").equals("true"))
					 flag = true;
		 	if(!ht1.get("response").equals("true")){
				 flag = false;
				out.println("<html><title>Not authenticated yet</title>");
				out.println("<body bgcolor=00ffcc ><h1> <center>");
            	out.println("You have not been authenticated. Click here to authenticate yourself.");
			if (mode.equals("secure"))
                out.println("<a href=https://" + CASConfig.SecureServ + ">Click here</a>");
			else
			    out.println("<a href=https://" + CASConfig.InsecureServ + ">Click here</a>");	 	
				
				out.println("</center></body></html>");
			}
	}
		}catch (Exception e) {return false;}
		 return flag;
   }

   /** Function to get info about the user of the application
	*	Signature of the function :-
	*	
	*   	getData(<App-ID>, <App-PrivateKey-File>, <App-ServerKey-File>)
	*   	     (Returns ResultSet)
	*/
   
   public static Hashtable getData(String clientId,String clientSK,String 
			 serverPK,String query){
		URL url =null;
		Hashtable ht = new Hashtable();
		try{
			 url = new URL("http://"+CASConfig.appurl);
		App_CasConnection connect = new App_CasConnection(clientId,clientSK,serverPK,url);
		connect.registerQuery(query);
		connect.PostObject2("/servlets/App_DataInterface");
		ht = connect.getResultable();
        } catch (Exception e){}
		
		return ht;
   }
   
   /** Function to inform the CAS that the user is logging out and that 
	* the session is now over
	*    Signature of the function :-
	*    
	* 			logout(<request>, <printwriter>, <ID-of-Application>, 
	* 					<Appliaction-Privatekey-File>, 
	* 					<Server-Publickey-File>,)
	*/
   
   public static void logout(HttpServletRequest request, PrintWriter pw, 
			 			String clientId, String clientSK, String serverPK) {
	   URL url = null;
	   int i;
	   try{
			url = new URL("http://"+CASConfig.appurl);
	        App_CasConnection connect = new App_CasConnection(clientId,clientSK,serverPK,url);
	    	Cookie[] cuki = request.getCookies();
			String cukki="";
			for(i=0;i<cuki.length;i++){
				 if(cuki[i].getName().equals("Challenge"))
					  cukki = cuki[i].getValue();
			}
			file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/flog","in1 "+ cukki);
		    connect.registerCookie(cukki);
			connect.PostObject3("/servlets/App_Logout");
	   }catch (Exception e) {file1.write("/home/btech/ug98/hkgupta/project/install/apache/CAS/fer","ertpt");}
	   try{
	   //PrintWriter pw = response.getWriter();
	   pw.println("<HTML><HEAD><TITLE>LOGGED OUT ! </TITLE></HEAD>");
	   pw.println("<BODY>");
	   pw.println("<CENTER>");
	   pw.println("<B> U HAVE BEEN LOGGED OUT </B>");
	   pw.println("</CENTER>");
	   pw.println("</BODY>");
	   pw.println("</HTML>");
	   }catch (Exception e) {}
  	}
}
		 
