import java.io.*;
import java.lang.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** This program is a simple HTTP SQL Query Engine . 
 * It implements  function like insert data , run query, delete dat and help .
 * @author Rajendra Sansare 
 * */
public class ConHTMLservlet extends HttpServlet implements SingleThreadModel {
	 public Connection con;
	 private String schema;
	 PreparedStatement pstmt;
	 ResultSet rs;
	 ResultSetMetaData rsmd;


	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  
		  String username;
		  String password;
		  
		  username =  getInitParameter("username");
		  schema = getInitParameter("schema");
		  password = getInitParameter("password");
		  
		  if ( username.equals(null) || password.equals(null) ) {
			   throw new UnavailableException (this, "No Initialization Arguments" +
					"supplied to get the Database Connection .");
		  }
		  
		  try {
			   DriverManager.registerDriver( new oracle.jdbc.driver.OracleDriver());
			   DriverManager.setLoginTimeout(1);
			   con = DriverManager.getConnection( "jdbc:oracle:thin:@everest:1521:GEN", username, password);
		  } catch (SQLException sqle) {
			System.out.println("A problem occured while trying to connect to Databse . Please try again .");
			sqle.printStackTrace();;
		  }
	 }




	 public void execQuery(String query, PrintWriter pw) {
		  query = query.toUpperCase();
		  
		  try {
		  pstmt = con.prepareStatement(query);
		  rs = pstmt.executeQuery();
		  rsmd = rs.getMetaData();
		  
		  /* */
		  pw.println( " Number of Columns : " + rsmd.getColumnCount());
		  for (int k = 1; k <= rsmd.getColumnCount(); k++) {
			   pw.println("<br> Name of Col : " + rsmd.getColumnLabel(k) + "  ");
			   switch (rsmd.isNullable(k)) {
					case rsmd.columnNoNulls: 
						 pw.println(k +" Does not allow Null values");
						 break;
					case rsmd.columnNullable:
						 pw.println(k +" Allows null Values");
						 break;
					case rsmd.columnNullableUnknown:
						 pw.println(k +" Nullability Unknown");
						 break;
			   }
		  }
		  /* */


		  
		  pw.println("<TABLE width=100% border width=75% nosave><tr>");
		  for (int i = 1; i <= rsmd.getColumnCount(); i++) {
			   pw.println("<td>" + rsmd.getColumnName(i) + "</td>");
		  }
		  pw.println("</tr>");
		  while (rs.next()) {
			   pw.println("<tr>");
			   for( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
					pw.println("<td>" + rs.getString(rsmd.getColumnName(i)) + "</td>");
			   }
			   pw.println("</tr>");
		  }
		  pw.println("</TABLE>");
		  } catch (SQLException sqle) {
			   pw.println("A problem occured while executing your request .Please try again.");
			   System.out.println("SQLException in execQuery" + sqle);
			   sqle.printStackTrace();
		  }
	 }
		  
/*2. Insert : 
     The user types in a table name and you find the fields from the database
     metadata, and prompt the user to enter values for each field.  Then
     insert the data entered. */
	 
	 public void getTableFields(String tablename, String actionurl, PrintWriter pw) throws NullPointerException {
		  DatabaseMetaData dbmd = null;
		  tablename = tablename.toUpperCase(); 
		  
		  try {
		  if (tablename.equals(null)) throw new NullPointerException();
		  dbmd = con.getMetaData();
		  rs = dbmd.getColumns("%",schema,tablename,"%");
		  rsmd = rs.getMetaData();
		  
		  pw.println("<FORM NAME=FORM1 method=get action=" + actionurl + ">");
		  pw.println("<TABLE width=100% border=1 >");
		  pw.println("<tr><td>"+ rsmd.getColumnName(4) + "</td><td>" + rsmd.getColumnName(6) + "</td><td>" + rsmd.getColumnName(18) + "</td><td>  ENTER Field Values. " +"</td></tr>");
		  
		  int i=0;
		  pw.println("Table Name <SELECT name=" + i++ + "><option value=" + tablename + ">" + tablename +" </SELECT><BR>");
		  while (rs.next()) {
			   pw.println("<tr><td>" + rs.getString(4) + "</td><td>" + rs.getString(6) + "</td><td>" + rs.getString(18) + 
					"</td><td><input type=textbox name=" + i++ + rs.getString(6)  + " size=30 value=>" + "</td></tr>");
		  }
		  pw.println("</TABLE>");
		  pw.println("<input type=submit value=Submit>");
		  pw.println("<input type=reset>");
		  pw.println("</FORM>");
		  
		  } catch (SQLException sqle) {
			   System.out.println("SQLException in Help function" + sqle);
			   sqle.printStackTrace();
			   pw.println("A problem occured while getting the fields of the table <BR>");
			   pw.println("Unable to service your request at this time.");
			   pw.println("Please try again");
		  } catch (NullPointerException npe) {
			   pw.println("<b> Please enter some specific TABLE name.</b>");
		  }
	 }
	 
	 /*
3. Delete :
     Get table name and a delete condition from user and execute.
	 */
	 public void deleteData(String tablename, String condition, PrintWriter pw) {
		  String query = "delete from " + tablename.toUpperCase() + " where " + condition.toUpperCase();
		  try{
		  pstmt = con.prepareStatement(query);
		  pw.println(" " + pstmt.executeUpdate() + " row(s) have been deleted .");
		  } catch (SQLException sqle) {
			   System.out.println("SQLException in deleteData" + sqle);
			   sqle.printStackTrace();
			   pw.println("A problem occured while deleting the tuples of the table.<BR>");
			   pw.println("Unable to service your request at this time.");
			   pw.println("Please try again");
		  }
	 }


	 /*
4. Help : 
     Get table name from user and display all the information about the table.
     An empty string says show information about all tables.
	 */

	 public void help(String tablename, PrintWriter pw) {
		  DatabaseMetaData dbmd = null;
		  
		  if (tablename.equals("")) tablename = "%";
		  try {
		  dbmd = con.getMetaData();
		  tablename = tablename.toUpperCase();
		  rs = dbmd.getColumns("%",schema,tablename,"%");
		  rsmd = rs.getMetaData();
		  pw.println("<TABLE width=100% border=1  cellspacing=2> <tr>");
		  for( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
			   pw.println("<td>" +  rsmd.getColumnName(i)  + "</td>");
		  }
		  pw.println("</tr>");
		  while (rs.next()) {
			   pw.println("<tr>");
			   for( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
					pw.println("<td>" + rs.getString(i) + "</td>");
			   }
			   pw.println("</tr>");
		  }
		  pw.println("</TABLE>");
		  } catch (SQLException sqle) {
			   System.out.println(" SQLException in Help function " + sqle);
			   sqle.printStackTrace();
			   pw.println("A problem occured while getting the Column information of the table.<BR>");
			   pw.println("Unable to service your request at this time.");
			   pw.println("Please try again");
		  }
	 }

	 /*  */
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();
		  
		  int menu = Integer.parseInt(request.getParameter("menu"));
		  String userinput = request.getParameter("querytable");  
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/ConHTMLservlet"; /* name of the servlet */

		  /* 
		   * Note the getParameter(string) method  returns a string with "" if no value is set .
		   * pw.println( "User input : " + userinput + "  " + userinput.equals("") + "<BR>");
		   */
		   
		  try {
		  if (userinput.equals("") && (menu != 4)) throw new NullPointerException();
		  
		  userinput = userinput.toUpperCase();
		  switch (menu) {
				case 1: 
					 pw.println("<h1>Result of Query</h1>");
					 execQuery(userinput, pw);
					 break;
				case 2:
				     pw.println("<h1>Please enter values into the fields according to the data type.</h1>");
					 getTableFields(userinput, actionurl, pw);
					 break;
				case 3:
					 StringTokenizer st = new StringTokenizer(userinput);
					 String tabname = st.nextToken();
					 
					 String condition = "";
					 while (st.hasMoreTokens()) {
					 	  condition += "    " +  st.nextToken();
					 }
					 if (condition.equals("")) throw new NullPointerException();
					 deleteData(tabname.toUpperCase(), condition.toUpperCase(), pw);
					 break;
				case 4:
					 pw.println("<h1> Help Mode Result </h1>");
					 help(userinput, pw);
					 break;
				default: 
		  }
		  } catch (NullPointerException npe) {
			   pw.println("You have not entered a tablename and/or condition. Please try again."); 
		  }
		  pw.close();
	 }


	 /* */
	 public int getTableColumnCount(String tablename) {
		  int numcols = -1; 
		  try {
		  pstmt = con.prepareStatement("SELECT * FROM " + tablename);
		  rs = pstmt.executeQuery();
		  rsmd = rs.getMetaData();
		  numcols = rsmd.getColumnCount();
		  
		  } catch (SQLException sqle) {
			   System.out.println(" SQLException in getColumnCount() function " + sqle);
			   sqle.printStackTrace();
		  }
		  return numcols;
	 }

	 /* HTML  version */ 
	 public boolean[] isColNullable(String tablename, PrintWriter pw) throws NullPointerException {
		  boolean[] boolresult = null;
		  tablename = tablename.toUpperCase(); 
		  try {
		  if (tablename.equals("")) throw new NullPointerException();
		  pstmt = con.prepareStatement("SELECT * FROM " + tablename);
		  rs = pstmt.executeQuery();
		  rsmd = rs.getMetaData();
		  
		  boolresult = new boolean[rsmd.getColumnCount()];
		  
		  for (int k = 1; k <= rsmd.getColumnCount(); k++) {
			   switch (rsmd.isNullable(k)) {
					case rsmd.columnNoNulls: 
						 //" Does not allow Null values"
						 boolresult[k - 1] = false;
						 break;
					case rsmd.columnNullable:
						 //" Allows null Values"
						 boolresult[k - 1] = true;
						 break;
					case rsmd.columnNullableUnknown:
						 //" Nullability Unknown"
						 boolresult[k - 1] = false;
						 break;
			   }
		  }
		  } catch (SQLException sqle) {
			   pw.println("SQLException in execQuery" + sqle);
			   sqle.printStackTrace();
		  } catch (NullPointerException npe) {
			   pw.println("<B> No tablename given as input </b>");
		  }
		  return boolresult;
	 }

	 public String InsertData(String insertdata) {
		  String insertresult = "";
		  try{
		  pstmt = con.prepareStatement(insertdata);
		  insertresult =" " + pstmt.executeUpdate() + " row has been inserted .";
		  return insertresult;
		  } catch (SQLException sqle) {
			   System.out.println("SQLException in InsertData" + sqle);
			   return "Error while inserting data into the database";
		  }
	 }

	 
	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		   response.setContentType("text/html");
		   PrintWriter pw = response.getWriter();
		   
		   pw.println("<HTML><HEAD><TITLE>");
		   pw.println(" Result of : Insert Data Into the Database. </TITLE></HEAD>");
		   pw.println("<BODY bg=#877876>");
		   pw.println("<HR>");

		   try {
		   String tablename = request.getParameter("0");
		   
		   /* It is assured that tablename will not be null , as the error checking for tablename has been done in the Menu interface ConHTML */

		   int arrindex = 0;  
		   int numcols = getTableColumnCount(tablename);
		   String[] fields = new String[numcols + 1];

		   String type = "", param = "";
		   
		   Enumeration e = request.getParameterNames(); 
		   while (e.hasMoreElements()) {
				String pname = (String)e.nextElement();
				arrindex = Integer.parseInt(pname.substring(0,1));
				type = pname.substring(1);
				param = request.getParameter(pname);
				if (type.equals("VARCHAR2") || type.equals("CHAR")) 
					 param = "'" + param + "'";
				
				fields[arrindex] = param;
		   }
		   
		   /* Error check for Nullable values */
		   /* Please check for length of the data that can be inserted for each field */
		   boolean[] boolresult;
		   boolresult = isColNullable(fields[0], pw);

		   param = "INSERT INTO " + fields[0] + " VALUES("; 
		   for (int i=1 ; i < numcols; i++) {
				param  += fields[i] + ",";
				if ( fields[i].equals("''") ) {
					 if ( !boolresult[i - 1] ) {
						  pw.println( "<b> In Row number " + i + "</b><br>" );
						  throw new  NullPointerException();
					 }
				}
		   }
		   param +=  fields[numcols] + ")";
		   param = param.toUpperCase();
		   pw.println("<BR> Your Insert Query is as : <BR>" + param + "<br>");
		   /*  */
		   pw.println( InsertData(param) );
		   pw.println("<HR> <ADDRESS>");
		   pw.println(" copyright &#169; 2000 Rajendra Sansare </ADDRESS><HR></BODY></HTML>");
		   } catch (NullPointerException npe) {
				pw.println("<BR> <b>You have entered a null value for an attribute which does not allow Null values .</b> <BR>");
		   		pw.println("</ADDRESS><HR></BODY></HTML>");
		   }
		   pw.close();
	 }

	 /* Clean up the SQL database connection */ 
	 public void destroy() {
		  try {
			   con.close();
		  } catch (SQLException e) {
			   while (e != null) {
					log("SQLException: " + e.getSQLState() + '\t' + e.getMessage() + '\t' + e.getErrorCode() + '\t');
					e = e.getNextException();
			   }
		  } catch (Exception e) {
			   e.printStackTrace();
		  }
	 }
			   
	 /* Servlet Information */
	 public String getServletInfo() {
		  return " Database Connection Servlet  Author : Rajendra Sansare Copyright 2000 ";
	 }
}
