import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** This class shows the Forward_Email entityset details like servicetag and csremailid and
 * provides an interface to assign a new service  to the csr to handle .
 * @author Rajendra Sansare 
 */

public class AssignCSRService extends HttpServlet implements SingleThreadModel {
	 
	 private SQLEngine sfe;
	 private HTMLtags htag;

	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  sfe  = new SQLEngine();
		  htag = new HTMLtags();
	 }
	 

	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/"; /* name of the servlet */
		  String service = actionurl + "ServiceBasketServlet?";
		  String editcsr = actionurl + "EditCSRServlet?";
		  actionurl += "AssignCSRService"; /* name of the servlet */


		  String query = "";
		  htag.header(pw);
		  
		  pw.println("<FORM  method=POST action="+actionurl+">");
		  /** %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */                                          

		  /** Note */
		  pw.println("<font color=#ff0000><b> NOTE </b></FONT><BR>");
		  pw.println("<FONT color=#ffffff><H1>&nbsp;Maximum limit of tag is 10 characters and that of email ID is 30 .</H1>");
		  pw.println("</font><HR><BR>");
		  
		  pw.println("<a href="+ editcsr + ">Add/Edit CSR  Personnel </a><BR>");
		  pw.println("<a href="+ service + ">Add/Edit Services</a><BR><HR><BR>");
		  
		  //query = "SELECT * FROM Forward_Email";
		  query = "SELECT '<input type=radio name=editdel value=edi' || email_id || ':' || tag || '>  Edit' ,"
			   + "'<input type=radio name=editdel value=del' || email_id || ':' || tag || '>  Del', tag, email_id "
			   + " FROM Forward_Email";
		  pw.println("<B><FONT COLOR=#FFFFFF> Service assigned to CSR are </FONT></B><BR>");
		  sfe.execQuery(query,pw);
		  pw.println("<FONT color=#ffffff><input type=radio name=editdel checked value=new checked> Assign New Service </font><BR>"); 
		  printTable(pw);
		  
		  pw.println("<CENTER><input type=submit value=Submit>");
		  pw.println("<input type=reset  value=Reset></CENTER>");
		  pw.println("</FORM>");

		  htag.footer(pw);
	 }
	 
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();

		  htag.header(pw);
		  pw.println("<B> Received </B><BR>");
		  
		  String editdelnew = request.getParameterValues("editdel")[0];
		  String actype = editdelnew.substring(0,3);
		  
		  pw.println("<B>" + editdelnew + "</B><BR>");
		  pw.println("<B>" + actype + "</B><BR>");

		  String sertag = request.getParameterValues("sertag")[0];
		  String csremailid = request.getParameterValues("csremailid")[0];
		  
		  if (actype.equals("new")) {
			   InsertintoTables(sertag,csremailid,pw);
		  } else {
			   String email = editdelnew.substring(3,editdelnew.indexOf(":"));
			   String tag = editdelnew.substring(editdelnew.indexOf(":")+1);
			   String upstmt = "";
			   if (actype.equals("edi")) {
					pw.println(" Edit function <BR>");
					upstmt = "UPDATE Forward_Email SET email_id='"+csremailid.trim()
						 +"', tag='"+sertag+"' where  tag='"+ tag + "' and email_id='"+email.trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   } else {
					pw.println(" Del function <BR>");
					upstmt = "DELETE FROM Forward_Email where tag='"+ tag + "' and email_id='"+email.trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   }
		  }
		  
		  htag.footer(pw);
	 }

	 /** inserts the new values of csremailid and the service tag assigned to him 
	  * into the database. 
	  * @param string sertag - service tag 
	  * @param string csremailid - emailid of the csr
	  * @param Printwriter pw 
	  */ 
	 public void InsertintoTables(String sertag, String csremailid,PrintWriter pw) {
		  String instmt = "";
		  boolean anynullval = true; 
		  
		  if (csremailid.equals("") || csremailid.equals(null)) anynullval = false;
		  if (sertag.equals("") || sertag.equals(null)) anynullval = false;

		  if (anynullval) {
			   pw.println("<font color=#ffffff> For Table Forward Email :<br>"); 
			   instmt = "INSERT INTO Forward_Email VALUES ('"+ sertag.trim() +"','"
					+ csremailid.trim() +"')"; 
			   pw.println(" values " + sertag + "&nbsp;  " + csremailid + " has been inserted<Br>");
			   pw.println( sfe.InsertData(instmt) + "</font>" );
		  } else {
			   // do nothing
			   pw.println("<font color=#ffffff> No value has been inserted as a null input is given </font><br>"); 
		  }
	 }
	 
	 /** @param PrintWriter pw  */
	 public void printTable(PrintWriter pw) {
		  pw.println("<BR><BR>");
		  pw.println("<center><table BORDER=0 CELLSPACING=2 CELLPADDING=2 COLS=1 WIDTH=75% BGCOLOR=#CCCCCC >");
		  pw.println("<tr><td><center>");
		  pw.println("<table BORDER=0 COLS=2 WIDTH=100% BGCOLOR=#B080FF NOSAVE >");
		  pw.println("<tr NOSAVE>");
		  pw.println("<td NOSAVE>");
		  pw.println("<center><font color=#000000> Service  Tag </font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> CSR E-mail ID </font></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  
		  pw.println("<tr>");
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=sertag size=27 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=csremailid size=27 value=></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table>");
		  pw.println("</center>");
		  
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table></center>");
		  pw.println("<HR>");
	 }
}
