import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

/** This class is an interface for getting Customer Information . 
 * @author Rajendra Sansare 
 */
public class CustomerQueryServlet extends HttpServlet implements SingleThreadModel {
	 
	 /** HTML header and footer generator */
	 private HTMLtags htag;  
	 
	 /** SQL Functional Engine to carry out various tasks */
	 private SQLEngine sfe;  

	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  htag = new HTMLtags();
		  sfe = new SQLEngine();
	 }
	 

	/**
	 * This shows all the tables with customer information relating to a 
	 * particular customer either from his email-ID or CustomerTag 
	 */
	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		   response.setContentType("text/html");
		   PrintWriter pw = response.getWriter();
		   
		   String customertag = request.getParameter("customertag");
		   String customeremailid = request.getParameter("customeremailid");
				
		   htag.header(pw);
		   
		   if ((customertag == null) || customertag.equals("")) {
				if ( (customeremailid == null) || customeremailid.equals("") ) {
					 pw.println("<B><font color=#ffffff> What did you expect when you entered Null values ?</font></b>");
				} else {
					 String[] dump = sfe.execQuery("SELECT customer_tag FROM " + 
							   " customer WHERE email_id='" + customeremailid.trim() +"'");
					 if (dump.length == 1) {
						  pw.println("<BR><FONT color=#ffffff> No customer with such an emailid in the database</font>");
					 } else {
						  customertag = dump[1].trim();
						  pw.println("<HR><FONT COLOR=#FFFFFF>");
						  pw.println("customertag|" + customertag +"|");
						  pw.println("<HR>");
						  pw.println("customeremailid|" + customeremailid +"|");
						  pw.println("</FONT><HR>");
					 }
				}
		   }
					 
		   String query = "";
		   
		   customertag = customertag.toUpperCase();
		   customertag = customertag.trim();
		   if (!((customertag == null) || customertag.equals(""))) {
				query = "SELECT customer_tag,email_id,fax_code,fax_number,phone_code,phone_number FROM customer WHERE customer_tag='"+ customertag +"'"; 
				pw.println("<FONT color=#FFFFFF >");
				pw.println("<BR>Table : Customer <BR>");
				pw.println("</FONT>");
			//	pw.println("<BR>"+ query +"<BR>");
				sfe.execQuery(query,pw);
				
				query = "SELECT csrcomment FROM customer WHERE customer_tag='"+ customertag +"'"; 
				pw.println("<FONT color=#FFFFFF >");
				pw.println("<BR>Table : Customer <BR>");
				pw.println("</FONT>");
			//	pw.println("<BR>"+ query +"<BR>");
				sfe.execQuery(query,pw);
				
				query = "SELECT * FROM individual WHERE customer_tag='"+ customertag +"'";
				pw.println("<FONT color=#FFFFFF >");
				pw.println("<BR>Table : Individual <BR>");
				pw.println("</FONT>");
			//	pw.println("<BR>"+ query +"<BR>");
				sfe.execQuery(query,pw);
				
				query = "SELECT * FROM address WHERE customer_tag='"+ customertag +"'";
				pw.println("<FONT color=#FFFFFF >");
				pw.println("<BR>Table : Address <BR>");
				pw.println("</FONT>");
			//	pw.println("<BR>"+ query +"<BR>");
				sfe.execQuery(query,pw);
				
				query = "SELECT * FROM organisation WHERE customer_tag='"+ customertag +"'";
				pw.println("<FONT color=#FFFFFF >");
				pw.println("<BR>Table : Organisation <BR>");
				pw.println("</FONT>");
			//	pw.println("<BR>"+ query +"<BR>");
				sfe.execQuery(query,pw);
				
				query = "SELECT * FROM academics WHERE customer_tag='"+ customertag +"'";
				pw.println("<FONT color=#FFFFFF >");
				pw.println("<BR>Table : Academics <BR>");
				pw.println("</FONT>");
			//	pw.println("<BR>"+ query +"<BR>");
				sfe.execQuery(query,pw);
				
				query = "SELECT * FROM corporate WHERE customer_tag='"+ customertag +"'";
				pw.println("<FONT color=#FFFFFF >");
				pw.println("<BR> Table : Corporate <BR>");
				pw.println("</FONT>");
			//	pw.println("<BR>"+ query +"<BR>");
				sfe.execQuery(query,pw);
		   }
		   htag.footer(pw);
	 }
}
