import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** This class shows the CRM_Personnel entityset details like emailid and name and
 * provides an interface  to add new CSR to the set .
 * @author Rajendra Sansare 
 */

public class EditCSRServlet extends HttpServlet implements SingleThreadModel {
	 
	 private SQLEngine sfe;
	 private HTMLtags htag;

	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  sfe  = new SQLEngine();
		  htag = new HTMLtags();
	 }
	 

	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  String serass  = actionurl + "~/servlet/AssignCSRService?";
		  String service = actionurl + "~/servlet/ServiceBasketServlet?";
		  actionurl += "~/servlet/EditCSRServlet"; /* name of the servlet */


		  String query = "";
		  htag.header(pw);
		  
		  pw.println("<FORM  method=POST action="+actionurl+">");
		  /** %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */                                          

		  /** Note */
		  pw.println("<font color=#ff0000><b> NOTE </b></FONT><BR>");
		  pw.println("<FONT color=#ffffff><H1>&nbsp;Maximum limit of the values is upto 30 characters .</H1>");
		  pw.println("</font>");
		  pw.println("<a href="+ serass + ">Assign CSR Service to handle</a><BR>");
		  pw.println("<a href="+ service + ">Add new Services</a><BR><HR><BR>");
		  
		  //query = "SELECT * FROM CRM_Personnel";
		  query = "SELECT '<input type=radio name=editdel value=edi' || email_id || '>  Edit' ,"
			   + "'<input type=radio name=editdel value=del' || email_id || '>  Del', email_id, name "
			   + " FROM CRM_Personnel";

		  
		  pw.println("<B><FONT COLOR=#FFFFFF> Customer  Service Representative's are </FONT></B><BR><BR>");
		  sfe.execQuery(query,pw);
		  pw.println("<FONT color=#ffffff><input type=radio name=editdel checked value=new checked> Add NEW CSR </font><BR>"); 
		  printTable(pw);
		  
		  pw.println("<CENTER><input type=submit value=Submit>");
		  pw.println("<input type=reset  value=Reset></CENTER>");
		  pw.println("</FORM>");

		  htag.footer(pw);
	 }
	 
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();

		  htag.header(pw);
		  pw.println("<B> Received </B><BR>");
		  
		  String editdelnew = request.getParameterValues("editdel")[0];
		  String actype = editdelnew.substring(0,3);
		  pw.println("<B>" + editdelnew + "</B><BR>");
		  pw.println("<B>" + actype + "</B><BR>");

		  String emailid = request.getParameterValues("emailid")[0];
		  String csrname = request.getParameterValues("csrname")[0];
		  
		  if (actype.equals("new")) {
			   InsertintoTables(emailid,csrname,pw);
		  } else {
			   String upstmt = "";
			   if (actype.equals("edi")) {
					pw.println(" Edit function <BR>");
					upstmt = "UPDATE crm_personnel SET email_id='"+emailid.trim()
						 +"', name='"+csrname+"' where email_id='"+editdelnew.substring(3).trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   } else {
					pw.println(" Del function <BR>");
					upstmt = "DELETE FROM crm_personnel where email_id='"+editdelnew.substring(3).trim()+"'";
					pw.println("<font color=#ffffff><BR>" + upstmt +"<BR>");
					pw.println(sfe.InsertData(upstmt) + "<BR></font>");
			   }
		  }
			   
		  htag.footer(pw);
	 }

	 /** inserts the new values of CSR's emailid  and his/her name 
	  * into the database. 
	  * @param string emailid - emailid of the csr
	  * @param string csrname - Name of the csr
	  * @param Printwriter pw 
	  */ 
	 public void InsertintoTables(String emailid, String csrname,PrintWriter pw) {
		  String instmt = "";
		  boolean anynullval = true; 
		  
		  if (emailid.equals("") || emailid.equals(null)) anynullval = false;
		  if (csrname.equals("") || csrname.equals(null)) anynullval = false;

		  if (anynullval) {
			   pw.println("<font color=#ffffff> For Table CRM_Personnel :<br>"); 
			   instmt = "INSERT INTO CRM_Personnel VALUES ('"+ emailid.trim() +"','"
					+ csrname.trim() +"')"; 
			   pw.println(" values " + emailid + "&nbsp;  " + csrname + " has been inserted<Br>");
			   pw.println( sfe.InsertData(instmt) + "</font>" );
		  } else {
			   // do nothing
			   pw.println("<font color=#ffffff> No value has been inserted as a null input is given </font><br>"); 
		  }
	 }

	 /**
	  * @param PrintWriter pw 
	  */
	 public void printTable(PrintWriter pw) {
		  pw.println("<BR><BR>");
		  pw.println("<center><table BORDER=0 CELLSPACING=2 CELLPADDING=2 COLS=1 WIDTH=75% BGCOLOR=#CCCCCC >");
		  pw.println("<tr><td><center>");
		  pw.println("<table BORDER=0 COLS=2 WIDTH=100% BGCOLOR=#B080FF NOSAVE >");
		  pw.println("<tr NOSAVE>");
		  pw.println("<td NOSAVE>");
		  pw.println("<center><font color=#000000> E-mail ID </font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> Name </font></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  
		  pw.println("<tr>");
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=emailid size=27 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=csrname size=27 value=></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table>");
		  pw.println("</center>");
		  
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table></center>");
		  pw.println("<HR>");
	 }
}
