/** FirstPhase 
 * 1 Process the Mail from the file where the mail is appended 
 * 2 Get the header and subject information 
 * 3 Get the Service Tag corresponding to the service requested from the subj header
 * 4 Find the CSR emailid , using the Service tag 
 * 5 Mail the body of the email with relevant headers to the CSR 
 * 6 Insert the information in the respective Entity Sets
 * ie CustomerEmail,EmailStatus,PriorityManager,
 */

/** @author Rajendra Sansare */
import java.io.*;

class FirstPhase {
	 
	 private GetFunctions gfn;
	 private SMTPMail smtp;
	 private SQLEngine sfe;
	 private AutoMailNotifier amn;
	 
	 /** length fixed for the email */
	 final int LENGTH = 3000;

	 public FirstPhase() {
		  sfe = new SQLEngine();
	 }

	 public void DBUpdate(String[] email,String CSRemailid) {
		  System.out.println("\n|" + CSRemailid +"|");
		  
		  
		  String addon ="\n ... The e-mail has been truncated as it exceeded the fixed length assigned. \n" +
			   "A copy of the complete email has been mailed to you. Please check your INBOX ";
		  email[8] = email[8].replace('\'','`');
		  String insertstmt = "INSERT INTO CustomerEmail VALUES(" +
			   "'"+ email[0] +"','"+ email[1] +"','"+ email[2] +"','"+ email[3] +
			   "','"+ email[4] +"','"+ email[5] +"','"+ email[6] +"','"+ email[7] 
			   +"','"+ (email[8].length() > LENGTH ? email[8].substring(0,(LENGTH -10) - addon.length()) + addon : email[8]) 
			   +"', sysdate)";
		  System.out.println(insertstmt);
		  System.out.println(sfe.InsertData(insertstmt) + "\n");

		  insertstmt = "INSERT INTO Email_Status VALUES(" +
			   "'"+ email[0] +"', 'false', 'UNSET', 'false','" +
			   CSRemailid +"', 'Reply Email', sysdate,'Email Comment')";
		  System.out.println(insertstmt);
		  System.out.println(sfe.InsertData(insertstmt) + "\n");

		  insertstmt = "INSERT INTO get_servicetag VALUES(" +
			   "'" + email[0] +"','"+ gfn.getServiceTag(email[7]) +"')";
		  System.out.println(insertstmt);
		  System.out.println(sfe.InsertData(insertstmt) + "\n");
	 }
		  
	 /** email[7] contains the subjectheader */
	 /** email[8] contains the body */
	 /** @param String[] email */
	 /** @return String CSREmailid */
	 public String forwardEmail(String[] email) {
		  gfn = new GetFunctions();
		  String CSRemailid = gfn.getCSRemailid(gfn.getServiceTag(email[7]));
		  System.out.println("------------ServiceTag |"+gfn.getServiceTag(email[7])+"|");
		  System.out.println("------------CSREMAILID |"+CSRemailid+"|");
		  String CSRName = gfn.getCSRname(CSRemailid);
		  int priority = 2; //make a fn

		  String headerbody = "From: " + email[1] + " " + email[2] +
			   				  "\nTo: " + CSRName  + "  <" + CSRemailid + ">" +
							  "\nSubject: " + email[7] +
							  "\nMessage-ID: " + email[0] +
							  "\nMime-Version: 1.0 \nContent-Type: text/plain; charset=us-ascii" + 
							  "\nX-Mailer: Mutt 1.0pre3i\n" +
							  "\nPriority Number : " + priority +
							  "\n" +  email[8];


		  smtp = new SMTPMail();
		  smtp.setSenderEmailaddress("csr@cse.iitb.ernet.in");
		  smtp.setSMTPsenderhost("everest.cse.iitb.ernet.in");
		  smtp.setSMTPreceiverhost("everest.cse.iitb.ernet.in");
		  if (email[8].length() > LENGTH ) {
			   System.out.println("Email Forwarded to" + CSRemailid + "\n");
			   smtp.mail(CSRemailid, headerbody);
		  }
		  return CSRemailid;
	 }
	 
	 public void JobSequencer(String[] email) {
		  DBUpdate(email,forwardEmail(email));
		  amn = new AutoMailNotifier();
		  /** notifies the customer of the receipt of the email */
		  amn.notify(email[1],email[2]);
	 }
}
