import java.util.*;
import java.lang.*;

/** This class is used to find the Service Tag from the subject header */
/** IMPORTANT : I have just written a very cheapo program which selects the
 * CSR emailid depending on only the first Keyword that matches , but I intend 
 * to write a robust program which will get refined keyword matching using NLP
 * to zero onto a specific CSR emailid .
 * @author Rajendra Sansare
 */

public class GetFunctions {
	 
	 private SQLEngine sfe;

	 public GetFunctions() {
		  sfe = new SQLEngine();
	 }
	 
	 /** keywordMatch does matching and returns the service tag 
	  * which is the first token in the  param String tuple if
	  * a match occurs or returns null.
	  * @param subjectheader String - email Subject Header
	  * @param tuple String  - the servicetag concatanated with the keywords
	  */
	 public String keywordMatch(String subjecthead, String tuple) {
		  StringTokenizer tuplest = new StringTokenizer(tuple);
		  int no_of_tokens = tuplest.countTokens();
		  String[] keywords = new String[no_of_tokens];
		  boolean match = false;
		  for (int i = 0; i < no_of_tokens; i++) {
			   keywords[i] = tuplest.nextToken();
		  }
		  /* countmatches keeps a track of number of matches */
		  int countmatches = 0;
		  StringTokenizer subjst = new StringTokenizer(subjecthead);
		  while (subjst.hasMoreTokens()) {
			   String toke = subjst.nextToken();
			   countmatches = 0;
			   for (int i = 0; i < no_of_tokens; i++) {
					if ( keywords[i].equals(toke) ) {
						 System.out.println(" Keyword match :" + toke );
						 match = true;
						 countmatches++;
					}
			   }
		  }
		  if (match) {
			   if (countmatches > 1) {
					System.out.println(" More Than one Match in Keyword");
			   }
			   return keywords[0];
		  } else {
			   return null;
		  }
	 }

	 
	 /** 
	  * Takes the subject header of the email and returns the servicetag .
	  * @param  String subjectheader 
	  * @return String servicetag 
	  */
	 public String getServiceTag(String subjectheader) {
		  String query = new String("select service_tag,serv_keywords from service_basket");
		  String[] result = sfe.execQuery(query);
		  String ser_tag = null;
		  for (int i = 0; i < result.length; i++) {
			   ser_tag = keywordMatch(subjectheader,result[i]);
			   if (ser_tag != null) {
					/** only the first match is reported */
					break;
			   }
		  }
		  if (ser_tag == null) {
			   return "NOMATCH"; 
			   /** "NOMATCH" is a servicetag  and the email is 
				* forwarded/assigned to the csr handling NOMATCH emails
				*/
		  } else {
			   return ser_tag;
		  }
	 }
	 
	 /** takes the service tag and returns the csr emailID 
	  * @param  String ser_tag  - service tag for some specified service
	  * @return String csrid  - emailID of the CSR 
	  */
	 public String getCSRemailid(String ser_tag) {
		  String[] csrid = sfe.execQuery("select email_id from Forward_Email where tag='"+ser_tag+"'"); 
		  if (csrid.length == 1) 
			   return "";
		  else
			   return csrid[1].trim();
	 }
	 
	 /** takes the CSRemailid and returns the CSR name 
	  * @param  String csremailID - emailID of the CSR 
	  * @return String csrname    - CSR's name havind above emailID
	  */
	 public String getCSRname(String CSRemailid) {
		  String[] csrname = sfe.execQuery("select name from CRM_Personnel where email_id='"+CSRemailid+"'");
		  if (csrname.length == 1) 
			   return "";
		  else
			   return csrname[1].trim();
	 }
	 
	 /*  To Test
	 public static void main(String[] args) {
		  GetFunctions gf = new GetFunctions();
		  String subjectheader = " EAT Sleep Sit";
		  System.out.println("Tag" + gf.getServiceTag(subjectheader));
		  System.out.println("CSR" + gf.getCSRemailid(gf.getServiceTag(subjectheader)));
	 }
	 */
}
