/** How to prioritize the customer 
 * depending upon
 * this is the intial information we get about every customer, we give equal priority
 * to groups of customer initially based on which income group he is in
 *  1 the income gained by rendering services to the customer
 *
 *  2 the number of times the customer has accessed the services / recently
 *     helps to retain the newbie 
 *  3 geographical location 
 *  4 the size of the organization and the new businesses it would provide
 *  5 Profession / Position
 *  6 response to the last/previous  questionnaire evaluation
 *
 */
/** Priority Scale is from 1 to 10  highest is 10 lowest is 1*/


/** @author Rajendra Sansare */


/* This class takes the parameters on which to prioritize the customer and
 * inserts them into the PriorityManager entity set .The parameters can be 
 * single or multiple . In case of multiple and conflicting priorties , 
 * error can be reported  or preference may be given to the parameter with a
 * higher weightage as decided by the CRM personnel/DBA .
 */



/**  I maintain a deadline of 24 hours to reply to the service request */

import java.io.PrintWriter;
import java.io.IOException;
import java.lang.Integer;
import javax.servlet.*;
import javax.servlet.http.*;

public class PriorityManager extends HttpServlet implements SingleThreadModel {
	 
	 private   SQLEngine sfe;
	 private   HTMLtags htag;
	 
	 
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  
		  sfe = new SQLEngine();
		  htag = new HTMLtags();
	 }
	 
	 
	 /** this does it .  */
	 
	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();

		  String userinput = request.getParameter("querytable");  
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/PriorityManager"; /* name of the servlet */


		  htag.header(pw);
		  sfe.execQuery("SELECT  tablename , fieldname, fieldvalue, priority FROM priorities " +
					" WHERE tablename IN ( SELECT tablename FROM priorities GROUP BY tablename )", pw);

		  pw.println("<HR>");
		  
		  /** BEST QUERY EVER FORMED */
		  sfe.execQuery("SELECT ' FROM   ' || tablename || '   WHERE   ' || fieldname || ' = ''' || fieldvalue || '''"
					+"  AND    customer_tag = ''"+ getCustomerTag("tomjerry@cartoons") +"'''    FROM priorities ", pw);
		  
		  sfe.execQuery("SELECT ' FROM  ' || tablename || '   WHERE   ' || fieldname || ' = ''' || fieldvalue || ''' '    FROM priorities ", pw);

		  String[] prioritytuples = sfe.execQuery("SELECT ' FROM  ' || tablename || '   WHERE   ' || fieldname || ' = ''' || fieldvalue || ''' '"
					+"  FROM priorities ");

		  String custtag = getCustomerTag("tomjerry@cartoons");

		  for (int i = 3; i < prioritytuples.length; i++) {
			   
			   pw.println("<BR><font color=#ffffff>|" + prioritytuples[i] +"|<BR>" );
			   System.out.println( "|"+ prioritytuples[i] +"|");
			   sfe.execQuery("SELECT *  " + prioritytuples[i]  +" and customer_tag='"+custtag+"'" , pw);
			   
			   String[] dump = sfe.execQuery("SELECT *  " + prioritytuples[i] +" and customer_tag = '"+custtag+"'");
			   
			   if (dump.length != 1) {  // we have a tuple that matches the given values 
					
					int priority = Integer.parseInt(
							  sfe.execQuery("SELECT priority FROM priorities")[i].trim()
							  );
					
					/*
					 * another method  do complete if u want.
					int priority = Integer.parseInt( sfe.execQuery("SELECT priority FROM priorities WHERE " + splitarrange(prioritytuples[i]) )[1]);
					*/

					System.out.println( priority );
					pw.println("<B>" + priority  +"</B>");
			   }
			   pw.println("</font><HR>");
		  }
		  htag.footer(pw);
	 }



	 /** 
	  * Function that takes a tuple from the prioritytuples String array above and form 
	  * a part of query statement with the tablename , fieldname and fieldvalue 
	  * @param  String prioritytuples[i]     -
	  * @return String partofquery - arranged form
	  */
	 public String splitarrange(String prioritytuples) {
		  /* prioritytuples is of form "FROM tablename WHERE fieldname = 'fieldvalue'" */
		  //StringTokenizer stok = new StringTokenizer(); 
		  String partofquery = "tablename = '"  ;
		  return partofquery;
	 }



	 /**
	  *  Function that returns the customer tag associated with an emailid of the 
	  *  customer whose information is present in the database .
	  *  @param  String emailid      - takes the emailid of a customer email 
	  *  @return String customertag  - the customer tag
	  */
	 public String getCustomerTag(String emailid) {
		  
		  String[] custtag = sfe.execQuery("SELECT customer_tag FROM customer WHERE email_id='"
					+ emailid.trim() +"'");
		  
		  if (custtag.length == 1) {
			   return null;
		  } else {
			   return custtag[1].trim();
		  }
	 }



	 /**
	  * Function that checks whether any information is present in the database
	  * corresponding to the customer with a given emailid .
	  * @param  String  emailid  -  emailid of a customer service request email
	  * @return boolean result   -  result 
	  */
	 public boolean isInfoPresent(String emailid) {
		  
		  String[] info = sfe.execQuery("SELECT * FROM customer WHERE emailid='"+
					emailid.trim() +"'");
		  
		  if ( info.length == 1) {
			   return false;
		  } else {
			   return true;
		  }
	 }
	 
}
