/** This program takes the mail file where the mail gets appended and 
 * separates each email in turn separating each header and content of each
 * email .
 * @author Rajendra Sansare
 */
import java.io.*;


class ProcessMail {
	 private String[] headers; 
	 private File varmail;
	 private FileInputStream fis;
	 
	 public ProcessMail(String mailfile) { 
		  try {
			   varmail = new File(mailfile);
			   fis = new FileInputStream(varmail);
		  } catch (FileNotFoundException fne) { 
			   fne.printStackTrace(); 
		  }
	 }
	
	 /** @param email String containing an entire email 
	  * @return String[] format - format of the email as given below
	  * I take only a fixed number of headers viz 
	  * 2. FromName 3 .Fromemailid   4.Reply-ToName	5.Reply-Toemailid)
	  * 6. Date		1 .Message-Id	 8.Subject	9.Body	7.Time
	  * If Reply-To header is not present the default value of From is 
	  * substituted .
	  */
	 public String[] getFormat(String email) {
		  String[] format = new String[9];

		  String temp = null, dump = null;
		  int index1 = 0, index2 = 0;
		  /** Message-Id */
		  
		  index1 = email.indexOf("\nMessage-ID:");
		  if (index1 == -1 ) index1 = email.indexOf("\nMessage-Id");
		  index2 = email.indexOf("\n",index1 + 1);
		  if (index1 == -1 ) {
		  System.out.println(index1 + "\t" + index2);
		  }
		  temp = email.substring(index1 + 13,index2);
		  temp = temp.replace('<',' ');
		  temp = temp.replace('>',' ');
		  temp = temp.trim();
		  format[0] = temp;
		  System.out.println("\tMessage-ID\n|" + format[0] +"|");

		  /** From */
		  index1 = email.indexOf("\nFrom: ");
		  index2 = email.indexOf("\n",index1 + 1);
		  temp = email.substring(index1 + 7,index2);
		  dump = temp.substring(0,index2 = temp.indexOf("<") - 1); 
		  format[1] = dump.trim(); 
		  System.out.println("\tFrom-Name\n|" + format[1] +"|");
		  temp = temp.substring(index2+1,temp.length());
		  temp = temp.replace('<',' ');
		  temp = temp.replace('>',' ');
		  format[2] = temp.trim();
		  System.out.println("\tFrom-emailid\n|" + format[2] +"|");
		  
		  /** Reply-To */
		  index1 = email.indexOf("\nReply-To: ");
		  if (index1 == -1) {
			   format[3] = format[1];
			   format[4] = format[2];
		  } else {
			   index2 = email.indexOf("\n",index1 + 1);
			   temp = email.substring(index1 + 11,index2);
			   dump = temp.substring(0,index2 = temp.indexOf("<") - 1);
			   format[3] = dump.trim();
			   temp = temp.substring(index2+1,temp.length());
			   temp = temp.replace('<',' ');
			   temp = temp.replace('>',' ');
			   format[4] = temp.trim();
		  }
		  System.out.println("\tReply-ToName\n|" + format[3] + "|");
		  System.out.println("\tReply-Toemailid\n|" + format[4] + "|");

		  /**Date and Time */
		  index1 = email.indexOf("\nDate: ");
		  index2 = email.indexOf("\n",index1 + 1);
		  temp = email.substring(index1 + 7,index2);
		  dump = temp.substring(0,index2 = temp.indexOf(":") - 3); 
		  format[5] = dump.trim();
		  System.out.println("\tDate\n|" + format[5] +"|");
		  temp = temp.substring(index2+1,temp.length());
		  format[6] = temp.trim();
		  System.out.println("\tTime\n|" + format[6] +"|");

		  /** Subject */
		  index1 = email.indexOf("\nSubject: ");
		  index2 = email.indexOf("\n",index1 + 1);
		  temp = email.substring(index1 + 10,index2);
		  format[7] = temp.trim();
		  System.out.println("\tSubject\n|" + format[7]);

		  /** Body */
		  /** lets hope that the first match of "\n\n" gives the start of 
		   * the body
		   */
		  index1 = email.indexOf("\n\n",index2);
		  format[8] = email.substring(index1,email.length());
		  format[8] = format[8].replace('\'','`');
		  System.out.println( format[8] );

		  return format;
	 }

	 /**
	  * @param String body - of the email
	  * @return String processed - processed body of the email
	  */
	 public String processQuotes(String body) {
		  String processed = body;
		  int curindex = processed.indexOf("'",0);
		  while (curindex != -1) {
		  }
		  return processed;
	 }

		  
	 public void processfile() { 
		  try {
		  byte[] b =new byte[fis.available()];
		  fis.read(b);
		  if ((b.length == 0) || (b.length == 1)) {
			   System.out.println("No Mail currently in the mail file ");
		  } else {
		  String temp = new String(b);
		  FirstPhase fp = new FirstPhase();
		  
		  int indexfrom = -1, previndex = 0;
		  
		  while ( (indexfrom = temp.indexOf("\nFrom ",indexfrom + 1)) != -1) {
			   System.out.println("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
			   //System.out.println(temp.substring(previndex,indexfrom));
			   String[] ebody = getFormat(temp.substring(previndex,indexfrom));
			   fp.JobSequencer(ebody);
			   System.out.println("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
			   previndex = indexfrom;
		  }
		  //The last message is still not printed as indexfrom becomes -1 so :-
		  //System.out.println(temp.substring(previndex,temp.length()));
		  String[] ebody = getFormat(temp.substring(previndex,temp.length()));
		  fp.JobSequencer(ebody);
		  System.out.println("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
		  }
		  fis.close();
		  } catch (IOException ioe) { 
			   ioe.printStackTrace();
		  }
	 }
	 
	 /*
	 public static void main(String[] args) {
		  ProcessMail pm = new ProcessMail("testmail.txt");
		  //ProcessMail pm = new ProcessMail("/var/mail/rajs");

		  pm.processfile();

		  try {
			   FileOutputStream fos = new FileOutputStream("testmail.txt");
			   fos.write(32);
			   fos.close();
		  } catch (IOException ioe) {
			   ioe.printStackTrace();
		  }
	 }
	 */
}
