
/*This class has functions which 
 * allow to reply to a email 
 * show the case history in a new window 
 */

/** @author Rajendra Sansare */

import java.io.PrintWriter;
import java.io.IOException;
import java.lang.Integer;
import javax.servlet.*;
import javax.servlet.http.*;

public class ReplyEmail extends HttpServlet implements SingleThreadModel {

	 private SQLEngine sfe;
	 private HTMLtags htag;
	 private SMTPMail smtp;
	 
	 
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  
		  sfe = new SQLEngine();
		  htag = new HTMLtags();
	 }


	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");

		  PrintWriter pw = response.getWriter();

		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/ReplyEmail"; /* name of the servlet */

		  //htag.header(pw);
		  pw.println("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">");
		  pw.println("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html charset=iso-8859-1\">");
		  pw.println("</head> <body text=\"#000000\" bgcolor=#CCCCFF link=\"#7711BB\"" + 
					"vlink=\"#0000FF\" alink=\"#002200\">");

		  String Messageid = request.getParameterValues("message_id")[0];
		  String replyname = request.getParameterValues("replyname")[0];
		  String replyemailid = request.getParameterValues("replyemailid")[0];
		  String datetime = request.getParameterValues("datetime")[0];
		  

		  
		  String to = "\"" + request.getParameterValues("replyname")[0] + " [" 
			   + replyemailid +"]\"";
		  String subj = "\"Re:" + request.getParameterValues("subject")[0] +"\"";
		  
		  pw.println("<form name=\"Compose\" id=\"Compose\" method=post action="+ actionurl +">"); 
		  
		  pw.println("<input type=hidden name=message_id value="+ Messageid +"><BR>");
		  pw.println("<input type=hidden name=replyname value=\""+ replyname +"\"><BR>");
		  pw.println("<input type=hidden name=replyemailid value="+ replyemailid +"><BR>");
		  pw.println("<input type=hidden name=datetime value=\""+ datetime +"\"><BR>");

		  pw.println("<CENTER><table cellpadding=1 cellspacing=0 border=0>");
		  pw.println("<tr><td><font size=-1><B>To:</B></font></td>"
					 + "<td><input type=text name=\"To\" size=50 value="// 
					 + to
					 + "></td></tr>");
		  pw.println(
					  "<tr><td><font size=-1><B>Cc:</B></font></td>"
					 + "<td><input type=text size=50 name=Cc value=" //
					 + "></td></tr>");
		  pw.println(
					  "<tr><td><font size=-1><B>Bcc:</B></font></td>"
					 + "<td><input type=text name=Bcc size=50 value=" //
					 + "></td></tr>");
		  pw.println(
					  "<tr><td><font size=-1><B>Subject:</B></font></td>"
					 + "<td><input type=text name=\"Subj\" size=50 VALUE=" //
					 + subj
					 + "></td></tr>");
		  
		  String body = "On "+ datetime + " "+ replyname +" wrote :"+
			   sfe.execQuery("SELECT  CustomerEmail.body FROM CustomerEmail"
						 +" WHERE CustomerEmail.message_id='"+Messageid.trim()+"'")[1];

		  pw.println("<tr><td><font size=-1><B>Body:</B></font></td>");
		  pw.println("<td><textarea name=\"Body\" rows=15 cols=50 wrap=virtual>"
					+ body
					+"</textarea></td></tr></table></CENTER>");
		  
		  pw.println("<table id=t2 class=Gen cellpadding=3 cellspacing=0 border=0 width=100%>"
			+ "<tr><td nowrap colspan=2><font size=-1>"
			+ "<input type=checkbox name=\"SigAtt\" value=1 id=SA>Use Signature"
			+ "<input type=radio name=\"Format\" value= checked>plain text" 
			+ "</font></td></tr>" );
		  
			
		  pw.println( "<tr bgcolor=#000077><center><td nowrap><FONT color=#ffffff>"
			+ "<input type=submit name=SEND value=Send>"
			+ "<input type=submit name=SD value=Save Draft>"
			+ "<input type=submit name=SC value=Spell Check>"
			+ "<input type=submit name=CAN value=Cancel>"
			+ "</font></td></center></tr>" 
			+ "</table></form>");
		  
		  htag.footer(pw);
	 }

	 
	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");

		  PrintWriter pw = response.getWriter();

		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/ReplyEmailServlet"; /* name of the servlet */

		  htag.header(pw);
		  

		  /*
		  pw.println("<font color=#ffffff><BR>");
		  pw.println(request.getParameterValues("replyname")[0]);
		  pw.println(request.getParameterValues("message_id")[0]);
		  pw.println(request.getParameterValues("Cc")[0]);
		  pw.println(request.getParameterValues("Bcc")[0]);
		  pw.println(request.getParameterValues("Body")[0]);
		  */
		  
		  String replyname  = request.getParameterValues("replyname")[0];
		  String replyemailid  = request.getParameterValues("replyemailid")[0];
		  String message_id = request.getParameterValues("message_id")[0];
		  String To   = request.getParameterValues("To")[0];
		  To = To.replace('[','<');
		  To = To.replace(']','>');
		  String cc   = request.getParameterValues("Cc")[0];
		  String bcc  = request.getParameterValues("Bcc")[0];
		  String subj  = request.getParameterValues("Subj")[0];
		  String body = request.getParameterValues("Body")[0];
		  

		  String csrname    = "CSR I AM ";
		  String csremailid = " <csr@activeemail.co.in>";
		  String headerbody = "From: " + csrname + " " + csremailid +
			   				  "\nTo: " + To +
							  "\nSubject: " + subj +
							  "\nMime-Version: 1.0 \nContent-Type: text/plain; charset=us-ascii" + 
							  "\nX-Mailer: Mutt 1.0pre3i\n" +
							  "\n" + body  ;
		  body = body.trim();
		  body = body.replace('\'','`');

		  
          // check body length < 1500 characters 
		  
		  String upstmt = "UPDATE EMAIL_STATUS set reply_posted='true',replymail='"+body
					+"',repdatetime=sysdate WHERE message_id='"+message_id.trim()+"'";
		  //pw.println(upstmt +"<BR></font>");
		  
		  pw.println(sfe.InsertData(upstmt) + "<BR>");
		  

		  smtp = new SMTPMail();
		  smtp.setSenderEmailaddress("csr@cse.iitb.ernet.in");
		  smtp.setSMTPsenderhost("everest.cse.iitb.ernet.in");

		  /** All mails which go outside Dept and outside IIT are routed through mailhost.iitb.ac.in */
		  //smtp.setSMTPreceiverhost("mailhost.iitb.ac.in");
		  smtp.setSMTPreceiverhost("everest.cse.iitb.ernet.in");
		  
		  //smtp.mail(replyemailid.trim(), headerbody);
		  smtp.mail("rajs@cse.iitb.ernet.in", headerbody);
		  pw.println("<BR><BR><BR>");
		  pw.println("<font color=#ffffff><BR>Your REPLY has been sent .</font>");
		  
		  htag.footer(pw);
	 }
}
