import java.io.*;
import java.net.*;
import java.util.*;

/** Note 
 * Rajendra Sansare grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Rajendra Sansare.
 */
/** Add more functionality to this and make a package of this. */
/** @author Rajendra Sansare */

class SMTPMail {
	 
	 /** the connection handshake which the sender makes with the receiver of the email*/
	 private String handshake;
	 
	 /** SMTP port number*/
	 private static final int SMTPPORT = 25;
	 
	 /** sender host and the receiver host of the email */
	 private String smtp_sender_host, smtp_receiver_host;
	
	 /** the senders email address */
	 private String sender_email_address;


	 /** Constructor */
	 public SMTPMail() {
		  handshake = null;
		  smtp_sender_host = null;
		  smtp_receiver_host = null;
		  sender_email_address = null;
	 }

	 /** 
	  * @param String hostname - sets the name of the senders hostname in 
	  * the smtp_sender_host field .
	  */
	 public void setSMTPsenderhost(String hostname) {
		  smtp_sender_host = hostname;
	 }
	 
	 /** 
	  * @return String smtp_sender_host - returns the value of the smtp_sender_host
	  * field .
	  */
	 public String getSMTPsenderhost() {
		  return smtp_sender_host;
	 }
	 
	 /** 
	  * @param String hostname - sets the name of the receivers hostname in 
	  * the smtp_receiver_host field .
	  */
	 public void setSMTPreceiverhost(String hostname) {
		  smtp_receiver_host = hostname;
	 }

	 /** 
	  * @return String smtp_receiver_host - returns the value of the smtp_receiver_host
	  * field .
	  */
	 public String getSMTPreceiverhost() {
		  return smtp_receiver_host;
	 }

	 /** 
	  * @param String emailaddress - sets the senders email address in the field 
	  * sender_email_address .
	  */
	 public void setSenderEmailaddress(String emailaddress) {
		  sender_email_address = emailaddress;
	 }

	 /** 
	  * @return sender_email_address - returns the value of the sender_email_address field
	  */
	 public String getSenderEmailaddress() {
		  return sender_email_address;
	 }
	 
	 /** check whether the sender_domain is reflected in the sender's email_address 
	  * if ( !checksum(rcptemailaddress) ) throw Exception();
	  */
	 
	 
	 /**
	  * @param String rcptemailaddress - the email address of the person whom
	  * the email is being sent.
	  * @param String body - the contents of the email
	  */
	 public void mail(String rcptemailaddress, String body) {
		  try {
		  Socket mailsock = new Socket(this.smtp_receiver_host, SMTPPORT);

		  InputStream in = mailsock.getInputStream();
		  OutputStream out = mailsock.getOutputStream();

		  /** "HELO is accepted by mailhost.iitb.ac.in "*/
		  handshake = "HELO " + smtp_sender_host +
			        "\nMAIL From:" + sender_email_address +
			        "\nRCPT To:" + rcptemailaddress + 
					"\nDATA\n" + body +
					"\n.\n" +
					"QUIT";
		  out.write(handshake.getBytes());
		  out.flush();
		  
		  System.out.println(in.read());
		  in.read();

		  in.close();
		  out.close();
		  mailsock.close();
		  } catch (UnknownHostException uhe) {
			   System.out.println(" uhe in SMTP");
			   uhe.printStackTrace();
		  } catch (IOException ioe) {
			   System.out.println(" ioe in SMTP");
			   ioe.printStackTrace();
		  }
	 }

	 /* test 
	 public static void main(String[] args) {
		  String headerbody = 
			   "From: Rajendra Sansare <rajsan@rulz.here>" + 
			   "\nTo: Atlantis<kingdom@of.rajsan>" + 
			   "\nSubject: i love cheeze" +
			   //"\nMessage-ID: <20001018022404.A2045@cse.iitb.ernet.in>" +   
			   // in case you want to send a specific Message-id include above stmt.
			   "\nMime-Version: 1.0 \nContent-Type: text/plain; charset=us-ascii" + 
			   "\nX-Mailer: Mutt 1.0pre3i\n" +
			   "\nPriority Number:0292" +
			   "\nThis really is pseud";

		  
		  SMTPMail  test = new SMTPMail();
		  test.setSenderEmailaddress("rajs@cse.iitb.ernet.in");
		  test.setSMTPsenderhost("everest.cse.iitb.ernet.in");
		  test.setSMTPreceiverhost("everest.cse.iitb.ernet.in");
		  //test.setSMTPreceiverhost("mailhost.iitb.ac.in");
		  test.mail("rajs@cse.iitb.ernet.in", headerbody);
	 }
	 */
}
