
import java.io.*;
import java.lang.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** This program is a simple HTTP SQL Query Engine . 
 * It implements  function like insert data/tuples, update, run query,
 * delete tuples/tables .
 * @author Rajendra Sansare 
 * SQLEngine inherits connection in SharedConnection and only SQLEngine 
 * can close the connection .The entire idea being that there is only one 
 * connection from which all different program codes access the Database.
 */

public class SQLEngine extends SharedConnection {
	 
	 private Keywords2UpperCase k2uc;
	 private static String schema;

	 public SQLEngine() {
		  super();
		  k2uc = new Keywords2UpperCase();
	 }
	 

	 /** @param query -  query given in proper SQL query format
	  *  @param pw    - PrintWriter object 
	  */
	 
	 public void execQuery(String query, PrintWriter pw) {
		  /* Convert the SQL keywords to uppercase */ 
		  query = k2uc.keytoUpperCase(query);
		  
	 	  PreparedStatement pstmt;
	      ResultSet rs;
	      ResultSetMetaData rsmd;
		  
		  try {
		  pstmt = SharedConnection.con.prepareStatement(query);
		  rs = pstmt.executeQuery();
		  rsmd = rs.getMetaData();
		  
		  /**  The  below code is for the user benefit , gives information 
		   * regarding columns */
		  /*
		  pw.println( " Number of Columns : " + rsmd.getColumnCount());
		  for (int k = 1; k <= rsmd.getColumnCount(); k++) {
			   pw.println("<br> Name of Col : " + rsmd.getColumnLabel(k) + "  ");
			   switch (rsmd.isNullable(k)) {
					case rsmd.columnNoNulls: 
						 pw.println(k +" Does not allow Null values");
						 break;
					case rsmd.columnNullable:
						 pw.println(k +" Allows null Values");
						 break;
					case rsmd.columnNullableUnknown:
						 pw.println(k +" Nullability Unknown");
						 break;
			   }
		  }
		  */

		  
		  pw.println("<CENTER>");
		  pw.println("<TABLE border=0 cellspacing=2 cellspacing=2>");
		  pw.println("<TR><TD nowrap bgcolor=cccccc>");
		  
		  pw.println("<TABLE width=100% border=0 cellspacing=2 cellpadding=2 nosave><tr>");
		  for (int i = 1; i <= rsmd.getColumnCount(); i++) {
			   pw.println("<td nowrap bgcolor=B080FF><FONT color=#000000>" + rsmd.getColumnName(i) + "</FONT></td>");
		  }
		  pw.println("</tr>");
		  while (rs.next()) {
			   pw.println("<tr>");
			   for( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
					pw.println("<td nowrap bgcolor=ffffff><FONT color=#000000>" + rs.getString(rsmd.getColumnName(i)) + "</FONT></td>");
			   }
			   pw.println("</tr>");
		  }
		  pw.println("</TABLE>");

		  pw.println("</TD></TR>");
		  pw.println("</TABLE>");
		  pw.println("</CENTER>");
		  
		  pstmt.clearParameters();
		  pstmt.close();

		  } catch (SQLException sqle) {
			   pw.println("A problem occured while executing your Query request .Please try again.");
			   System.out.println("SQLException in execQuery" + sqle);
			   sqle.printStackTrace();
		  }
	 }
	 
	 
	 /** 
	  * @param query -  query given in proper SQL query format
	  * @return String[] result - where each array cell contains a row of the result of the query
	  */
	 public String[] execQuery(String query) {
		  query = k2uc.keytoUpperCase(query);

	 	  PreparedStatement pstmt;
	      ResultSet rs;
	      ResultSetMetaData rsmd;
		  String[] result; 
		  try {
		  pstmt = SharedConnection.con.prepareStatement(query);
		  rs = pstmt.executeQuery();
		  
		  int no_of_rows = 1, count = 0;
		  /*** to get number of rows ** EXTREMELY SILLY WAY **/
		  while (rs.next()) {
			   no_of_rows++;
		  }
		  
		  result = new String[no_of_rows];
		  rs = pstmt.executeQuery();
		  rsmd = rs.getMetaData();
		  
		  result[count] = "";
		  for (int i = 1; i <= rsmd.getColumnCount(); i++) {
			   result[count] += rsmd.getColumnName(i) + "\t" ;
		  }
		  
		  while (rs.next()) {
			   count++;
			   result[count] = "";
			   for( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
					result[count] += rs.getString(rsmd.getColumnName(i)) + "\t";
			   }
		  }
		  
		  pstmt.clearParameters();
		  pstmt.close();
		  
		  } catch (SQLException sqle) {
			   System.out.println("A problem occured while executing your Query request .Please try again.");
			   System.out.println("SQLException in execQuery" + sqle);
			   sqle.printStackTrace();
			   return null;
		  }
		  
		  return result;
	 }
		  

	 /** 
	  * This function does an executeUpdate to enter the data tuple in the requested table 
	  * delete tuples, update tuples . 
	  * @param String insertdata  - Query  in SQL format
	  * @return String the outcome of the executeUpdate() statement
	  */

	 public String InsertData(String insertdata) {
	 	  PreparedStatement pstmt;
		  String insertresult = "";
		  
		  try{
		  pstmt = SharedConnection.con.prepareStatement(insertdata);
		  insertresult =" " + pstmt.executeUpdate() + " row has been inserted .";
			   System.out.println(" pstmt.executeUpdate() passed " ); 
			   
		  pstmt.clearParameters();
		  return insertresult;
		  } catch (SQLException sqle) {
			   System.out.println("SQLException in InsertData " + sqle);
			   return "Error while inserting data into the database";
		  }
	 }

	 /* Clean up the SQL database connection */ 
	 public void destroy() {
		  try {
			   SharedConnection.con.close();
			   System.out.println("Connection closed successfully");
		  } catch (SQLException e) {
			   while (e != null) {
					//log("SQLException: " + e.getSQLState() + '\t' + e.getMessage() + '\t' + e.getErrorCode() + '\t');
					e = e.getNextException();
			   }
		  } catch (Exception e) {
			   e.printStackTrace();
		  }
	 }
			   
	 /* Servlet Information */
	 public String getServletInfo() {
		  return " Database Connection Servlet  Author : Rajendra Sansare Copyright 2000 ";
	 }
}
