import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** This class shows the CSR , set classification details like tags and keywords and
 * provides an interface  to add new segments to the classification .
 * @author Rajendra Sansare 
 */

public class ShowClassificationServlet extends HttpServlet implements SingleThreadModel {
	 
	 private SQLEngine sfe;
	 private HTMLtags htag;

	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
		  sfe  = new SQLEngine();
		  htag = new HTMLtags();
	 }
	 

	 public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();
		  
		  String actionurl = request.getScheme() + "://";
		  actionurl += request.getServerName() + ":";
		  actionurl += request.getServerPort();
		  actionurl += "~/servlet/ShowClassificationServlet"; /* name of the servlet */
		  
		  String[] Classify = request.getParameterValues("Classify");
		  int index = Integer.parseInt(Classify[0]);
		  
		  String query = "";
		  htag.header(pw);
		  
		  pw.println("<FORM  method=POST action="+actionurl+">");
		  pw.println("<br><input type=hidden name=class value=class"+index+">");

		  /** Note */
		  pw.println("<font color=#ff0000><b> NOTE </b></FONT><BR>");
		  pw.println("<FONT color=#ffffff><H1>&nbsp;For Numeric Tags value can be in range 0 - 9.</H1>");
		  pw.println("<H1>&nbsp;For Alphabetic Tags value is strictly a fixed number of characters.</H1><BR>");
		  pw.println("</font><HR><BR>");
		  
		  query = "SELECT * FROM class"+index;
		  pw.println("<B><FONT COLOR=#FFFFFF> Customer represents an </FONT></B>");
		  sfe.execQuery(query,pw);
		  printTable(pw);
		  
		  pw.println("<CENTER><input type=submit value=Submit>");
		  pw.println("<input type=reset  value=Reset></CENTER>");
		  pw.println("</FORM>");

		  htag.footer(pw);
	 }

	  

	 public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		  response.setContentType("text/html");
		  PrintWriter pw = response.getWriter();

		  htag.header(pw);
		  pw.println("<B> Received </B>");
		  
		  String Class = request.getParameterValues("class")[0];
		  String tag = request.getParameterValues("classtag")[0];
		  String keyword = request.getParameterValues("keyword")[0];
		  pw.println(" Class "+ Class +" tag "+ tag +" keyword "+ keyword + "<BR>");  
		  
		  InsertintoTables(Class,tag,keyword,pw);
		  htag.footer(pw);
	 }

	 /**
	  * @param String Class - one of the classification tables class (1 to 5)
	  * @param String tag - the tag for the identification of the classification .This 
	  * depends on the type of classification and is of specific length for specific classes.
	  * This is also used for the generation of customer tag.
	  * @param String keyword - A short description of the classification. This gets
	  * shown up on the HTML questionnaire.
	  * @param PrintWriter pw 
	  */
	 public void InsertintoTables(String Class,String tag, String keyword,PrintWriter pw) {
		  String instmt = "";
		  boolean anynullval = true; 
		  
		  if (Class.equals("") || Class.equals(null)) anynullval = false;
		  if (tag.equals("") || tag.equals(null)) anynullval = false;
		  if (keyword.equals("") || keyword.equals(null)) anynullval = false;

		  if (anynullval) {
			   pw.println("<font color=#ffffff> For Table" + Class +" :<br>"); 
			   instmt = "INSERT INTO "+ Class +" VALUES ('"+ tag.trim() +"','"
					+ keyword.trim() +"')"; 
			   pw.println( sfe.InsertData(instmt) + "</font>" );
		  } else {
			   // do nothing
			   pw.println("<font color=#ffffff> No value has been inserted as a null input is given </font><br>"); 
		  }
	 }
		  

	 /**
	  * @param PrintWriter pw
	  */
	 public void printTable(PrintWriter pw) {
		  pw.println("<BR><BR>");
		  pw.println("<center><table BORDER=0 CELLSPACING=2 CELLPADDING=2 COLS=1 WIDTH=75% BGCOLOR=#CCCCCC >");
		  pw.println("<tr><td><center>");
		  pw.println("<table BORDER=0 COLS=2 WIDTH=100% BGCOLOR=#B080FF NOSAVE >");
		  pw.println("<tr NOSAVE>");
		  pw.println("<td NOSAVE>");
		  pw.println("<center><font color=#000000>Classification Tag</font></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><font color=#000000> Keyword Description </font></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  
		  pw.println("<tr>");
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=classtag size=27 value=></center>");
		  pw.println("</td>");
		  
		  pw.println("<td>");
		  pw.println("<center><input type=textbox name=keyword size=27 value=></center>");
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table>");
		  pw.println("</center>");
		  
		  pw.println("</td>");
		  pw.println("</tr>");
		  pw.println("</table></center>");
		  pw.println("<HR>");
	 }
}
