import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** 
 * This servlet adds reviewers to the PC.
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 18:03:17 IST 2000
 */

public class AddReviewer extends HttpServlet {

	 /** 
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** 
	  * Add Reviewers, Admin types in email adds of reviewers (comma separated)
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID"); 

		  /* Print form */
		  ShowStuff.printHeader("Add Reviewers",out);
		  out.println("<body>");

		  ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/AddReviewer",out);

		  out.println("<input type=\"text\" name=\"emails\" size=60>");
		  out.println("<br><br><input type=\"Submit\" value=\"Add\">");
		  out.println("</form>");
		  ShowStuff.printFooter(out);
	 }

	 /** 
	  * Actually adds them into the DB.
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");

		  Connection con=null;
		  try {
			   con=DB.getConnection();
			   Statement st=con.createStatement();
			   String revId="";
			   String updateStr="";
			   ResultSet rs=st.executeQuery("SELECT * FROM PERSON");
			   ResultSetMetaData rt=rs.getMetaData();
			   int cnt=rt.getColumnCount()-1;
			   String zots="";
			   for (int i=0;i<cnt;i++) {
					zots+=",'0'";
			   }

			   StringTokenizer stz=new StringTokenizer(req.getParameter("emails"),",");

			   while (stz.hasMoreTokens()) {
					revId=(String)stz.nextToken();
					if (! (revId.equalsIgnoreCase(ID)) ) {
						 updateStr="INSERT INTO PERSON VALUES('"+revId+"'"+zots+")";
						 st.executeUpdate(updateStr);
					}
					st.executeUpdate("INSERT INTO REVIEWER VALUES('"+revId+"','0','wbcm')");
					try {
						 Mail.sendMail(revId,Config._MAIL_ID,"Welcome Aboard PC Com","Yipee! You are a reviewer now"); 
					} catch (Exception e) { System.out.println("Couldnt send mail to"+revId); }
			   }

			   con.close();    /* Close the connection */

			   /* Print OK page */
			   ShowStuff.printHeader("Reviewers Added",out);
			   out.println("<body>");
			   out.println("<font color=blue> Reviewers have been added </font><br><br><hr size=1>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoisit)+"\">here</a> to go to your main page.<br><hr size=1>");
			   ShowStuff.printFooter(out);
		  } catch (SQLException e) { e.printStackTrace(); ShowStuff.throwError("Database Access Error",out); if (con != null) {con=null; } }
	 }
}
