import java.io.*;
import java.util.*;
import java.net.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** This servlet communicates with the PaperAssignment applet to give
 * it all the info required in the form of a hashtable
 * @author Aameek Singh
 * @version 1.00, Sun Nov 12 17:01:04 IST 2000
 */

 
public class AssignPapers extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** Give info abt the tentative assignments to the applet in the 
	  * form of a hashtable.
	  *  @param res HttpServletResponse
	  *  @param req HttpServletRequest
	  */  
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);

		  /* Checking that the user is Admin only */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }


		  Connection con=null;

		  try {
			   /* Open a DB Connection */
			   con=DB.getConnection();
			   Statement st=con.createStatement();
			   ResultSet rs=st.executeQuery("SELECT * FROM FINALASSIGNMENTS");

			   /* Hashtable of all tentative assignments */
			   Hashtable currentAssignments=new Hashtable();
			   Vector tmp=null;
			   int count=0;
			   while (rs.next()) {
					tmp=new Vector();
					if (currentAssignments.containsKey(rs.getString(1))) {
						 tmp=(Vector)currentAssignments.get(rs.getString(1));
						 tmp.addElement(rs.getString(2));
					} else {
						 count++;
						 tmp.addElement(rs.getString(2));
					}
					currentAssignments.put(rs.getString(1),tmp);
			   }

			   tmp=new Vector();
			   rs=st.executeQuery("SELECT EMAIL FROM REVIEWER");

			   /* Also send emails of all reviewers */
			   while (rs.next()) {
					tmp.addElement(rs.getString(1));
			   }
			   currentAssignments.put("All",tmp);

			   /* Sending total number of papers */
			   currentAssignments.put("Count",count+"");


			   /* Throw tentative assignments */
			   ObjectOutputStream oos=new ObjectOutputStream(res.getOutputStream());
			   oos.writeObject(currentAssignments);
		  } catch (Exception e) { 
			   e.printStackTrace();
			   if (con != null) con=null;
		  }

	 }

	 /** Recieve the hashtable of modified assignments and store that in DB 
	  *  @param req HttpServletRequest
	  *  @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);

		  /* Checking that the user is Admin only */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  
		  /* Recieve hashtable */  
		  ObjectInputStream objin=new ObjectInputStream(req.getInputStream());
		  Object obj=null;
		  try {
			   obj=objin.readObject();
		  } catch (Exception e) { System.out.println("Cannot read from applet");}
		  Hashtable finalAssignments=(Hashtable)obj;
		  Connection con=null;
		  Vector tmp=null;

		  try {
			   con=DB.getConnection();
			   Statement st=con.createStatement();

			   /* Store in DB */
			   Enumeration papers=finalAssignments.keys();
			   Enumeration reviewers=null;
			   st.executeUpdate("DELETE FINALASSIGNMENTS");
			   while (papers.hasMoreElements()) {
					int paperId=Integer.parseInt( (String)papers.nextElement() );
					tmp=(Vector)finalAssignments.get(paperId+"");
					reviewers=tmp.elements();
					while (reviewers.hasMoreElements()) {
						 st.executeUpdate("INSERT INTO FINALASSIGNMENTS VALUES("+paperId+",'"+reviewers.nextElement()+"')");
					}
			   }
		  } catch (Exception e) { 
			   e.printStackTrace();
			   if (con != null) con=null;
		  }

	 }
}
