import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet changes the password of any user(admin/reviewer/contact-author)
 * On invoking the servlet using "GET" method, the doGet() method presents an HTML 
 * form with fields to enter and confirm new password.The user is identified using 
 * HttpSession.This form will do a "POST" to do this servlet only.Then the doPost()
 * method will make the appropriate changes in DB 
 *
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 17:31:37 IST 2000
 */

public class ChangePassword extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /**
	  * Puts the new submitted password into the DB 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  String whoisit=(String)session.getValue("whoami"); /* returns "Author"/"Reviewer"/"Admin" */

		  if (whoisit==null) {            /* This means invalid session. So abort! */
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID"); /* returns the userId with which the user logged in */
		  String pwd1=req.getParameter("pwd1");     /* New password */
		  String updateStatement;
		  String whom=req.getParameter("whom"); /* A. if admin is changing an author/reviewer passwd*/
          boolean flag=false;
		  

		  if ( (whoisit.equalsIgnoreCase("Admin")) && (whom != null) ) {   /* Case A. */
			   whoisit=whom;
			   ID=(String)req.getParameter("userId");   /* Get UserId */
			   flag=true;
		  }


		  /* In case of author, the update has to be made in table Paper else in table $whoisit*/
		  if (whoisit.equalsIgnoreCase("Author")) {
			   updateStatement="UPDATE PAPER SET PASSWORD=? WHERE PAPERID='"+ID+"'";
		  } else {
			   updateStatement="UPDATE "+whoisit.toUpperCase()+" SET PASSWORD=? WHERE EMAIL='"+ID+"'";
		  }

		  Connection con=null;
		  try {
			   /* Open up a DB connection */ 
			   con=DB.getConnection(); 

			   /* Using prepared statement to prevent a "'" gotch! */
			   PreparedStatement pst=con.prepareStatement(updateStatement);
			   pst.setString(1,pwd1);
			   pst.executeUpdate();   /* Update */
			   con.close();    /* Close connection */

			   /* In case admin is changing passwd for author/reviewer redo changes to ID and whoisit */
			   if (flag) {
					whoisit="Admin";
					ID=(String)session.getValue("ID");
			   }

			   /* Give OK message */
			   ShowStuff.printHeader("Password Changed Successfully",out);
			   out.println("<body>");
			   out.println("<font color=blue> Your password has been changed. </font><br><br><hr size=1>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoisit)+"\"> here </a> to go to your main page <br><br><br><br><br><br><br><br><br>");
			   ShowStuff.printFooter(out);
		  } catch (SQLException e) { ShowStuff.printHeader("Error",out);

			   ShowStuff.throwError("Error!","Password cannot be changed",out); if (con!=null) {con=null;}
		  ShowStuff.printFooter(out);

		  }
	 }

	 /** 
	  * Gives a form to enter new password and submits the same form to this very servlet 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Similar Session checking */
		  String whoisit=(String)session.getValue("whoami");

		  if (whoisit==null) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  /* Give the form with the action tag as this servlet and method=post. 
		   * Also doing some checking for passwords entered using Javascript */
		  ShowStuff.printHeader("Change Password",out,false);
		  out.println("<script language=\"javascript\">");
		  out.println("function isblank(s) {");
		  out.println("        for(var i = 0; i < s.length; i++) {");
		  out.println("	           var c = s.charAt(i);");
		  out.println("if ((c != ' ') && (c != '\\n') && (c != '\\t')) return false;} return true;}");
		  out.println("function check() {");
		  out.println("if (isblank(document.changePasswd.pwd1.value) || isblank(document.changePasswd.pwd2.value)) {");
		  out.println("alert (\"Field Empty\"); return false; ");
		  out.println("} else {");
		  out.println("if (document.changePasswd.pwd1.value!=document.changePasswd.pwd2.value) {");
		  out.println("alert(\"Passwords Dont Match\");");
		  out.println("return false; } else { return true; }}}");		
		  out.println("</script>");
	      out.println("</head> <body bgcolor=#ffffff marginheight=2 marginwidth=2 topmargin=2 leftmargin=2 alink=#0000ff vlink=#996699 link=#6699cc>");
	      out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
          out.println("<tr bgcolor=#000080><td width=150>&nbsp;</td><td width=610> &nbsp;</td> </tr>");
          out.println("<tr><td bgcolor=#000080 width=150>&nbsp;</td><td width=610 colspan=4 bgcolor=#000000>&nbsp;</td></tr></table>");
		 // pw.println("<table border=0 cellspacing=0 cellpadding=0 height=21><tr><td bgcolor=#000000 width=610 align=center>&nbsp;</td></tr></table>");
         // pw.println("</td></tr></table>");
		  out.println("<table width=760 border=0 cellspacing=0 cellpadding=0><tr valign=top><td width=150 bgcolor=#000080>");
          out.println("<table width=150 border=0 cellspacing=0 cellpadding=0><tr><td width=150 colspan=3></td></tr><tr><td width=150 colspan=3></td></tr></table><br>");
          out.println("<td width=610><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width=100%><TR><TD width=8>&nbsp;</TD></tr>");
          out.println("<TR><TD width=10> &nbsp; </td> <TD><font class=TITLEFONT size=4 color=000080><b>Change Password</b></font><p>");

		  out.println("<form name=\"changePasswd\" onSubmit=\"return check();\" method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">");
		  out.println("Enter New Password: ");
		  ShowStuff.passwdBox("pwd1",20,10,out);
		  out.println("<br>");
		  out.println("Re-enter  Password: ");
		  ShowStuff.passwdBox("pwd2",20,10,out);
		  out.println("<br>");
		  ShowStuff.submitButton("Change",out);
		  out.println("</form><br><br><br><br><br><br><br>");
		  ShowStuff.printFooter(out);
	 }
}
