import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 18:03:17 IST 2000
 */

public class CreateReviewer extends HttpServlet {
     
	 /** 
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }
          
		  String ID=(String)session.getValue("ID"); 
          
		  /* Print form */
		  ShowStuff.printHeader("Create Reviwers",out);
		  out.println("<body>");

		  ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/CreateReviwer",out);
		  
		  out.println("<textarea name=\"emails\" rows=10 cols=80></textarea>");
		  out.println("<br><br><input type=\"Submit\" value=\"Create\">");
		  out.println("</form>");
		  ShowStuff.printFooter(out);
	 }

	 /** 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");
		  String emails=req.getParameter("emails");
		  StringTokenizer str=new StringTokenizer(emails,"\n");

		  Connection con=null;
		  try {
               con=DB.getConnection();
			   Statement st=con.createStatement();

               while (str.hasMoreTokens()) {
					st.executeUpdate("INSERT INTO REVIEWER VALUES('"+str.nextToken()+",'wbcm')");
			   }
			   
			   con.close();    /* Close the connection */
			   /* Print OK page */
			   ShowStuff.printHeader("Reviewers Created",out);
			   out.println("<body>");
			   out.println("<font color=blue> Message has been posted </font><br><br><hr size=1>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoisit)+"\">here</a> to go to your main page.<br><hr size=1>");
		       ShowStuff.printFooter(out);
		  } catch (SQLException e) { ShowStuff.throwError("Database Access Error",out); if (con != null) {con=null; } }
	 }
}
