import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet checks whether the participation and paper submission
 * dates have passed and acordingly displays appropriate messages 
 * 
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 17:34:55 IST 2000
 */

public class DateServlet extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /**
	  * Filters participants and author registrations.
	  * @param req HttpServletRequest
	  * @param req HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  int val=Integer.parseInt(req.getParameter("val"));

		  java.util.Date PresentDate = new java.util.Date();

		  if (val==0) {      /* Participant trying for reg */
			   if (PresentDate.before(Gen.getParticipationDeadline() )) {
					res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
					res.setHeader("Location","http://"+Config._HTMLROOT+"ParticipantRegistration.html");
			   } else {
					ShowStuff.printHeader("Participation Deadline Past",out);
					out.println("Rest of participation on site");
					ShowStuff.printFooter(out);
			   }
		  } else {          /* Author trying for submitting a paper */
			   if (PresentDate.before(Gen.getPaperSubmissionDeadline())) {
					res.setStatus(res.SC_MOVED_TEMPORARILY);   /* Redirect Servlet */
					res.setHeader("Location","http://"+Config._HTMLROOT+"PaperReg.html");
			   } else {
					ShowStuff.printHeader("Paper Submission Deadline Past",out);
					out.println("You are late my dear ...");
					ShowStuff.printFooter(out);
			   }
		  }

	 }
}
