import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet edits a mailing list for the admin.
 * 
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 18:03:17 IST 2000
 */

public class EditMailingList extends HttpServlet {

	 /** 
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** 
	  * Print the form to modify email ids of the ppl in this mailing list
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!whoisit.equalsIgnoreCase("Admin")) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ListId=req.getParameter("ListId");
		  if (ListId.equals("")) {
			   ShowStuff.throwError("Error!","Which Mailing List to edit buh ?",out);
		  } else {

			   if (ListId==null) {
					ShowStuff.throwError("Error!","Invalid Access",out);
			   } else {

					/* Print form */
					ShowStuff.printHeader("Mailing List: "+ListId,out);
					out.println("<body>");

					ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/EditMailingList",out);
					out.println("<input type=\"hidden\" value=\""+ListId+"\" name=\"ListId\">");
					out.println("Please enter email ids in the text area. One email id per row<br>");

					Connection con=null;
					String val="";
					try {
						 con=DB.getConnection();
						 Statement st=con.createStatement();
						 ResultSet rs=st.executeQuery("SELECT EMAIL FROM MAILINGLIST WHERE LISTID='"+ListId+"'");
						 while (rs.next()) {
							  val += rs.getString(1)+"\n";
						 }
					} catch (Exception e) {if (con != null) { con = null; } }

					out.println("<textarea name=\"emails\" rows=10 cols=50>"+val+"</textarea>");
					out.println("<br><br><input type=\"Submit\" value=\"Edit\">");
					out.println("</form>");
					ShowStuff.printFooter(out);
			   }
		  }
	 }

	 /** 
	  * Create the mailing list
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!whoisit.equalsIgnoreCase("Admin")) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ListId=req.getParameter("ListId");
		  String ID=(String)session.getValue("ID");

		  Connection con=null;
		  try {
			   con=DB.getConnection();
			   Statement st=con.createStatement();

			   st.executeUpdate("DELETE FROM MAILINGLIST WHERE LISTID='"+ListId+"'");

			   String createStatement="INSERT INTO MAILINGLIST VALUES(?,?)";

			   /* Use prepared statement */
			   PreparedStatement pst;

			   StringTokenizer stz=new StringTokenizer(req.getParameter("emails"),"\n");
			   while (stz.hasMoreTokens()) {
					pst=con.prepareStatement(createStatement);
					pst.setString(1,ListId);
					pst.setString(2,(String)stz.nextToken());
					pst.executeUpdate();
			   }

			   con.close();    /* Close the connection */
			   /* Print OK page */
			   ShowStuff.printHeader("Edited Mailing List",out);
			   out.println("<body>");
			   out.println("<font color=blue>Mailing List \""+ListId+"\" has been edited.</font><br><br><hr size=1>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+whoisit+"Servlet\">here</a> to go to your main page.<br><hr size=1>");
			   ShowStuff.printFooter(out);
		  } catch (Exception e) { ShowStuff.throwError("Error","Couldnt edit mailing list",out); if (con != null) {con=null; } }
	 }
}
