import java.sql.*;
import java.io.*;
import java.util.*;

public class Jdbcapp {
	 static String argt[];
	 static String usage="Usage: java Jdbcapp <username> <passwd> <-qr query>|<-in tablename>|<-dl tablename>|<-hp [tablename]>";
	 static int flag=-1;
	 static Connection con=null;

	 public static void main(String args[]) throws Exception {
		  argt=args;

		  /* Wrong number of arguments*/
		  if ((args.length>4)||(args.length<3)) {
			   NaReNaNa();
		  }
		  /* Finding out what to do */
		  if (args[2].equals("-qr")) {flag=0;} 
		  else if (args[2].equals("-in")) {flag=1;}
		  else if (args[2].equals("-dl")) {flag=2;} 
		  else if (args[2].equals("-hp")) {flag=3;} 
		  else {NaReNaNa();}

		  /* Check for invalid arguments */
		  check(flag);

		  /* Open up a DB connection */
		  DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		  try {
			   con= DriverManager.getConnection("jdbc:oracle:thin:@:1521:GEN",args[0],args[1]);
		  } catch (SQLException sx) { System.out.println("Database Access Error. Check username and passwd."); }

		  /* Do work */ 
		  switch(flag) { 
			   case 0: execQuery(argt[3]);   break;
			   case 1: insertStuff(); break;
			   case 2: deleteStuff(); break;
			   case 3: help();        break;
		  }
	 }

	 /* Prints the correct usage and exits */
	 static void NaReNaNa() {
		  System.out.println(usage);
		  System.exit(0);
	 }

	 /* Check validity of arguments */
	 static void check(int f) {
		  switch(flag) {
			   case 3:  break;
			   case -1: NaReNaNa(); break;
			   default: if (argt.length<4) { NaReNaNa(); }
		  }
	 }

	 /* Executes the query passed as argument */
	 static void execQuery(String query) {
		  try {
			   Statement st=con.createStatement();
			   ResultSet rs=st.executeQuery(query);   /* Execute query */
			   ResultSetMetaData rt=rs.getMetaData(); /* Getting column information */
			   int cnt=rt.getColumnCount();
			   for (int i=1;i<=cnt;i++) {
					System.out.print(rt.getColumnName(i)+"\t");
			   } 
			   System.out.println();
			   System.out.println("-----------------------------------------------------");
			   while (rs.next()) {
					for (int i=1;i<=cnt;i++) {
						 System.out.print(rs.getString(i)+"\t");
					}
					System.out.println();
			   }
		  } catch (SQLException se) { System.out.println("Database Access Error."); }
	 }

	 /* The insert operator */
	 static void insertStuff() {
		  try {
			   ResultSet rs=null;
			   Statement st=con.createStatement();
			   /* The following try block just checks whether the given table
				* name actually exists or not. In case it doesnt, appropriate
				* mesg is displayed */
			   try {
					rs=st.executeQuery("SELECT * FROM "+argt[3]);
			   } catch (SQLException x) { System.out.println("Database Access Error. Check Table name."); System.exit(0);}
			   ResultSetMetaData rt=rs.getMetaData();
			   int cnt=rt.getColumnCount();
			   DataInputStream indata=new DataInputStream(System.in);
			   String tuple[]=new String[cnt];
			   for (int i=1; i<=cnt; i++) {
					System.out.println("Enter value for "+rt.getColumnName(i));
					try {
						 tuple[i-1]=indata.readLine(); /* Storing fields in an array */
					} catch (IOException ioe) { System.out.println("IO Error"); System.exit(0); }
			   }
			   /* Preparing the insert statement */
			   String insStatement="INSERT INTO "+argt[3]+" values(";
			   for (int i=1;i<=cnt;i++) {
					if (i==1) {
						 insStatement+="\'"+tuple[0]+"\'";
					} else {
						 insStatement+=",\'"+tuple[i-1]+"\'";
					}
			   }
			   insStatement+=")";
			   st.executeUpdate(insStatement); /* Actually insert in database */
			   System.out.println("Done");
		  } catch (SQLException se) { System.out.println("Database Access Error."); }

	 }

	 /* The delete operator */
	 static void deleteStuff() {
		  try {
			   ResultSet rs=null;
			   Statement st=con.createStatement();
			   /* The following try block just checks whether the given table
				* name actually exists or not. In case it doesnt, appropriate
				* mesg is displayed */
			   try {
					rs=st.executeQuery("SELECT * FROM "+argt[3]);
			   } catch (SQLException x) { System.out.println("Database Access Error. Check Table name."); System.exit(0);}
			   DataInputStream indata=new DataInputStream(System.in);
			   System.out.println("Enter the where clause of the delete query. Please dont include the keyword \"WHERE\"");
			   String whereClause="";
			   try {
					whereClause=indata.readLine();			   
			   } catch (IOException ex) {System.out.println("IO Error"); System.exit(0); }
			   String delStatement="DELETE FROM "+argt[3]+" WHERE "+whereClause; /* The delete query */
			   try {
					st.executeUpdate(delStatement); /* Actually delete from database */
			   } catch (SQLException x) { System.out.println("Database Access Error. Check WHERE condition."); System.exit(0);}
			   System.out.println("Done");
		  } catch (SQLException se) { System.out.println("Database Access Error."); }
	 }

	 /* The help operator */
	 static void help() {
		  boolean flag=false;
		  try {
			   String tableNamePattern;
			   if (argt.length==3) {  /* No table name given */
					tableNamePattern="%";
					flag=true;
			   } else  {
					/* The following try block just checks whether the given table
					 * name actually exists or not. In case it doesnt, appropriate
					 * mesg is displayed */
					try {
						 Statement st2=con.createStatement();
						 ResultSet rs2=st2.executeQuery("SELECT * FROM "+argt[3]);
					} catch (SQLException x) { System.out.println("Database Access Error. Check Table name."); System.exit(0);}
					tableNamePattern=argt[3];
			   }
			   String schemaPattern=argt[0].toUpperCase();
			   DatabaseMetaData dmt=con.getMetaData();  /* Get info abt all tables */
			   ResultSet rs1=dmt.getTables(null,schemaPattern,tableNamePattern,null);
			   ResultSetMetaData rt1=rs1.getMetaData();	
			   Statement st=con.createStatement();
			   ResultSet cols;
			   ResultSetMetaData rtemp;
			   while (rs1.next()) {
					for (int i=1; i<=rt1.getColumnCount();i++) {
						 System.out.print(rt1.getColumnName(i)+"\t");
					}
					System.out.println("COL_NAMES");  /* Will be printing Column Names of each table */
					System.out.println("================================================================");
					if (flag) { tableNamePattern=rs1.getString(3); }
					for (int i=1; i<=rt1.getColumnCount();i++) {  /* Printing results */
						 System.out.print(rs1.getString(i)+"\t");
					}
					/* Retreiving col names */
					cols=st.executeQuery("SELECT * FROM "+rs1.getString(3));
					rtemp=cols.getMetaData();
					if (cols.next()) {
						 for (int i=1;i<=rtemp.getColumnCount();i++) {
							  if (i==1) 
								   System.out.print(rtemp.getColumnName(i));
							  else 
								   System.out.print(","+rtemp.getColumnName(i));
						 }
					}
					System.out.println("\n");	
					System.out.println("Columns Info\n-=-=-=-=-=-=-=-");
					/* Getting col info */
					cols=dmt.getColumns(null,schemaPattern,tableNamePattern,"%");
					rtemp=cols.getMetaData();
					for (int i=1; i<=rtemp.getColumnCount();i++) {
						 System.out.print(rtemp.getColumnName(i)+"\t");
					}
					System.out.println("\n");	

					while (cols.next()) {
						 for (int i=1;i<=rtemp.getColumnCount();i++) {
							  System.out.print(cols.getString(i)+"\t");
						 }
						 System.out.println();
					}
					System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-");
				    System.out.println();
			   }
		  } catch (SQLException x) { System.out.println("Database Access Error"); }
	 }
}
