import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** This servlet mails all authors whether their papers have been 
 * accpted or not automatically, when the Admin is finally done 
 * with accepting all papers.
 * @author Mithun Arora
 * @version 1.00 Nov 14 01:30:45 IST 2000
 *
 */ 

public class MailAuthors extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config)
		 throws ServletException {
		  super.init(config);
	 }

	 /** Reads from the tables AUTHOREDBY and ACCEPTEDPAPER and sends 
	  * different mails to authors whose papers have been accepted and 
	  * whose papers have not been accepted.
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */

	 public void service(HttpServletRequest req, HttpServletResponse res) 
		 throws ServletException,IOException 
	 {
		   HttpSession session=req.getSession(false);
			res.setContentType("text/html");
			PrintWriter out=res.getWriter();

			/* Check session validity. Only Admin allowed */
			String whoisit=(String)session.getValue("whoami");

			if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
				throw new UnavailableException(this,"Invalid Access Attempt");
			}
		   ShowStuff.printHeader("Mails Sent", out); 	
			
			Connection con=null;
			try
			{
				 con=DB.getConnection();
				 Statement stmt=con.createStatement();
				 String mailFrom=Config._MAIL_ID;
				 String mailTo=null;
				 String Subject=null;
				 String Content=null;
				 /* For authors whose papers are accepted. */
				 ResultSet rs=stmt.executeQuery("SELECT EMAIL FROM AUTHOREDBY WHERE PAPERID IN (SELECT PAPERID FROM ACCEPTEDPAPER)");
				 while(rs.next())
				 {
					 mailTo=rs.getString("EMAIL");
					 Subject="Paper Accepted";
					 Content="Dear Author, We are pleased to inform you that your paper has been selected for our conference.";
				    try {
						 Mail.sendMail(mailTo, mailFrom, Subject, Content);
					 } catch (Exception e) {
						 ShowStuff.throwError("ERROR!", "Couldn't send email", out);
					 }
				 }
				 
				 /* For authors whose papers are not accepted. */
				 rs=stmt.executeQuery("SELECT EMAIL FROM AUTHOREDBY WHERE PAPERID NOT IN (SELECT PAPERID FROM ACCEPTEDPAPER)");
				 while(rs.next())
				 {
					 mailTo=rs.getString("EMAIL");
					 Subject="Paper Not Accepted";
					 Content="Dear Author, This is to inform you that your paper has not been selected for our conference.";
				    try {
						 Mail.sendMail(mailTo, mailFrom, Subject, Content);
					 } catch (Exception e) {
						 ShowStuff.throwError("ERROR!", "Couldn't send email", out);
					 }
				 }
				 out.println("Mails have been sent.");
				 out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/AdminServlet\">here</a> to go back to your mainpage.");
			}  catch (SQLException sqle) {
				ShowStuff.throwError("Database Access Error!!", out);
				if(con!=null) {con=null; }
			}
				ShowStuff.printFooter(out);
		}
}
		
