import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet is used to send mails to ppl.
 * NOTE: Admin can send mail to 1) PC members 2) All participants 3) All authors 
 *             4) A particular mailing list 5) Reviewers of a particular PaperId 
 *             6) General Recipients 
 *       Reviewer can send mail to 1) PC members 2)  Reviewers of a particular PaperId     
 *             3) General Recipients
 *
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 17:34:55 IST 2000
 */


public class MailServlet extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /**
	  * Present the form in which the mail parameters are to be filled and then 
	  * POST it to the same servlet 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Checking that the user is Admin or Reviewer only.*/
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Reviewer") || whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");   /* Id of the user */

		  /* Print out the form */
		  ShowStuff.printHeader("Send Mail",out);
		  ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/MailServlet",out);
		  out.println("<table width=450 border=0 cellspacing=0 cellpadding=0>");
		  out.println("<tr><td>To:</td><td> <select name=\"To\">");
		  out.println("<option value=\"0\">All PC members (leave val blank)</option>");
		  out.println("<option value=\"3\">Reviewers of a Paper. Please give PaperId in val</option>");
		  out.println("<option value=\"5\">Any Recipients (use comma as field separator in val)</option>");

		  if (whoisit.equalsIgnoreCase("Admin")) {
			   out.println("<option value=\"1\">Authors (leave val blank)</option>");
			   out.println("<option value=\"2\">Participants (leave val blank)</option>");
			   out.println("<option value=\"4\">Mailing List (enter list-id in val)</option>");
		  }

		  out.println("</select></td></tr><tr><td>&nbsp;</td><td>");
		  ShowStuff.textBox("val",35,out);
		  out.println("</td></tr><tr><td>&nbsp;</td><td>");
		  ShowStuff.textBox("Subject",30,out);
		  out.println("</td></tr>");
		  out.println("<tr rowspan=10 colspan=4><td>Content: </td><td><textarea name=\"Content\" rows=10 cols=50></textarea></td></tr>");
		  out.println("<tr><td>&nbsp;</td><td>");
		  ShowStuff.submitButton("Send",out);

		  out.println("</td></tr></table>");
          out.println("</form>");

		  out.println("<br><br><br><br><br>");
		  ShowStuff.printFooter(out);
	 }



	 /**
	  * Sends the mail.
	  * @param req HttpServletRequest
	  * @param req HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Checking that the user is Admin or Reviewer only.*/
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Reviewer") || whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");   /* Id of the user */


		  String MailFrom=ID;
		  String Subject=req.getParameter("Subject");
		  String Content=req.getParameter("Content");
		  String query="";

		  /* Find out the Email Ids to which the mail is to be sent */
		  switch (Integer.parseInt(req.getParameter("To"))) {
			   case 0: query="SELECT EMAIL FROM REVIEWER UNION SELECT EMAIL FROM ADMIN"; break;
			   case 1: query="SELECT DISTINCT EMAIL FROM AUTHOREDBY WHERE ISCONTACT=1"; break;
			   case 2: query="SELECT DISTINCT EMAIL FROM PARTICIPANT"; break;
			   case 3: query="SELECT DISTINCT EMAIL FROM FINALASSIGNMENTS WHERE PAPERID="+Integer.parseInt(req.getParameter("val")); break;
			   case 4: query="SELECT DISTINCT EMAIL FROM MAILINGLIST WHERE LISTID='"+req.getParameter("val")+"'"; break;
		  }

		  Connection con=null;
		  try {
			   Stack MailTo=new Stack();
			   if (Integer.parseInt(req.getParameter("To"))==5) {   /* No need of DB access */
					StringTokenizer stz=new StringTokenizer(req.getParameter("val"),",");
					while (stz.hasMoreTokens()) {
						 MailTo.push(stz.nextToken());
					}
			   } else { 
					con=DB.getConnection();
					Statement st=con.createStatement();
					ResultSet rs=st.executeQuery(query);
					while (rs.next()) {
						 MailTo.push(rs.getString(1));  /* Push the recipient email ids in the stack */
					}

					con.close();
			   }
			   try {
					Mail.sendMail(MailTo, MailFrom, Subject, Content);  /* Send Mail */
			   } catch (Exception e) { ShowStuff.throwError("ERROR!","Coudlnt send mail",out);}

			   /* OK message */
			   ShowStuff.printHeader("Mail Sent",out);
			   out.println("<body>");
			   out.println("<font color=blue> Your mail has been sent </font><br><br>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoisit)+"\">here</a> to go to your main page.<br><BR><BR><BR><BR><BR><BR><BR><BR>");
			     out.println("<br><br><br><br><br>");

			   ShowStuff.printFooter(out);

		  } catch (Exception e) {e.printStackTrace(); ShowStuff.throwError("ERROR!","Couldnt send mail",out); if (con != null) { con=null; } }

	 }
}
